IMPLEMENTATION MODULE MATHLIB;

PROCEDURE SinH(num : LONGREAL) : LONGREAL;
VAR
    ex, emx	: LONGREAL;
BEGIN
    ex := Exp(num);
    emx := 1.0 / ex;
    RETURN (ex - emx) / 2.0;
END SinH;

PROCEDURE CosH(num : LONGREAL) : LONGREAL;
VAR
    ex, emx	: LONGREAL;
BEGIN
    ex := Exp(num);
    emx := 1.0 / ex;
    RETURN (ex + emx) / 2.0;
END CosH;

PROCEDURE TanH(num : LONGREAL) : LONGREAL;
VAR
    ex, emx : LONGREAL;
BEGIN
    ex := Exp(num);
    emx := 1.0 / ex;
    RETURN (ex - emx) / (ex + emx);
END TanH;

PROCEDURE Log10(num : LONGREAL) : LONGREAL;
BEGIN
    RETURN Log(num) / M_Ln10;
END Log10;

PROCEDURE ATan2(X, Y : LONGREAL) : LONGREAL;
BEGIN
    RETURN ATan(X / Y);
END ATan2;

PROCEDURE Mod(X, Y : LONGREAL) : LONGREAL;
BEGIN
    RETURN X - (Y * LFLOAT(VAL(LONGINT, ABS(X/Y))));
END Mod;

PROCEDURE Rexp(VAR i : INTEGER; num : LONGREAL) : LONGREAL;
BEGIN
    i := 0;
    WHILE ABS(num) >= 2.0 DO
	num := num / 2.0;
	INC(i);
    END;
    RETURN num;
END Rexp;

END MATHLIB.
