IMPLEMENTATION MODULE Str;

FROM Strings IMPORT
    Assign, Extract, FindNext, FindPrev;
IMPORT Strings;

FROM LongStr IMPORT
    ConvResults, RealToEng, RealToFloat, RealToFixed;
IMPORT LongStr;

FROM LongConv IMPORT
    LengthEngReal, LengthFloatReal, LengthFixedReal;

FROM Conversions IMPORT
    LongBaseToStr, StrBaseToLong;

IMPORT IO;

PROCEDURE Lows(VAR str : ARRAY OF CHAR);
VAR
    i	: CARDINAL;
BEGIN
    IF str[0] <> 0C THEN
	FOR i := 0 TO LENGTH(str)-1 DO
	    IF (str[i] >= 'A') AND (str[i] <= 'Z') THEN
		str[i] := CHR(ORD(str[i]) + (ORD('a')-ORD('A')));
	    END;
	END;
    END;
END Lows;

PROCEDURE Compare(s1, s2 : ARRAY OF CHAR) : INTEGER;
BEGIN
    RETURN INT(Strings.Compare(s1, s2)) - 1;
END Compare;

PROCEDURE Concat(VAR dest : ARRAY OF CHAR;
		 str1 : ARRAY OF CHAR;
		 str2 : ARRAY OF CHAR);
BEGIN
    Strings.Concat(str1, str2, dest);
END Concat;

PROCEDURE Append(VAR dest : ARRAY OF CHAR; str : ARRAY OF CHAR);
BEGIN
    Strings.Append(str, dest);
END Append;

PROCEDURE Copy(VAR dest : ARRAY OF CHAR; str : ARRAY OF CHAR);
BEGIN
    Assign(str, dest);
END Copy;

PROCEDURE Slice(VAR dest : ARRAY OF CHAR;
		str : ARRAY OF CHAR;
		pos, len : CARDINAL);
BEGIN
    Extract(str, pos, len, dest);
END Slice;

PROCEDURE Pos(str, subStr : ARRAY OF CHAR) : CARDINAL;
BEGIN
    RETURN NextPos(str, subStr, 0);
END Pos;

PROCEDURE NextPos(str, subStr : ARRAY OF CHAR; pos : CARDINAL) : CARDINAL;
VAR
    ok	: BOOLEAN;
BEGIN
    FindNext(subStr, str, pos, ok, pos);
    IF NOT ok THEN
	pos := MAX(CARDINAL);
    END;
    RETURN pos;
END NextPos;

PROCEDURE CharPos(str : ARRAY OF CHAR; ch : CHAR) : CARDINAL;
BEGIN
    RETURN Pos(str, ch);
END CharPos;

PROCEDURE RCharPos(str : ARRAY OF CHAR; ch : CHAR) : CARDINAL;
VAR
    pos		: CARDINAL;
    ok		: BOOLEAN;
BEGIN
    ok := FALSE;
    IF str[0] <> 0C THEN
	FindPrev(ch, str, LENGTH(str)-1, ok, pos);
    END;
    IF NOT ok THEN
	pos := MAX(CARDINAL);
    END;
    RETURN pos;
END RCharPos;

PROCEDURE Item(VAR dest : ARRAY OF CHAR;
	       str : ARRAY OF CHAR;
	       sep : CHARSET;
	       n : CARDINAL);
VAR
    len		: CARDINAL;
    i		: CARDINAL;
    j		: CARDINAL;
BEGIN
    i := 0;
    j := 0;
    len := LENGTH(str);
    LOOP
	WHILE (i < len) AND (str[i] IN sep) DO
	    INC(i);
	END;

	WHILE (i < len) AND (NOT (str[i] IN sep)) DO
	    IF n = 0 THEN
		IF j <= HIGH(dest) THEN
		    dest[j] := str[i];
		    INC(j);
		END;
	    END;
	    INC(i);
	END;

	IF n <> 0 THEN
	    DEC(n);
	ELSE
	    EXIT;
	END;
    END;
    IF j <= HIGH(dest) THEN
	dest[j] := 0C;
    END;
END Item;

PROCEDURE ItemS(VAR dest : ARRAY OF CHAR;
		str : ARRAY OF CHAR;
		sep : ARRAY OF CHAR;
		n : CARDINAL);
VAR
    sepSet	: CHARSET;
    i		: CARDINAL;
BEGIN
    sepSet := CHARSET{};
    IF str[0] <> 0C THEN
	FOR i := 0 TO LENGTH(str)-1 DO
	    INCL(sepSet, sep[i]);
	END;
    END;
    Item(dest, str, sepSet, n);
END ItemS;

PROCEDURE Prepend(VAR dest : ARRAY OF CHAR; str : ARRAY OF CHAR);
BEGIN
    Strings.Insert(str, 0, dest);
END Prepend;

PROCEDURE Insert(VAR dest : ARRAY OF CHAR;
		str : ARRAY OF CHAR;
		pos : CARDINAL);
BEGIN
    Strings.Insert(str, pos, dest);
END Insert;

PROCEDURE Subst(VAR dest : ARRAY OF CHAR;
		src : ARRAY OF CHAR;
		new : ARRAY OF CHAR);
VAR
    ok		: BOOLEAN;
    pos		: CARDINAL;
BEGIN
    FindNext(src, dest, 0, ok, pos);
    IF ok THEN
	Delete(dest, pos, LENGTH(src));
	Strings.Insert(new, pos, dest);
    END;
END Subst;

PROCEDURE Match(src, pattern : ARRAY OF CHAR) : BOOLEAN;

    PROCEDURE doMatch(is, ip : CARDINAL) : BOOLEAN;
    BEGIN
	WHILE ip < pLen DO
	    (* check for the * first since it can match zero chars *)

	    IF pattern[ip] = '*' THEN
		INC(ip);
		WHILE is <= sLen DO
		    IF doMatch(is, ip) THEN
			RETURN TRUE;
		    END;
		    INC(is);
		END;
		RETURN FALSE;

	    (* now check for end of source *)

	    ELSIF is = sLen THEN
		RETURN FALSE;

	    ELSIF (pattern[ip] <> '?') AND (src[is] <> pattern[ip]) THEN
		RETURN FALSE;
	    END;

	    INC(is);
	    INC(ip);
	END;

	RETURN is = sLen;
    END doMatch;

VAR
    pLen	: CARDINAL;
    sLen	: CARDINAL;
BEGIN
    sLen := LENGTH(src);
    pLen := LENGTH(pattern);
    RETURN doMatch(0, 0);
END Match;

PROCEDURE FindSubStr(src, pattern : ARRAY OF CHAR;
		     VAR posList : ARRAY OF PosLen) : BOOLEAN;

    PROCEDURE addWildPos(pos, len :  CARDINAL);
    BEGIN
	IF last <= HIGH(posList) THEN
	    posList[last].Len := len;
	    posList[last].Pos := pos;
	    INC(last);
	END;
    END addWildPos;

    PROCEDURE doMatch(is, ip : CARDINAL) : BOOLEAN;
    VAR
	st	: CARDINAL;
	save	: CARDINAL;
    BEGIN
	save := last;

	WHILE ip < pLen DO
	    (* check for the * first since it can match zero chars *)

	    IF pattern[ip] = '*' THEN
		st := is;
		WHILE is <= sLen DO
		    last := save;
		    addWildPos(is, is-st);
		    IF doMatch(is, ip+1) THEN
			RETURN TRUE;
		    END;
		    INC(is);
		END;
		RETURN FALSE;

	    (* now check for end of source *)

	    ELSIF is = sLen THEN
		RETURN FALSE;

	    (* this matches any source char *)

	    ELSIF pattern[ip] = '?' THEN
		addWildPos(is, 1);

	    (* now compare the actuals chars *)

	    ELSIF src[is] <> pattern[ip] THEN
		RETURN FALSE;
	    END;

	    INC(is);
	    INC(ip);
	END;

	RETURN is = sLen;
    END doMatch;

VAR
    pLen	: CARDINAL;
    sLen	: CARDINAL;
    last	: CARDINAL;
    i		: CARDINAL;
BEGIN
    pLen := LENGTH(pattern);
    sLen := LENGTH(src);
    IF pLen <> 0 THEN
	FOR i := 0 TO sLen DO
	    last := 0;
	    IF doMatch(i, 0) THEN
		RETURN TRUE;
	    END;
	END;
    END;
    RETURN FALSE;
END FindSubStr;

CONST
    Digits : ARRAY [0..15] OF CHAR = {'0123456789ABCDEF'};

PROCEDURE IntToStr(num : LONGINT;
		   VAR str : ARRAY OF CHAR;
		   base : CARDINAL;
		   VAR ok : BOOLEAN);
BEGIN
    ok := LongBaseToStr(num, base, str);
END IntToStr;

PROCEDURE CardToStr(num : CARDINAL32;
		    VAR str : ARRAY OF CHAR;
		    base : CARDINAL;
                    VAR ok : BOOLEAN);
VAR
    i		: CARDINAL;
    j		: CARDINAL;
    lbase	: CARDINAL32;
    buf		: ARRAY [0..79] OF CHAR;
BEGIN
    lbase := base;
    i := 0;
    REPEAT
	buf[i] := Digits[num REM lbase];
	num := num / lbase;
	INC(i);
    UNTIL num = 0;

    DEC(i);

    ok := FALSE;
    IF i <= HIGH(str) THEN
	IF i < HIGH(str) THEN
	    str[i+1] := 0C;
	END;

	FOR j := 0 TO i DO;
	    str[i-j] := buf[j];
	END;

	ok := TRUE;
    END;
END CardToStr;

PROCEDURE RealToStr(num : LONGREAL;
                    precision : CARDINAL;
		    eng : BOOLEAN;
		    VAR dest : ARRAY OF CHAR;
		    VAR ok : BOOLEAN);
BEGIN
    IF eng THEN
        ok := LengthEngReal(num, precision) <= (HIGH(dest)+1);
	RealToEng(num, precision, dest);
    ELSE
	ok := LengthFloatReal(num, precision) <= (HIGH(dest)+1);
	RealToFloat(num, precision, dest);
    END;
END RealToStr;

PROCEDURE FixRealToStr(num : LONGREAL;
                       precision : CARDINAL;
		       VAR str : ARRAY OF CHAR;
		       VAR ok : BOOLEAN);
BEGIN
    ok := LengthFixedReal(num, precision) <= (HIGH(str)+1);
    RealToFixed(num, precision, str);
END FixRealToStr;

PROCEDURE StrToInt(str : ARRAY OF CHAR;
		   base : CARDINAL;
		   VAR ok : BOOLEAN) : LONGINT;
VAR
    num		: LONGINT;
BEGIN
    ok := StrBaseToLong(str, base, num);
    RETURN num;
END StrToInt;

PROCEDURE StrToCard(str : ARRAY OF CHAR;
		    base : CARDINAL;
                    VAR ok : BOOLEAN) : CARDINAL32;
VAR
    ch		: CHAR;
    i		: CARDINAL;
    t		: CARDINAL;
    max		: CARDINAL32;
    last	: CARDINAL;
    num		: CARDINAL32;
BEGIN
    <*/PUSH/NOWARN:C*>
    max := MAX(CARDINAL32) / VAL(CARDINAL32, base);
    last := MAX(CARDINAL32) REM VAL(CARDINAL32, base);
    <*/POP*>

    i := 0;
    num := 0;
    ok := FALSE;

    WHILE ((i <= HIGH(str)) AND (str[i] = ' ')) DO
	INC(i);
    END;

    WHILE i <= HIGH(str) DO
	IF str[i] = 0C THEN
	    RETURN num;
	END;

	ch := CAP(str[i]);
	IF (ch >= 'A') AND (ch <= 'F') THEN
	    t := 10 + (ORD(ch)-ORD('A'));
	ELSIF (ch >= '0') AND (ch <= '9') THEN
	    t := ORD(ch) - ORD('0');
	ELSE
	    t := 100;
	END;

	IF t < base THEN
	    IF (num > max) OR ((num = max) AND (t > last)) THEN
		ok := FALSE;
		RETURN num;
	    END;

	    <*/PUSH/NOWARN:C*>
	    num := (num * VAL(CARDINAL32, base)) + VAL(CARDINAL32, t);
	    <*/POP*>
	    ok := TRUE;
	    INC(i);
	ELSE
	    ok := FALSE;
	    RETURN num;
	END;
    END;
    RETURN num;
END StrToCard;

PROCEDURE StrToReal(str : ARRAY OF CHAR; VAR ok : BOOLEAN) : LONGREAL;
VAR
    res		: ConvResults;
    num		: LONGREAL;
BEGIN
    LongStr.StrToReal(str, num, res);
    ok := res = strAllRight;
    RETURN num;
END StrToReal;

PROCEDURE StrToC(src : ARRAY OF CHAR; VAR dest : ARRAY OF CHAR) : BOOLEAN;
BEGIN
    dest[0] := 0C;
    IF HIGH(dest) >= LENGTH(src) THEN
	Assign(src, dest);
	RETURN TRUE;
    END;
    RETURN FALSE;
END StrToC;

PROCEDURE StrToPas(src : ARRAY OF CHAR; VAR dest : ARRAY OF CHAR) : BOOLEAN;
VAR
    i	: CARDINAL;
    len	: CARDINAL;
BEGIN
    dest[0] := 0C;
    len := LENGTH(src);
    IF (HIGH(dest) >= len) AND (len <= 255) THEN
	dest[0] := CHR(len);
	IF len <> 0 THEN
	    FOR i := 0 TO len-1 DO
		dest[i+1] := src[i];
	    END;
	END;
	RETURN TRUE;
    END;
    RETURN FALSE;
END StrToPas;

END Str.
