MODULE test;

FROM SYSTEM IMPORT
    ADR;

IMPORT Str, IO, FIO, FIOR, Lib;

PROCEDURE testIO;
VAR
    ch		: CHAR;
    card	: CARDINAL;
    int		: INTEGER;
    bool	: BOOLEAN;
    real	: LONGREAL;
BEGIN
    IO.WrStr('Hello World');
    IO.WrLn;

    IO.WrStr(' WrCard(23, 0)    #');
    IO.WrCard(23, 0);
    IO.WrChar('#');
    IO.WrLn;
    IO.WrStr(' WrCard(23, 10)   #');
    IO.WrCard(23, 10);
    IO.WrChar('#');
    IO.WrLn;
    IO.WrStr(' WrCard(23, -10)  #');
    IO.WrCard(23, -10);
    IO.WrChar('#');
    IO.WrLn;

    IO.WrStr(' WrInt(-23, 0)    #');
    IO.WrInt(-23, 0);
    IO.WrChar('#');
    IO.WrLn;
    IO.WrStr(' WrInt(-23, 10)   #');
    IO.WrInt(-23, 10);
    IO.WrChar('#');
    IO.WrLn;
    IO.WrStr(' WrInt(-23, -10)  #');
    IO.WrInt(-23, -10);
    IO.WrChar('#');
    IO.WrLn;

    IO.WrStr(' WrHex(32, 0)     #');
    IO.WrHex(32, 0);
    IO.WrChar('#');
    IO.WrLn;
    IO.WrStr(' WrHex(32, 10)    #');
    IO.WrHex(32, 10);
    IO.WrChar('#');
    IO.WrLn;
    IO.WrStr(' WrHex(32, -10)   #');
    IO.WrHex(32, -10);
    IO.WrChar('#');
    IO.WrLn;

    IO.WrLn;
    IO.WrStr(' WrLngReal(22.0/7.0, 5, 0)      #');
    IO.WrLngReal(22.0/7.0, 5, 0);
    IO.WrChar('#');
    IO.WrLn;
    IO.WrStr(' WrLngReal(22.0/7.0, 5, 16)     #');
    IO.WrLngReal(22.0/7.0, 5, 16);
    IO.WrChar('#');
    IO.WrLn;
    IO.WrStr(' WrLngReal(22.0/7.0, 5, -16)    #');
    IO.WrLngReal(22.0/7.0, 5, -16);
    IO.WrChar('#');
    IO.WrLn;
    IO.WrStr(' WrFixLngReal(22.0/7.0, 5, 0)   #');
    IO.WrFixLngReal(22.0/7.0, 5, 0);
    IO.WrChar('#');
    IO.WrLn;
    IO.WrStr(' WrFixLngReal(22.0/7.0, 5, 16)  #');
    IO.WrFixLngReal(22.0/7.0, 5, 16);
    IO.WrChar('#');
    IO.WrLn;
    IO.WrStr(' WrFixLngReal(22.0/7.0, 5, -16) #');
    IO.WrFixLngReal(22.0/7.0, 5, -16);
    IO.WrChar('#');
    IO.WrLn;

    LOOP
	IO.WrLn;
	IO.WrStr('Enter CARDINAL INTEGER REAL BOOLEAN: ');
	card := IO.RdCard();
	int := IO.RdInt();
	real := IO.RdLngReal();
	bool := IO.RdBool();
	IO.RdLn;

	IO.WrStr('card = ');
	IO.WrCard(card, 0);
	IO.WrStr(' int = ');
	IO.WrInt(int, 0);
	IO.WrStr(' real = ');
	IO.WrLngReal(real, 5, 0);
	IO.WrStr(' bool = ');
	IO.WrBool(bool, 0);
	IO.WrLn;

	IO.WrLn;
	IO.WrStr('Press Q to quit: ');
	ch := IO.RdChar();
	IF CAP(ch) = 'Q' THEN
	    EXIT;
	END;
	IO.RdLn;
    END;
END testIO;

PROCEDURE testStr;
VAR
    str		: ARRAY [0..31] OF CHAR;
    str1	: ARRAY [0..31] OF CHAR;
BEGIN
    str := 'ABCDEFG';
    IO.WrStr("Lows ");
    IO.WrStr(str);
    Str.Lows(str);
    IO.WrStr("  ");
    IO.WrStr(str);
    IO.WrLn;

    IO.WrStr(" Compare ABCDEF ABCDE ");
    IO.WrInt(Str.Compare("ABCDEF", "ABCDE"), 0);
    IO.WrLn;

    Str.Concat(str, "ABCDEF", "GHIJKL");
    IO.WrStr("Concat ABCDEF GHIJKL ");
    IO.WrStr(str);
    IO.WrLn;

    str := "";
    Str.Append(str, "ABCDEF");
    IO.WrStr('Append "" ABCDEF ');
    IO.WrStr(str);
    IO.WrLn;

    Str.Append(str, "GHIJ");
    IO.WrStr("Append ABCDEF GHIJ ");
    IO.WrStr(str);
    IO.WrLn;

    Str.Slice(str1, str, 3, 3);
    IO.WrStr("Slice ABCDEFGHIJ 3, 3 ");
    IO.WrStr(str1);
    IO.WrLn;

    IO.WrStr("Pos ABCDEFGHIJ DEF ");
    IO.WrCard(Str.Pos(str, str1), 0);
    IO.WrLn;

    str := "ABC,DEF,GHI";
    IO.WrStr("Item ABC,DEF,GHI ', ' 1 ");
    Str.Item(str1, str, Str.CHARSET{",", " "}, 1);
    IO.WrStr(str1);
    IO.WrLn;

    IO.WrStr("ItemS ABC,DEF,GHI ', ' 1 ");
    Str.ItemS(str1, str, ", ", 1);
    IO.WrStr(str1);
    IO.WrLn;

    str := "DEF";
    IO.WrStr("Prepend ABC DEF ");
    Str.Prepend(str, "ABC");
    IO.WrStr(str);
    IO.WrLn;

    str := "ABCDEFGHI";
    IO.WrStr("Subst ABCDEFGHI DEF 123 ");
    Str.Subst(str, "DEF", "123");
    IO.WrStr(str);
    IO.WrLn;

    IO.WrStr("Match Automatic ?utomatic ");
    IO.WrBool(Str.Match("Automatic", "?utomatic"), 0);
    IO.WrLn;

    IO.WrStr("Match Automatic *m?t*i* ");
    IO.WrBool(Str.Match("Automatic", "*m?t*i*"), 0);
    IO.WrLn;

    IO.WrStr("Match Automatic *M?t*i* ");
    IO.WrBool(Str.Match("automatic", "*M?t*i*"), 0);
    IO.WrLn;
END testStr;

PROCEDURE testLib;
VAR
    str1, str2	: ARRAY [0..31] OF CHAR;
    i			: CARDINAL;
BEGIN
    str1 := "ABCDEFGH";
    str2 := str1;
    str2[5] := '1';

    IO.WrStr("Compare ABCDEFGH ABCDEFGH ");
    IO.WrCard(Lib.Compare(ADR(str1), ADR(str2), HIGH(str1)+1), 0);
    IO.WrLn;

    FOR i := 1 TO Lib.ParamCount() DO
	Lib.ParamStr(str1, i);
	IO.WrStr("Param ");
	IO.WrCard(i, 0);
	IO.WrStr("  ");
	IO.WrStr(str1);
	IO.WrLn;
    END;

    str1 := "ABCDEFGHIJKL";
    IO.WrStr("ScanR ABCDEFGHIJKL H ");
    IO.WrCard(Lib.ScanR(ADR(str1), HIGH(str1)+1, "H"), 0);
    IO.WrLn;

    str1 := "HHHDEFGHIJKL";
    IO.WrStr("ScanNeR HHHDEFGHIJKL H ");
    IO.WrCard(Lib.ScanNeR(ADR(str1), HIGH(str1)+1, "H"), 0);
    IO.WrLn;
END testLib;

PROCEDURE testFIO;
CONST
    name	= "foo1.txt";
VAR
    f		: FIO.File;
    e		: FIO.DirEntry;
    str		: ARRAY [0..127] OF CHAR;
BEGIN
    f := FIO.Create(name);
    FIO.Close(f);
    IO.WrStr(name);
    IF FIO.Exists(name) THEN
	IO.WrStr("  exists");
    ELSE
	IO.WrStr("  does not exist");
    END;
    IO.WrLn;

    FIO.Erase(name);
    IF FIO.Exists(name) THEN
	IO.WrStr("Erase failed");
	IO.WrLn;
    END;

    f := FIO.Create(name);
    FIO.WrCard(f, 23, 8);
    FIO.WrInt(f, -23, 8);
    FIO.WrBool(f, TRUE, 8);
    FIO.WrLngReal(f, 22.0 / 7.0, 5, 16);
    FIO.WrLn(f);
    FIO.Close(f);
    f := FIO.OpenRead(name);
    IO.WrCard(FIO.RdCard(f), 0);
    IO.WrLn;
    IO.WrInt(FIO.RdInt(f), 0);
    IO.WrLn;
    IO.WrBool(FIO.RdBool(f), 0);
    IO.WrLn;
    IO.WrLngReal(FIO.RdLngReal(f), 5, 0);
    IO.WrLn;
    FIO.Close(f);
    FIO.Erase(name);

    FIO.GetDir(3, str);
    IO.WrStr("GetDir 3 ");
    IO.WrStr(str);
    IO.WrLn;

    FIO.GetDir(0, str);
    IO.WrStr("GetDir 0 ");
    IO.WrStr(str);
    IO.WrLn;

    FIO.MkDir("JUNK");
    IF FIO.Exists("JUNK") THEN
	FIO.ChDir("JUNK");
	FIO.MkDir("JUNK1");
	IF FIO.ReadFirstEntry("*.*", FIO.FileAttr{FIO.directory}, e) THEN
	    REPEAT
		IO.WrStr(e.name);
		IO.WrLn;
	    UNTIL NOT FIO.ReadNextEntry(e);
	END;
	FIO.RmDir("JUNK1");
	IF FIO.Exists("JUNK1") THEN
	    IO.WrStr("RmDir JUNK1 failed");
	    IO.WrLn;
	END;
	FIO.ChDir("..");
    ELSE
	IO.WrStr("MkDir failed");
	IO.WrLn;
    END;
    FIO.RmDir("JUNK");
    IF FIO.Exists("JUNK") THEN
	IO.WrStr("RmDir JUNK failed");
	IO.WrLn;
    END;

    IF FIO.ReadFirstEntry("MOD\*.MOD", FIO.FileAttr{}, e) THEN
	REPEAT
	    IO.WrStr(e.name);
	    IO.WrLn;
	UNTIL NOT FIO.ReadNextEntry(e);
    END;
END testFIO;

VAR
    ch		: CHAR;
BEGIN
    testIO;
    (*testStr;*)
    (*testLib;*)
    (*testFIO;*)

    IO.WrLn;
    IO.WrLn;
    IO.WrStr("Press any key");
    IO.WrLn;
    IO.RdLn;
    ch := IO.RdChar();
END test.
