<* +M2EXTENSIONS *>
(*------------------------------------------------------------
   HELLOWIN.C      --- Displays "Hello, Windows 95!" in client area
                   (C) Charles Petzold, 1996
   HelloWin.mod    --- Translation to XDS Modula-2
                   (C) Peter Stadler,   1997
  ------------------------------------------------------------*)
MODULE HelloWin;

IMPORT SYSTEM;
IMPORT Windows;





CONST AppName = "HelloWin";
      AppTrans = "The Hello Program: Translation to XDS Modula-2";

VAR  hwnd       : Windows.HWND;
     msg        : Windows.MSG;
     wc         : Windows.WNDCLASSEX;
   


    

    

(******************************************************************************)
PROCEDURE [Windows.CALLBACK] WndProc (hwnd        : Windows.HWND;
                                      iMsg        : Windows.UINT;
                                      wParam      : Windows.WPARAM;
                                      lParam      : Windows.LPARAM) : Windows.LRESULT;
(******************************************************************************)

  VAR
     hdc     :   Windows.HDC;
     ps      :   Windows.PAINTSTRUCT;
     rect    :   Windows.RECT;
     hBrush  :   Windows.HBRUSH;
  CONST
    wav      =   "hellowin.wav";
    hello    =   "Hello, Windows 95!";
BEGIN
  CASE iMsg OF
  | Windows.WM_CREATE:
      Windows.PlaySound (SYSTEM.ADR(wav), NIL, Windows.SND_FILENAME + Windows.SND_ASYNC);
      RETURN 0;

  | Windows.WM_PAINT:
      hdc := Windows.BeginPaint (hwnd,ps);
      hBrush := Windows.CreateSolidBrush(Windows.RGB(0,0,255));
      Windows.GetClientRect (hwnd, rect);
      Windows.FillRect(hdc,rect,hBrush);
      Windows.DrawText (hdc, SYSTEM.ADR(hello), -1, rect,
                                  Windows.DT_SINGLELINE + Windows.DT_CENTER + Windows.DT_VCENTER);
      Windows.EndPaint (hwnd, ps);
      RETURN 0;

  | Windows.WM_DESTROY:
      Windows.PostQuitMessage(0);
      RETURN 0;
  ELSE
    RETURN Windows.DefWindowProc (hwnd, iMsg, wParam, lParam);
  END;
END WndProc;

(******************************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(******************************************************************************)
BEGIN
   wc.cbSize        := SIZE(Windows.WNDCLASSEX);
   wc.style         := Windows.CS_HREDRAW + Windows.CS_VREDRAW;
   wc.lpfnWndProc   := SYSTEM.CAST(Windows.WNDPROC,WndProc);
   wc.cbClsExtra    := 0;
   wc.cbWndExtra    := 0;
   wc.hInstance     := Windows.MyInstance();
   wc.hIcon         := Windows.LoadIcon (NIL, Windows.IDI_APPLICATION);
   wc.hCursor       := Windows.LoadCursor (NIL, Windows.IDC_ARROW);
   wc.hbrBackground := SYSTEM.CAST(Windows.HBRUSH, Windows.GetStockObject (Windows.WHITE_BRUSH));
   wc.lpszMenuName  := NIL;
   wc.lpszClassName := SYSTEM.ADR (AppName);
   wc.hIconSm       := Windows.LoadIcon (NIL, Windows.IDI_APPLICATION);

   RETURN Windows.RegisterClassEx (wc) <> 0;
END InitApplication;

PROCEDURE InitMainWindow() : BOOLEAN;
BEGIN
  hwnd := Windows.CreateWindow (SYSTEM.ADR(AppName),            (* window class name            *)
                                AppTrans,                       (* window caption               *)
                                Windows.WS_OVERLAPPEDWINDOW,    (* window style                 *)
                                Windows.CW_USEDEFAULT,          (* initial x position           *)
                                Windows.CW_USEDEFAULT,          (* initial y position           *)
                                Windows.CW_USEDEFAULT,          (* initial x size               *)
                                Windows.CW_USEDEFAULT,          (* initial y size               *)
                                NIL,                            (* parent window handle         *)
                                NIL,                            (* window menu handle           *)
                                wc.hInstance,                   (* program instance handle      *)
                                NIL);                           (* creation parameters          *)

  Windows.ShowWindow   (hwnd, Windows.SW_SHOWDEFAULT);
  Windows.UpdateWindow (hwnd);

  RETURN TRUE;
END InitMainWindow;


BEGIN
  IF InitApplication() AND InitMainWindow() THEN
    WHILE (Windows.GetMessage(msg,NIL,0,0)) DO
      Windows.TranslateMessage(msg);
      Windows.DispatchMessage(msg);
    END;
  END;
END HelloWin.
