<* +M2EXTENSIONS *>
(*----------------------------------------------------
   SYSMETS2.C      --- System Metrics Display Program No. 2
                   (c) Charles Petzold, 1996
   SysMets2.mod    --- Translation to XDS Modula-2
                   (c) Peter Stadler,   1997
  ----------------------------------------------------*)


MODULE SysMets2;
IMPORT SYSTEM;

IMPORT Windows;

IMPORT SysMets;
IMPORT Strings;

CONST
  szAppName = "SysMets2";
VAR
  hwnd        :  Windows.HWND;
  msg         :  Windows.MSG;
  wc          :  Windows.WNDCLASSEX;
  cxChar, cxCaps, cyChar, cyClient,
  iVscrollPos : INTEGER;
(*++++*****************************************************************)
PROCEDURE MaxInt (a,b : INTEGER) : INTEGER;
(**********************************************************************)
BEGIN
  IF(a>b) THEN
    RETURN a;
  ELSE
    RETURN b;
  END;
END MaxInt;
(*++++*****************************************************************)
PROCEDURE MinInt (a,b : INTEGER) : INTEGER;
(**********************************************************************)
BEGIN
  IF(a>b) THEN
    RETURN b;
  ELSE
    RETURN a;
  END;
END MinInt;






(*++++*****************************************************************)
PROCEDURE [Windows.CALLBACK]  WndProc (hwnd        : Windows.HWND;
                                       iMsg        : Windows.UINT;
                                       wParam      : Windows.WPARAM;
                                       lParam      : Windows.LPARAM) : Windows.LRESULT;
(**********************************************************************)
VAR
  szBuffer    :  ARRAY[0..10] OF CHAR;
  hdc         :  Windows.HDC;
  i, y        :  INTEGER;
  ps          :  Windows.PAINTSTRUCT;
  tm          :  Windows.TEXTMETRIC;
BEGIN

  CASE (iMsg) OF
          | Windows.WM_CREATE :
               hdc := Windows.GetDC (hwnd);

               Windows.GetTextMetrics (hdc, tm);
               cxChar := tm.tmAveCharWidth;
               IF(tm.tmPitchAndFamily=SYSTEM.CAST(Windows.PITCH_AND_FAMILY_SET,1)) THEN
                 cxCaps := 3*cxChar/2;
               ELSE
                 cxCaps := 2*cxChar/2;
               END;
               cyChar := tm.tmHeight + tm.tmExternalLeading;

               Windows.ReleaseDC (hwnd, hdc);

               Windows.SetScrollRange (hwnd, Windows.SB_VERT, 0, SysMets.NUMLINES, FALSE);
               Windows.SetScrollPos   (hwnd, Windows.SB_VERT, iVscrollPos, TRUE);
               RETURN 0;

          | Windows.WM_SIZE :
               cyClient := Windows.HIWORD (lParam);
               RETURN 0;

          | Windows.WM_VSCROLL :
               CASE (Windows.LOWORD (wParam)) OF
                    | SYSTEM.CAST(SYSTEM.CARD16,Windows.SB_LINEUP) :
                         iVscrollPos := iVscrollPos - 1;

                    | SYSTEM.CAST(SYSTEM.CARD16,Windows.SB_LINEDOWN) :
                         iVscrollPos := iVscrollPos + 1;

                    | SYSTEM.CAST(SYSTEM.CARD16,Windows.SB_PAGEUP) :
                         iVscrollPos :=iVscrollPos-cyClient DIV cyChar;

                    | SYSTEM.CAST(SYSTEM.CARD16,Windows.SB_PAGEDOWN) :
                         iVscrollPos :=iVscrollPos+ cyClient DIV cyChar;

                    | SYSTEM.CAST(SYSTEM.CARD16,Windows.SB_THUMBPOSITION) :
                         iVscrollPos := Windows.HIWORD (wParam);

                    ELSE
                    END;
               iVscrollPos := MaxInt (0, MinInt(iVscrollPos, SysMets.NUMLINES));

               IF (iVscrollPos # Windows.GetScrollPos (hwnd, Windows.SB_VERT)) THEN
                    Windows.SetScrollPos (hwnd, Windows.SB_VERT, iVscrollPos, TRUE);
                    Windows.InvalidateRect (hwnd, NIL, TRUE);
               END;
               RETURN 0;

          | Windows.WM_PAINT :
               hdc := Windows.BeginPaint (hwnd, ps);

               FOR i := 0 TO  SysMets.NUMLINES-1 DO
                    y := cyChar * (1 - iVscrollPos + i);

                    Windows.TextOut (hdc, cxChar, y,
                             SysMets.sysmetrics[i].szLabel,
                             LENGTH(SysMets.sysmetrics[i].szLabel));

                    Windows.TextOut (hdc, cxChar + 22 * cxCaps, y,
                             SysMets.sysmetrics[i].szDesc,
                             LENGTH(SysMets.sysmetrics[i].szDesc));

                    Windows.SetTextAlign (hdc, Windows.TA_RIGHT + Windows.TA_TOP);

                    Windows.TextOut (hdc, cxChar + 22 * cxCaps + 40 * cxChar, y,
                             szBuffer,
                             Windows.wsprintf (szBuffer, "%5d",
                                         Windows.GetSystemMetrics (SysMets.sysmetrics[i].iIndex)));

                    Windows.SetTextAlign (hdc, Windows.TA_LEFT + Windows.TA_TOP);
               END;

               Windows.EndPaint (hwnd, ps);
               RETURN 0;

          | Windows.WM_DESTROY :
               Windows.PostQuitMessage (0);
               RETURN 0;
  ELSE

          RETURN Windows.DefWindowProc (hwnd, iMsg, wParam, lParam);
  END;
END WndProc;

(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
VAR
  rc  :  INTEGER;
BEGIN
  wc.cbSize        := SIZE(Windows.WNDCLASSEX);
  wc.style         := Windows.CS_HREDRAW + Windows.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := Windows.MyInstance();
  wc.hIcon         := Windows.LoadIcon (NIL, Windows.IDI_APPLICATION);
  wc.hCursor       := Windows.LoadCursor (NIL, Windows.IDC_ARROW);
  wc.hbrBackground := SYSTEM.CAST(Windows.HBRUSH, Windows.GetStockObject (Windows.WHITE_BRUSH));
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := Windows.LoadIcon (NIL, Windows.IDI_APPLICATION);

  rc := Windows.RegisterClassEx (wc);
  RETURN rc#0;
END InitApplication;
(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := Windows.CreateWindow
           (szAppName,                           (* window class name            *)
           "Get System Metrics No. 2: Translation to XDS Modula-2",
                                                 (* window caption               *)
           Windows.WS_OVERLAPPEDWINDOW + Windows.WS_VSCROLL, (* window style           *)
           Windows.CW_USEDEFAULT,                (* initial x position           *)
           Windows.CW_USEDEFAULT,                (* initial y position           *)
           Windows.CW_USEDEFAULT,                (* initial x size               *)
           Windows.CW_USEDEFAULT,                (* initial y size               *)
           NIL,                                  (* parent window handle         *)
           NIL,                                  (* window menu handle           *)
           Windows.MyInstance(),                        (* program instance handle      *)
           NIL);                                 (* creation parameters          *)

  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  Windows.ShowWindow (hwnd, Windows.SW_SHOWDEFAULT);
  Windows.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;
(*++++*****************************************************************)
BEGIN
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (Windows.GetMessage(msg,NIL,0,0)) DO
      Windows.TranslateMessage(msg);
      Windows.DispatchMessage(msg);
    END;
  END;
END SysMets2.
