<* +M2EXTENSIONS *>
MODULE Bezier;
(*---------------------------------------
   BEZIER.C        --- Bezier Splines Demo
                   (c) Charles Petzold, 1996
   Bezier.mod      --- Translation to XDS Modula-2
                   (c) Peter Stadler,   1997
  ---------------------------------------*)

IMPORT Windows;


IMPORT SYSTEM;

CONST
  szAppName  =  "Bezier";
VAR
   hwnd            :  Windows.HWND;
   msg             :  Windows.MSG;
   wc              :  Windows.WNDCLASSEX;
VAR
  apt       :  ARRAY[0..4] OF Windows.POINT;
  hdc       :  Windows.HDC;
  cxClient  :  INTEGER;
  cyClient  :  INTEGER;
  ps        :  Windows.PAINTSTRUCT;
(*++++*****************************************************************)
PROCEDURE DrawBezier (hdc    :  Windows.HDC;
                      apt    :  ARRAY OF Windows.POINT);
(**********************************************************************)
BEGIN
  Windows.PolyBezier (hdc, apt, 4);

  Windows.MoveToEx (hdc, apt[0].x, apt[0].y, NIL);
  Windows.LineTo   (hdc, apt[1].x, apt[1].y);

  Windows.MoveToEx (hdc, apt[2].x, apt[2].y, NIL);
  Windows.LineTo   (hdc, apt[3].x, apt[3].y);
END DrawBezier;


    

    

(*++++*****************************************************************)
PROCEDURE [Windows.CALLBACK] WndProc(hwnd       : Windows.HWND;
(**********************************************************************)
                                    iMsg        : Windows.UINT;
                                    wParam      : Windows.WPARAM;
                                    lParam      : Windows.LPARAM) : Windows.LRESULT;

BEGIN

  CASE (iMsg)  OF
  | Windows.WM_SIZE:
      cxClient := Windows.LOWORD (lParam);
      cyClient := Windows.HIWORD (lParam);

      apt[0].x := cxClient / 4;
      apt[0].y := cyClient / 2;

      apt[1].x := cxClient / 2;
      apt[1].y := cyClient / 4;

      apt[2].x :=     cxClient / 2;
      apt[2].y := 3 * cyClient / 4;

      apt[3].x := 3 * cxClient / 4;
      apt[3].y :=     cyClient / 2;

      RETURN 0;

  | Windows.WM_MOUSEMOVE:
      IF ((SYSTEM.CAST(Windows.MK_SET,wParam) - Windows.MK_LBUTTON)=SYSTEM.CAST(Windows.MK_SET,1))
      OR ((SYSTEM.CAST(Windows.MK_SET,wParam) - Windows.MK_RBUTTON)=SYSTEM.CAST(Windows.MK_SET,1)) THEN
        hdc := Windows.GetDC (hwnd);
        Windows.SelectObject (hdc, Windows.GetStockObject (Windows.WHITE_PEN));
        DrawBezier (hdc, apt);

        IF (SYSTEM.CAST(Windows.MK_SET,wParam) - Windows.MK_LBUTTON=SYSTEM.CAST(Windows.MK_SET,1)) THEN
          apt[1].x := Windows.LOWORD (lParam);
          apt[1].y := Windows.HIWORD (lParam);
        END;

        IF (SYSTEM.CAST(Windows.MK_SET,wParam) - Windows.MK_RBUTTON=SYSTEM.CAST(Windows.MK_SET,1)) THEN
          apt[2].x := Windows.LOWORD (lParam);
          apt[2].y := Windows.HIWORD (lParam);
        END;

        Windows.SelectObject (hdc, Windows.GetStockObject (Windows.BLACK_PEN));
        DrawBezier (hdc, apt);
        Windows.ReleaseDC (hwnd, hdc);
      END;
      RETURN 0;

  | Windows.WM_PAINT:
      Windows.InvalidateRect (hwnd, NIL, TRUE);
      hdc := Windows.BeginPaint (hwnd, ps);
      DrawBezier (hdc, apt);
      Windows.EndPaint (hwnd, ps);
      RETURN 0;

  | Windows.WM_DESTROY:
      Windows.PostQuitMessage (0);
      RETURN 0;
  ELSE
    RETURN Windows.DefWindowProc (hwnd, iMsg, wParam, lParam);
  END;

END WndProc;

(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
VAR
  rc   :  CARDINAL;
BEGIN
  wc.cbSize        := SIZE(wc);
  wc.style         := Windows.CS_HREDRAW + Windows.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := Windows.MyInstance();
  wc.hIcon         := Windows.LoadIcon (NIL, Windows.IDI_APPLICATION);
  wc.hCursor       := Windows.LoadCursor (NIL, Windows.IDC_ARROW);
  wc.hbrBackground := SYSTEM.CAST(Windows.HBRUSH, Windows.GetStockObject (Windows.WHITE_BRUSH));
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := Windows.LoadIcon (NIL,Windows.IDI_APPLICATION);

  rc := Windows.RegisterClassEx(wc);
  RETURN rc#0;
END InitApplication;

(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := Windows.CreateWindow (
                       SYSTEM.ADR(szAppName),           (* window class name            *)
                       "Bezier Splines: Translation to XDS Modula-2",
                                                       (* window caption               *)
                       Windows.WS_OVERLAPPEDWINDOW,    (* window style                 *)
                       Windows.CW_USEDEFAULT,          (* initial x position           *)
                       Windows.CW_USEDEFAULT,          (* initial y position           *)
                       Windows.CW_USEDEFAULT,          (* initial x size               *)
                       Windows.CW_USEDEFAULT,          (* initial y size               *)
                       NIL,                            (* parent window handle         *)
                       NIL,                            (* window menu handle           *)
                       wc.hInstance,                   (* program instance handle      *)
                       NIL);                           (* creation parameters          *)

  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  Windows.ShowWindow (hwnd, Windows.SW_SHOWDEFAULT);
  Windows.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;


BEGIN
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (Windows.GetMessage(msg,NIL,0,0)) DO
      Windows.TranslateMessage(msg);
      Windows.DispatchMessage(msg);
    END;
  END;
END Bezier.
