<* +M2EXTENSIONS *>

MODULE EMF2;
(*-------------------------------------
   EMF2.C          --- Enhanced Metafile Demo #2
                   (c) Charles Petzold, 1996
   EMF2.mod        --- Translation to XDS Modula-2
                   (c) Peter Stadler,   1997
  -------------------------------------*)


IMPORT Windows;


IMPORT SYSTEM;
CONST szAppName = "EMF2";
VAR
  hwnd  :  Windows.HWND;
  msg   :  Windows.MSG;
  wc    :  Windows.WNDCLASSEX;
  hemf  :  Windows.HENHMETAFILE;



    

    

(*++++*****************************************************************)
PROCEDURE [Windows.CALLBACK] WndProc(hwnd       : Windows.HWND;
(**********************************************************************)
                                    iMsg        : Windows.UINT;
                                    wParam      : Windows.WPARAM;
                                    lParam      : Windows.LPARAM) : Windows.LRESULT;
VAR
  hdc   :  Windows.HDC;
  hdcEMF:  Windows.HDC;
  ps    :  Windows.PAINTSTRUCT;
  rect  :  Windows.RECT;
CONST
  msg1  =  "EMF2"+""+"EMF Demo #2";

BEGIN
     CASE (iMsg) OF
          | Windows.WM_CREATE:
               hdcEMF := Windows.CreateEnhMetaFile (NIL, "emf2.emf", NIL,msg1);

               Windows.Rectangle (hdcEMF, 100, 100, 200, 200);

               Windows.MoveToEx  (hdcEMF, 100, 100, NIL);
               Windows.LineTo    (hdcEMF, 200, 200);

               Windows.MoveToEx  (hdcEMF, 200, 100, NIL);
               Windows.LineTo    (hdcEMF, 100, 200);

               hemf := Windows.CloseEnhMetaFile (hdcEMF);

               Windows.DeleteEnhMetaFile (hemf);
               RETURN 0;

          | Windows.WM_PAINT:
               hdc := Windows.BeginPaint (hwnd, ps);

               Windows.GetClientRect (hwnd, rect);

               rect.left   :=     rect.right  DIV 4;
               rect.right  := 3 * rect.right  DIV 4;
               rect.top    :=     rect.bottom DIV 4;
               rect.bottom := 3 * rect.bottom DIV 4;

               hemf := Windows.GetEnhMetaFile ("emf2.emf");

               Windows.PlayEnhMetaFile (hdc, hemf, rect);

               Windows.DeleteEnhMetaFile (hemf);

               Windows.EndPaint (hwnd, ps);
               RETURN 0;

          | Windows.WM_DESTROY:
               Windows.PostQuitMessage (0);
               RETURN 0;
     ELSE
           RETURN Windows.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
END WndProc;

(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
BEGIN
  wc.cbSize        := SIZE(Windows.WNDCLASSEX);
  wc.style         := Windows.CS_HREDRAW + Windows.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := Windows.MyInstance();
  wc.hIcon         := Windows.LoadIcon (NIL, Windows.IDI_APPLICATION);
  wc.hCursor       := Windows.LoadCursor (NIL, Windows.IDC_ARROW);
  wc.hbrBackground := SYSTEM.CAST(Windows.HBRUSH, Windows.GetStockObject (Windows.WHITE_BRUSH));
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := Windows.LoadIcon (NIL, Windows.IDI_APPLICATION);

  RETURN Windows.RegisterClassEx (wc)#0;
END InitApplication;
(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := Windows.CreateWindow
           (szAppName,                           (* window class name            *)
           "Enhanced Metafile Demo #2: Translation to XDS Modula-2",
                                                 (* window caption               *)
           Windows.WS_OVERLAPPEDWINDOW,          (* window style                 *)
           Windows.CW_USEDEFAULT,                (* initial x position           *)
           Windows.CW_USEDEFAULT,                (* initial y position           *)
           Windows.CW_USEDEFAULT,                (* initial x size               *)
           Windows.CW_USEDEFAULT,                (* initial y size               *)
           NIL,                                  (* parent window handle         *)
           NIL,                                  (* window menu handle           *)
           Windows.MyInstance(),                        (* program instance handle      *)
           NIL);                                 (* creation parameters          *)

  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  Windows.ShowWindow (hwnd, Windows.SW_SHOWDEFAULT);
  Windows.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;
(*++++*****************************************************************)
BEGIN
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (Windows.GetMessage(msg,NIL,0,0)) DO
      Windows.TranslateMessage(msg);
      Windows.DispatchMessage(msg);
    END;
  END;
END EMF2.
