<* +M2EXTENSIONS *>
MODULE EndJoin;
(*----------------------------------------
   ENDJOIN.C       --- Ends and Joins Demo
                   (c) Charles Petzold, 1996
   EndJoin.C       --- Translation to XDS Modula-2 by
                   (c) Peter Stadler,   1997
  ----------------------------------------*)

IMPORT Windows;


IMPORT SYSTEM;

CONST
  szAppName  =  "EndJoin";
TYPE
  iArr       =  ARRAY[0..2] OF Windows.PS_SET;
VAR
   hwnd            :  Windows.HWND;
   msg             :  Windows.MSG;
   wc              :  Windows.WNDCLASSEX;
CONST
   iEnd            =  iArr { Windows.PS_ENDCAP_ROUND, Windows.PS_ENDCAP_SQUARE,
                              Windows.PS_ENDCAP_FLAT };
   iJoin           =  iArr { Windows.PS_JOIN_ROUND,   Windows.PS_JOIN_BEVEL,
                              Windows.PS_JOIN_MITER };
VAR			
   cxClient        :  INTEGER;
   cyClient        :  INTEGER;


    

    

(*++++*****************************************************************)
PROCEDURE [Windows.CALLBACK] WndProc(hwnd       : Windows.HWND;
(**********************************************************************)
                                    iMsg        : Windows.UINT;
                                    wParam      : Windows.WPARAM;
                                    lParam      : Windows.LPARAM) : Windows.LRESULT;
VAR
  hdc     :  Windows.HDC;
  i       :  INTEGER;
  lb      :  Windows.LOGBRUSH;
  ps      :  Windows.PAINTSTRUCT;

BEGIN

  CASE (iMsg)  OF
          | Windows.WM_SIZE:
               cxClient := Windows.LOWORD (lParam);
               cyClient := Windows.HIWORD (lParam);
               RETURN 0;

          | Windows.WM_PAINT:
               hdc := Windows.BeginPaint (hwnd, ps);

               Windows.SetMapMode (hdc, Windows.MM_ANISOTROPIC);
               Windows.SetWindowExtEx (hdc, 100, 100, NIL);
               Windows.SetViewportExtEx (hdc, cxClient, cyClient, NIL);

               lb.lbStyle := Windows.BS_SOLID;
               lb.lbColor := Windows.RGB (128, 128, 128);
               lb.lbHatch := 0;


               FOR i := 0 TO 3-1 DO
                    Windows.SelectObject (hdc,
                         SYSTEM.CAST(Windows.HGDIOBJ,Windows.ExtCreatePen (Windows.PS_SOLID + Windows.PS_GEOMETRIC +
                                       iEnd [i] + iJoin [i], 10,
                                       lb, 0, NIL)));

                    Windows.BeginPath (hdc);

                    Windows.MoveToEx (hdc, 10 + 30 * i, 25, NIL);
                    Windows.LineTo   (hdc, 20 + 30 * i, 75);
                    Windows.LineTo   (hdc, 30 + 30 * i, 25);


                    Windows.EndPath (hdc);

                    Windows.StrokePath (hdc);

                    Windows.DeleteObject (
                         Windows.SelectObject (hdc,
                              Windows.GetStockObject (Windows.BLACK_PEN)));

                    Windows.MoveToEx (hdc, 10 + 30 * i, 25, NIL);
                    Windows.LineTo   (hdc, 20 + 30 * i, 75);
                    Windows.LineTo   (hdc, 30 + 30 * i, 25);
               END;


               Windows.EndPaint (hwnd, ps);
               RETURN 0;

          | Windows.WM_DESTROY:
               Windows.PostQuitMessage (0);
               RETURN 0;
     ELSE

          RETURN Windows.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
END WndProc;

(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
BEGIN
  wc.cbSize        := SIZE(wc);
  wc.style         := Windows.CS_HREDRAW   + Windows.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := Windows.MyInstance();
  wc.hIcon         := Windows.LoadIcon (NIL, Windows.IDI_APPLICATION);
  wc.hCursor       := Windows.LoadCursor (NIL, Windows.IDC_ARROW);
  wc.hbrBackground := SYSTEM.CAST(Windows.HBRUSH, Windows.GetStockObject (Windows.WHITE_BRUSH));
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := Windows.LoadIcon (NIL,Windows.IDI_APPLICATION);

  RETURN Windows.RegisterClassEx(wc)#0;
END InitApplication;

(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := Windows.CreateWindow (
                       szAppName,                      (* window class name            *)
                       "Ends and Joins Demo: Translation to XDS Modula-2",
                                                       (* window caption               *)
                       Windows.WS_OVERLAPPEDWINDOW,    (* window style                 *)
                       Windows.CW_USEDEFAULT,          (* initial x position           *)
                       Windows.CW_USEDEFAULT,          (* initial y position           *)
                       Windows.CW_USEDEFAULT,          (* initial x size               *)
                       Windows.CW_USEDEFAULT,          (* initial y size               *)
                       NIL,                            (* parent window handle         *)
                       NIL,                            (* window menu handle           *)
                       wc.hInstance,                   (* program instance handle      *)
                       NIL);                           (* creation parameters          *)

  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  Windows.ShowWindow (hwnd, Windows.SW_SHOWDEFAULT);
  Windows.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;


BEGIN
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (Windows.GetMessage(msg,NIL,0,0)) DO
      Windows.TranslateMessage(msg);
      Windows.DispatchMessage(msg);
    END;
  END;
END EndJoin.
