<* +M2EXTENSIONS *>
MODULE LineDemo;
(*--------------------------------------------------
   LINEDEMO.C      --- Line-Drawing Demonstration Program
                   (c) Charles Petzold, 1996
   LineDemo.mod    --- Translation to XDS Modula-2
                   (c) Peter Stadler,   1997
  --------------------------------------------------*)

IMPORT Windows;


IMPORT SYSTEM;

CONST
  szAppName  =  "LineDemo";
VAR
   hwnd            :  Windows.HWND;
   msg             :  Windows.MSG;
   wc              :  Windows.WNDCLASSEX;
   cxClient        :  INTEGER;
   cyClient        :  INTEGER;


    

    

(*++++*****************************************************************)
PROCEDURE [Windows.CALLBACK] WndProc(hwnd       : Windows.HWND;
(**********************************************************************)
                                    iMsg        : Windows.UINT;
                                    wParam      : Windows.WPARAM;
                                    lParam      : Windows.LPARAM) : Windows.LRESULT;
VAR
  hdc     :  Windows.HDC;
  ps      :  Windows.PAINTSTRUCT;

BEGIN

  CASE (iMsg)  OF
          | Windows.WM_SIZE:
               cxClient := Windows.LOWORD (lParam);
               cyClient := Windows.HIWORD (lParam);
               RETURN 0;

          | Windows.WM_PAINT:
               hdc := Windows.BeginPaint (hwnd, ps);

               Windows.Rectangle (hdc,     cxClient DIV 8,     cyClient DIV 8,
                                      7 * cxClient DIV 8, 7 * cyClient DIV 8);

               Windows.MoveToEx  (hdc,        0,        0, NIL);
               Windows.LineTo    (hdc, cxClient, cyClient);

               Windows.MoveToEx  (hdc,        0, cyClient, NIL);
               Windows.LineTo    (hdc, cxClient,        0);

               Windows.Ellipse   (hdc,     cxClient DIV 8,     cyClient DIV 8,
                                      7 * cxClient DIV 8, 7 * cyClient DIV 8);

               Windows.RoundRect (hdc,     cxClient DIV 4,     cyClient DIV 4,
                                      3 * cxClient DIV 4, 3 * cyClient DIV 4,
                                          cxClient DIV 4,     cyClient DIV 4);

               Windows.EndPaint (hwnd, ps);
               RETURN 0;

          | Windows.WM_DESTROY:
               Windows.PostQuitMessage (0);
               RETURN 0;
     ELSE
         RETURN Windows.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
END WndProc;

(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
BEGIN
  wc.cbSize        := SIZE(wc);
  wc.style         := Windows.CS_HREDRAW + Windows.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := Windows.MyInstance();
  wc.hIcon         := Windows.LoadIcon (NIL, Windows.IDI_APPLICATION);
  wc.hCursor       := Windows.LoadCursor (NIL, Windows.IDC_ARROW);
  wc.hbrBackground := SYSTEM.CAST(Windows.HBRUSH, Windows.GetStockObject (Windows.WHITE_BRUSH));
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := Windows.LoadIcon (NIL,Windows.IDI_APPLICATION);

  RETURN Windows.RegisterClassEx(wc)#0;
END InitApplication;

(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := Windows.CreateWindow (
                       szAppName,                      (* window class name            *)
                       "Line Demonstration: Translation to XDS Modula-2",
                                                       (* window caption               *)
                       Windows.WS_OVERLAPPEDWINDOW,    (* window style                 *)
                       Windows.CW_USEDEFAULT,          (* initial x position           *)
                       Windows.CW_USEDEFAULT,          (* initial y position           *)
                       Windows.CW_USEDEFAULT,          (* initial x size               *)
                       Windows.CW_USEDEFAULT,          (* initial y size               *)
                       NIL,                            (* parent window handle         *)
                       NIL,                            (* window menu handle           *)
                       wc.hInstance,                   (* program instance handle      *)
                       NIL);                           (* creation parameters          *)

  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  Windows.ShowWindow (hwnd, Windows.SW_SHOWDEFAULT);
  Windows.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;


BEGIN
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (Windows.GetMessage(msg,NIL,0,0)) DO
      Windows.TranslateMessage(msg);
      Windows.DispatchMessage(msg);
    END;
  END;
END LineDemo.
