<* +M2EXTENSIONS *>
(*----------------------------------------------
   METAFILE.C      ---  Metafile Demonstration Program
                   (c)  Charles Petzold, 1996
   MetaFile.mod    ---  Translation to XDS Modula-2
                   (c)  Peter Stadler,   1997
  ----------------------------------------------*)
MODULE MetaFile;

IMPORT Windows;



IMPORT SYSTEM;

CONST AppName = "MetaFile";
VAR
  hwnd     :   Windows.HWND;
  msg      :   Windows.MSG;
  wc       :   Windows.WNDCLASSEX;
VAR (* static in WndProc *)
  hmf      :   Windows.HMETAFILE;
  cxClient :   INTEGER;
  cyClient :   INTEGER;


    

    

(*++++**********************************************************************)
PROCEDURE [Windows.CALLBACK] WndProc (hwnd        : Windows.HWND;
                                      iMsg        : Windows.UINT;
                                      wParam      : Windows.WPARAM;
                                      lParam      : Windows.LPARAM) : Windows.LRESULT;
(***************************************************************************)
VAR
   hBrush         :   Windows.HBRUSH;
   hdc            :   Windows.HDC;
   hdcMeta        :   Windows.HDC;
   x              :   INTEGER;
   y              :   INTEGER;
   ps             :   Windows.PAINTSTRUCT;
BEGIN

  CASE (iMsg) OF
  | Windows.WM_CREATE:
       hdcMeta := Windows.CreateMetaFile (NIL);
       hBrush  := Windows.CreateSolidBrush (Windows.RGB (0, 0, 255));

       Windows.Rectangle (hdcMeta, 0, 0, 100, 100);

       Windows.MoveToEx (hdcMeta,   0,   0, NIL);
       Windows.LineTo   (hdcMeta, 100, 100);
       Windows.MoveToEx (hdcMeta,   0, 100, NIL);
       Windows.LineTo   (hdcMeta, 100,   0);

       Windows.SelectObject (hdcMeta, SYSTEM.CAST(Windows.HGDIOBJ,hBrush));
       Windows.Ellipse (hdcMeta, 20, 20, 80, 80);

       hmf := Windows.CloseMetaFile (hdcMeta);

       Windows.DeleteObject (SYSTEM.CAST(Windows.HGDIOBJ,hBrush));
       RETURN 0;

  | Windows.WM_SIZE:
       cxClient := Windows.LOWORD (lParam);
       cyClient := Windows.HIWORD (lParam);
       RETURN 0;

  | Windows.WM_PAINT:
      hdc := Windows.BeginPaint (hwnd, ps);

      Windows.SetMapMode (hdc,Windows.MM_ANISOTROPIC);
      Windows.SetWindowExtEx (hdc, 1000, 1000, NIL);
      Windows.SetViewportExtEx (hdc, cxClient, cyClient, NIL);

      FOR  x := 0 TO 10-1 DO
           FOR y := 0 TO 10-1 DO
                Windows.SetWindowOrgEx (hdc, -100 * x, -100 * y,NIL);
                Windows.PlayMetaFile (hdc, hmf);
           END;
      END;

      Windows.EndPaint (hwnd, ps);
      RETURN 0;

  | Windows.WM_DESTROY:
      Windows.DeleteMetaFile (hmf);
      Windows.PostQuitMessage (0);
      RETURN 0;
  ELSE
    RETURN Windows.DefWindowProc (hwnd, iMsg, wParam, lParam);
  END;
END WndProc;

(*+++******************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
VAR
  rc   :  CARDINAL;
BEGIN
  wc.cbSize        := SIZE(Windows.WNDCLASSEX);
  wc.style         := Windows.CS_HREDRAW + Windows.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := Windows.MyInstance();
  wc.hIcon         := Windows.LoadIcon (NIL, Windows.IDI_APPLICATION);
  wc.hCursor       := Windows.LoadCursor (NIL, Windows.IDC_ARROW);
  wc.hbrBackground := SYSTEM.CAST(Windows.HBRUSH, Windows.GetStockObject (Windows.WHITE_BRUSH));
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(AppName);
  wc.hIconSm       := Windows.LoadIcon (NIL, Windows.IDI_APPLICATION);

  rc := Windows.RegisterClassEx (wc);
  RETURN rc #0;
END InitApplication;

(*+++******************************************************************)
PROCEDURE InitMainWindow() : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := Windows.CreateWindow (AppName,
                       "MetaFile Demonstration: Translation to XDS Modula-2",
                       Windows.WS_OVERLAPPEDWINDOW,
                       Windows.CW_USEDEFAULT,
                       Windows.CW_USEDEFAULT,
                       Windows.CW_USEDEFAULT,
                       Windows.CW_USEDEFAULT,
                       NIL,
                       NIL,
                       Windows.MyInstance(),
                       NIL);

  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  Windows.ShowWindow (hwnd, Windows.SW_SHOWDEFAULT);
  Windows.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;
BEGIN
  IF InitApplication() AND InitMainWindow() THEN
    WHILE (Windows.GetMessage (msg, NIL, 0, 0)) DO
      Windows.TranslateMessage (msg);
      Windows.DispatchMessage (msg);
    END;
  END;
END MetaFile.
