<* +M2EXTENSIONS *>
MODULE SCRAMBLE;
(*------------------------------------------------
   SCRAMBLE.C   -- Scramble (and Unscramble) Screen
                   (c) Charles Petzold, 1996
   SCRAMBLE.MOD -- Translation to XDS Modula-2
                   (c) Peter Stadler,   1997
  ------------------------------------------------*)


IMPORT Windows;


IMPORT SYSTEM;
IMPORT Lib;

CONST NUM = 200;

VAR
  iKeep   : ARRAY[0..NUM-1],[0..3] OF INTEGER;
  hdc     : Windows.HDC;
  hdcMem  : Windows.HDC;
  cx      : INTEGER;
  cy      : INTEGER;
  hBitmap : Windows.HBITMAP;
  i       : INTEGER;
  j       : INTEGER;
  x1      : INTEGER;
  y1      : INTEGER;
  x2      : INTEGER;
  y2      : INTEGER;
BEGIN

     IF (Windows.LockWindowUpdate (Windows.GetDesktopWindow ())) THEN
          hdc     := Windows.CreateDC ("DISPLAY", "", "", NIL) ;
          hdcMem  := Windows.CreateCompatibleDC (hdc) ;
          cx  := Windows.GetSystemMetrics (Windows.SM_CXSCREEN) / 10 ;
          cy  := Windows.GetSystemMetrics (Windows.SM_CYSCREEN) / 10 ;
          hBitmap := Windows.CreateCompatibleBitmap (hdc, cx, cy) ;

          Windows.SelectObject (hdcMem, SYSTEM.CAST(Windows.HGDIOBJ,hBitmap)) ;

          (*srand ((int) GetCurrentTime ()) ;*)

          FOR i := 0  TO 2-1 DO
               FOR  j := 0 TO NUM-1 DO
                    IF (i = 0) THEN
                         x1 := cx * VAL(INTEGER,(Lib.RANDOM (10) MOD 10));
                         iKeep [j,0] := x1;
                         y1 := cy * VAL(INTEGER,(Lib.RANDOM (10) MOD 10));
                         iKeep [j,1] := y1;
                         x2 := cx * VAL(INTEGER,(Lib.RANDOM (10) MOD 10));
                         iKeep [j,2] := x2;
                         y2 := cy * VAL(INTEGER,(Lib.RANDOM (10) MOD 10));
                         iKeep [j,3] := y2;
                    ELSE
                         x1 := iKeep [NUM - 1 - j] [0] ;
                         y1 := iKeep [NUM - 1 - j] [1] ;
                         x2 := iKeep [NUM - 1 - j] [2] ;
                         y2 := iKeep [NUM - 1 - j] [3] ;
                    END;
                    Windows.BitBlt (hdcMem, 0, 0, cx, cy, hdc,  x1, y1, Windows.SRCCOPY) ;
                    Windows.BitBlt (hdc,  x1, y1, cx, cy, hdc,  x2, y2, Windows.SRCCOPY) ;
                    Windows.BitBlt (hdc,  x2, y2, cx, cy, hdcMem, 0, 0, Windows.SRCCOPY) ;

                    Windows.Sleep (10) ;
               END;
          END;
          Windows.DeleteDC (hdcMem) ;
          Windows.DeleteDC (hdc) ;
          Windows.DeleteObject (SYSTEM.CAST(Windows.HGDIOBJ,hBitmap));

          Windows.LockWindowUpdate (NIL) ;
     END;
END SCRAMBLE.
