<* +M2EXTENSIONS *>

MODULE SineWave;
(*-----------------------------------------
   SINEWAVE.C      --- Sine Wave Using Polyline
                   (c) Charles Petzold, 1996
   SineWave.mod    --- Translation to XDS Modula-2
                   (c) Peter Stadler,   1997
  -----------------------------------------*)



IMPORT Windows;


IMPORT SYSTEM;
IMPORT Lib;
IMPORT RealMath;


CONST NUM =  1000;
CONST TWOPI = (2.0 * 3.14159);

CONST szAppName = "SineWave";
VAR
  hwnd  :  Windows.HWND;
  msg   :  Windows.MSG;
  wc    :  Windows.WNDCLASSEX;
  cxClient : INTEGER;
  cyClient : INTEGER;


    

    

(*++++*****************************************************************)
PROCEDURE [Windows.CALLBACK] WndProc(hwnd       : Windows.HWND;
(**********************************************************************)
                                    iMsg        : Windows.UINT;
                                    wParam      : Windows.WPARAM;
                                    lParam      : Windows.LPARAM) : Windows.LRESULT;
VAR
  hdc   :  Windows.HDC;
  i     :  INTEGER;
  ps    :  Windows.PAINTSTRUCT;
  pt    :  ARRAY[0..NUM] OF Windows.POINT;

BEGIN
     CASE (iMsg) OF
          | Windows.WM_SIZE:
               cxClient := Windows.LOWORD (lParam);
               cyClient := Windows.HIWORD (lParam);
               RETURN 0;

          | Windows.WM_PAINT:
               hdc := Windows.BeginPaint (hwnd, ps);

               Windows.MoveToEx (hdc, 0,        cyClient / 2, NIL);
               Windows.LineTo   (hdc, cxClient, cyClient / 2);

               FOR i := 0 TO NUM-1 DO
                    pt[i].x := i * cxClient / NUM;
                    pt[i].y := VAL(INTEGER,(FLOAT(cyClient) / 2.0 * (1.0 - RealMath.sin(TWOPI * FLOAT(i) / FLOAT(NUM)))));
               END;

               Windows.Polyline (hdc, pt, NUM);

               RETURN 0;

          | Windows.WM_DESTROY:
               Windows.PostQuitMessage (0);
               RETURN 0;
     ELSE

               RETURN Windows.DefWindowProc (hwnd, iMsg, wParam, lParam);

     END;
END WndProc;

(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
BEGIN
  wc.cbSize        := SIZE(Windows.WNDCLASSEX);
  wc.style         := Windows.CS_HREDRAW + Windows.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := Windows.MyInstance();
  wc.hIcon         := Windows.LoadIcon (NIL, Windows.IDI_APPLICATION);
  wc.hCursor       := Windows.LoadCursor (NIL, Windows.IDC_ARROW);
  wc.hbrBackground := SYSTEM.CAST(Windows.HBRUSH, Windows.GetStockObject (Windows.WHITE_BRUSH));
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := Windows.LoadIcon (NIL, Windows.IDI_APPLICATION);

  RETURN Windows.RegisterClassEx (wc)#0;
END InitApplication;
(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := Windows.CreateWindow
           (szAppName,                           (* window class name            *)
           "Sine Wave Using Polyline: Translation to XDS Modula-2",
                                                 (* window caption               *)
           Windows.WS_OVERLAPPEDWINDOW,          (* window style                 *)
           Windows.CW_USEDEFAULT,                (* initial x position           *)
           Windows.CW_USEDEFAULT,                (* initial y position           *)
           Windows.CW_USEDEFAULT,                (* initial x size               *)
           Windows.CW_USEDEFAULT,                (* initial y size               *)
           NIL,                                  (* parent window handle         *)
           NIL,                                  (* window menu handle           *)
           Windows.MyInstance(),                        (* program instance handle      *)
           NIL);                                 (* creation parameters          *)

  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  Windows.ShowWindow (hwnd, Windows.SW_SHOWDEFAULT);
  Windows.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;
(*++++*****************************************************************)
BEGIN
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (Windows.GetMessage(msg,NIL,0,0)) DO
      Windows.TranslateMessage(msg);
      Windows.DispatchMessage(msg);
    END;
  END;
END SineWave.
