<* +M2EXTENSIONS *>

MODULE WhatSize;
(*-----------------------------------------
   WHATSIZE.C   -- What Size is the Window?
                 (c) Charles Petzold, 1996
   WhatSize.MOD -- Translation to XDS Modula-2
                 (c) Peter Stadler 27.09.1997
  -----------------------------------------                                  *)



IMPORT Windows;


IMPORT SYSTEM;

CONST szAppName = "WhatSize";
VAR
  hwnd  :  Windows.HWND;
  msg   :  Windows.MSG;
  wc    :  Windows.WNDCLASSEX;
CONST             szHeading     =
                    "Mapping Mode            Left   Right     Top  Bottom";
                  szUndLine     =
                    "************            ***-   ***--     ***  ******";
VAR
   cxChar, cyChar : INTEGER;
(*++++*****************************************************************)
PROCEDURE Show (hwnd : Windows.HWND; hdc : Windows.HDC; xText,yText : INTEGER; iMapMode : Windows.MM_ENUM;
                szMapMode : ARRAY OF CHAR);
(**********************************************************************)
VAR
  szBuffer : ARRAY[0..59] OF CHAR;
  rect     : Windows.RECT;
  ptArr    : ARRAY[0..1] OF Windows.POINT;
BEGIN
     Windows.SaveDC (hdc);

     Windows.SetMapMode (hdc, iMapMode);
     Windows.GetClientRect (hwnd, rect);
     ptArr[0].x := rect.left;
     ptArr[0].y := rect.top;
     ptArr[1].x := rect.right;
     ptArr[1].y := rect.bottom;
     Windows.DPtoLP (hdc, ptArr, 2);

     Windows.RestoreDC (hdc, -1);

     Windows.TextOut (hdc, xText, yText, szBuffer,
               Windows.wsprintf (szBuffer, "%-20s %7d %7d %7d %7d", SYSTEM.ADR(szMapMode),
                    rect.left, rect.right, rect.top, rect.bottom));
END Show;


    

    

(*++++*****************************************************************)
PROCEDURE [Windows.CALLBACK] WndProc(hwnd       : Windows.HWND;
(**********************************************************************)
                                    iMsg        : Windows.UINT;
                                    wParam      : Windows.WPARAM;
                                    lParam      : Windows.LPARAM) : Windows.LRESULT;
VAR
  hdc   :  Windows.HDC;
  ps    :  Windows.PAINTSTRUCT;
  tm    :  Windows.TEXTMETRIC;

BEGIN
     CASE (iMsg) OF
          | Windows.WM_CREATE:
               hdc := Windows.GetDC (hwnd);
               Windows.SelectObject (hdc, Windows.GetStockObject (Windows.SYSTEM_FIXED_FONT));

               Windows.GetTextMetrics (hdc, tm);
               cxChar := tm.tmAveCharWidth;
               cyChar := tm.tmHeight + tm.tmExternalLeading;

               Windows.ReleaseDC (hwnd, hdc);
               RETURN 0;

          | Windows.WM_PAINT:
               hdc := Windows.BeginPaint (hwnd, ps);
               Windows.SelectObject (hdc, Windows.GetStockObject (Windows.SYSTEM_FIXED_FONT));

               Windows.SetMapMode (hdc, Windows.MM_ANISOTROPIC);
               Windows.SetWindowExtEx (hdc, 1, 1, NIL);
               Windows.SetViewportExtEx (hdc, cxChar, cyChar, NIL);

               Windows.TextOut (hdc, 1, 1, szHeading, LENGTH(szHeading));
               Windows.TextOut (hdc, 1, 2, szUndLine, LENGTH(szUndLine));

               Show (hwnd, hdc, 1, 3, Windows.MM_TEXT,      "TEXT (pixels)");
               Show (hwnd, hdc, 1, 4, Windows.MM_LOMETRIC,  "LOMETRIC (.1 mm)");
               Show (hwnd, hdc, 1, 5, Windows.MM_HIMETRIC,  "HIMETRIC (.01 mm)");
               Show (hwnd, hdc, 1, 6, Windows.MM_LOENGLISH, "LOENGLISH (.01 in)");
               Show (hwnd, hdc, 1, 7, Windows.MM_HIENGLISH, "HIENGLISH (.001 in)");
               Show (hwnd, hdc, 1, 8, Windows.MM_TWIPS,     "TWIPS (1\1440 in)");

               Windows.EndPaint (hwnd, ps);
               RETURN 0;

          | Windows.WM_DESTROY:
               Windows.PostQuitMessage (0);
               RETURN 0;
     ELSE
          RETURN Windows.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
END WndProc;

(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
BEGIN
  wc.cbSize        := SIZE(Windows.WNDCLASSEX);
  wc.style         := Windows.CS_HREDRAW + Windows.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := Windows.MyInstance();
  wc.hIcon         := Windows.LoadIcon (NIL, Windows.IDI_APPLICATION);
  wc.hCursor       := Windows.LoadCursor (NIL, Windows.IDC_ARROW);
  wc.hbrBackground := SYSTEM.CAST(Windows.HBRUSH, Windows.GetStockObject (Windows.WHITE_BRUSH));
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := Windows.LoadIcon (NIL, Windows.IDI_APPLICATION);

  RETURN Windows.RegisterClassEx (wc)#0;
END InitApplication;
(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := Windows.CreateWindow
           (szAppName,                           (* window class name            *)
           "What Size is the Window: Translation to XDS Modula-2",
                                                 (* window caption               *)
           Windows.WS_OVERLAPPEDWINDOW,          (* window style                 *)
           Windows.CW_USEDEFAULT,                (* initial x position           *)
           Windows.CW_USEDEFAULT,                (* initial y position           *)
           Windows.CW_USEDEFAULT,                (* initial x size               *)
           Windows.CW_USEDEFAULT,                (* initial y size               *)
           NIL,                                  (* parent window handle         *)
           NIL,                                  (* window menu handle           *)
           Windows.MyInstance(),                        (* program instance handle      *)
           NIL);                                 (* creation parameters          *)

  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  Windows.ShowWindow (hwnd, Windows.SW_SHOWDEFAULT);
  Windows.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;
(*++++*****************************************************************)
BEGIN
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (Windows.GetMessage(msg,NIL,0,0)) DO
      Windows.TranslateMessage(msg);
      Windows.DispatchMessage(msg);
    END;
  END;
END WhatSize.
