<* +M2EXTENSIONS *>
(*-----------------------------------------
   BLOKOUT1.C      --- Mouse Button Demo Program
                   (c) Charles Petzold, 1996
   BlokOut1.mod    --- Translation to XDS Modula-2
                   (c) Peter Stadler,   1997
  -----------------------------------------*)
MODULE BlokOut2;



IMPORT Windows;
IMPORT SYSTEM;

CONST
   szAppName = "BlokOut2";
VAR
  hwnd       :  Windows.HWND;
  msg        :  Windows.MSG;
  wc         :  Windows.WNDCLASSEX;
  fBlocking  :  BOOLEAN;
  fValidBox  :  BOOLEAN;
  ptBeg      :  Windows.POINT;
  ptEnd      :  Windows.POINT;
  ptBoxBeg   :  Windows.POINT;
  ptBoxEnd   :  Windows.POINT;

(*++++**********************************************************************)
PROCEDURE DrawBoxOutline (hwnd : Windows.HWND; ptBeg,ptEnd : Windows.POINT);
(***************************************************************************)
VAR
  hdc  :  Windows.HDC;

BEGIN
     hdc := Windows.GetDC (hwnd);

     Windows.SetROP2 (hdc, Windows.R2_NOT);
     Windows.SelectObject (hdc, Windows.GetStockObject (SYSTEM.CAST(Windows.STOCK_ENUM,0)));
     Windows.Rectangle (hdc, ptBeg.x, ptBeg.y, ptEnd.x, ptEnd.y);

     Windows.ReleaseDC (hwnd, hdc);
END DrawBoxOutline;



    

    

(*++++**********************************************************************)
PROCEDURE [Windows.CALLBACK] WndProc (hwnd        : Windows.HWND;
                                      iMsg        : Windows.UINT;
                                      wParam      : Windows.WPARAM;
                                      lParam      : Windows.LPARAM) : Windows.LRESULT;
(***************************************************************************)
VAR
  hdc     :  Windows.HDC;
  ps      :  Windows.PAINTSTRUCT;
BEGIN
     CASE (iMsg) OF
          | Windows.WM_LBUTTONDOWN :
               ptBeg.x := Windows.LOWORD (lParam);
               ptEnd.x := Windows.LOWORD (lParam);
               ptBeg.y := Windows.HIWORD (lParam);
               ptEnd.y := Windows.HIWORD (lParam);

               DrawBoxOutline (hwnd, ptBeg, ptEnd);
               Windows.SetCapture(hwnd);
               Windows.SetCursor (Windows.LoadCursor (NIL, Windows.IDC_CROSS));

               fBlocking := TRUE;
               RETURN 0;

          | Windows.WM_MOUSEMOVE :
               IF (fBlocking) THEN
                    Windows.SetCursor (Windows.LoadCursor (NIL, Windows.IDC_CROSS));

                    DrawBoxOutline (hwnd, ptBeg, ptEnd);

                    ptEnd.x := Windows.LOWORD (lParam);
                    ptEnd.y := Windows.HIWORD (lParam);

                    DrawBoxOutline (hwnd, ptBeg, ptEnd);
               END;
               RETURN 0;

          | Windows.WM_LBUTTONUP :
               IF (fBlocking) THEN
                    DrawBoxOutline (hwnd, ptBeg, ptEnd);

                    ptBoxBeg   := ptBeg;
                    ptBoxEnd.x := Windows.LOWORD (lParam);
                    ptBoxEnd.y := Windows.HIWORD (lParam);

                    Windows.ReleaseCapture();
                    Windows.SetCursor (Windows.LoadCursor (NIL, Windows.IDC_ARROW));

                    fBlocking := FALSE;
                    fValidBox  := TRUE;

                    Windows.InvalidateRect (hwnd, NIL, TRUE);
               END;
               RETURN 0;

          | Windows.WM_CHAR :
               IF (SYSTEM.CAST(Windows.UINT,fBlocking) - wParam = 27) THEN       (* ie, Escape           *)
                    DrawBoxOutline (hwnd, ptBeg, ptEnd);
                    Windows.ReleaseCapture();
                    Windows.SetCursor (Windows.LoadCursor (NIL, Windows.IDC_ARROW));

                    fBlocking := FALSE;
               END;
               RETURN 0;

          | Windows.WM_PAINT :
               hdc := Windows.BeginPaint (hwnd, ps);

               IF (fValidBox) THEN
                    Windows.SelectObject (hdc, Windows.GetStockObject (Windows.BLACK_BRUSH));
                    Windows.Rectangle (hdc, ptBoxBeg.x, ptBoxBeg.y,
                                    ptBoxEnd.x, ptBoxEnd.y);
               END;

               IF (fBlocking) THEN
                    Windows.SetROP2 (hdc, Windows.R2_NOT);
                     Windows.SelectObject (hdc, Windows.GetStockObject (SYSTEM.CAST(Windows.STOCK_ENUM,0)));
                    Windows.Rectangle (hdc, ptBeg.x, ptBeg.y, ptEnd.x, ptEnd.y);
               END;

               Windows.EndPaint (hwnd, ps);
               RETURN 0;

          | Windows.WM_DESTROY :
               Windows.PostQuitMessage (0);
               RETURN 0;
     ELSE
        RETURN Windows.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
END WndProc;

(*+++***********************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(***************************************************************************)
BEGIN
  wc.cbSize         := SIZE(Windows.WNDCLASSEX);
  wc.style          := Windows.CS_HREDRAW + Windows.CS_VREDRAW;
  wc.lpfnWndProc    := WndProc;
  wc.cbClsExtra     := 0;
  wc.cbWndExtra     := 0;
  wc.hInstance      := Windows.MyInstance();
  wc.hIcon          := Windows.LoadIcon (NIL, Windows.IDI_APPLICATION);
  wc.hCursor        := Windows.LoadCursor (NIL, Windows.IDC_ARROW);
  wc.hbrBackground  := SYSTEM.CAST(Windows.HBRUSH, Windows.GetStockObject (Windows.WHITE_BRUSH));
  wc.lpszMenuName   := NIL;
  wc.lpszClassName  := SYSTEM.ADR(szAppName);
  wc.hIconSm        := Windows.LoadIcon (NIL, Windows.IDI_APPLICATION);
  RETURN Windows.RegisterClassEx(wc)#0;
END InitApplication;
(*+++***********************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(***************************************************************************)
BEGIN
  hwnd  := Windows.CreateWindow (szAppName,
                       "Mouse Button & Capture Demo: Translation to XDS Modula-2",
                       Windows.WS_OVERLAPPEDWINDOW,
                       Windows.CW_USEDEFAULT,
                       Windows.CW_USEDEFAULT,
                       Windows.CW_USEDEFAULT,
                       Windows.CW_USEDEFAULT,
                       NIL,
                       NIL,
                       wc.hInstance,
                       NIL);

  IF hwnd = NIL THEN
     RETURN FALSE;
  END;
  Windows.ShowWindow (hwnd, Windows.SW_SHOWDEFAULT);
  Windows.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;
BEGIN
  IF InitApplication() AND InitMainWindow() THEN
    WHILE (Windows.GetMessage (msg, NIL, 0, 0)) DO
      Windows.TranslateMessage (msg);
      Windows.DispatchMessage (msg);
    END;
  END;
END BlokOut2.
