<* +M2EXTENSIONS *>
(*-------------------------------------------------
   CHECKER3.C      --- Mouse Hit-Test Demo Program No. 3
                   (c) Charles Petzold, 1996
   Checker3.mod    --- Translation to XDS Modula-2
                   (c) Peter Stadler,   1997
  -------------------------------------------------*)
MODULE Checker3;



IMPORT Windows;
IMPORT SYSTEM;

CONST
   szAppName = "Checker3";
   szChildClass = "Checker3_Child";
   DIVISIONS=5;
VAR
  hwnd       :  Windows.HWND;
  msg        :  Windows.MSG;
  wc         :  Windows.WNDCLASSEX;
VAR
  hwndChild  :  ARRAY[0..DIVISIONS-1],[0..DIVISIONS-1] OF Windows.HWND;




    

    

(*++++**********************************************************************)
PROCEDURE [Windows.CALLBACK] WndProc (hwnd        : Windows.HWND;
                                      iMsg        : Windows.UINT;
                                      wParam      : Windows.WPARAM;
                                      lParam      : Windows.LPARAM) : Windows.LRESULT;
(***************************************************************************)
VAR
  x       :  INTEGER;
  y       :  INTEGER;
  cxBlock :  INTEGER;
  cyBlock :  INTEGER;
BEGIN
     CASE (iMsg) OF
          | Windows.WM_CREATE :
               FOR x := 0 TO DIVISIONS-1 DO
                    FOR y := 0 TO DIVISIONS-1 DO
                         hwndChild[x][y] := Windows.CreateWindow(szChildClass, "",
                              Windows.WS_CHILDWINDOW + Windows.WS_VISIBLE,
                              0, 0, 0, 0,
                              hwnd, SYSTEM.CAST(Windows.HMENU, (SYSTEM.CAST(INTEGER,SYSTEM.SHIFT(SYSTEM.CAST(BITSET,y),8)) + x)),
                              SYSTEM.CAST(Windows.HINSTANCE,Windows.GetWindowLong (hwnd,Windows.GWL_HINSTANCE)),
                              NIL);
                    END;
               END;
               RETURN 0;

          | Windows.WM_SIZE :
               cxBlock := VAL(INTEGER,Windows.LOWORD (lParam)) DIV DIVISIONS;
               cyBlock := VAL(INTEGER,Windows.HIWORD (lParam)) DIV DIVISIONS;

               FOR x := 0 TO DIVISIONS-1 DO
                    FOR y := 0 TO DIVISIONS-1 DO
                         Windows.MoveWindow (hwndChild[x][y],
                              x * cxBlock, y * cyBlock,
                              cxBlock, cyBlock, TRUE);
                    END;
               END;
               RETURN 0;

          | Windows.WM_LBUTTONDOWN :
               Windows.MessageBeep (SYSTEM.CAST(Windows.MB_SET,0));
               RETURN 0;

          | Windows.WM_DESTROY :
               Windows.PostQuitMessage (0);
               RETURN 0;
     ELSE
         RETURN Windows.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
END WndProc;




    

    

(*++++**********************************************************************)
PROCEDURE [Windows.CALLBACK] ChildWndProc (hwnd        : Windows.HWND;
                                           iMsg        : Windows.UINT;
                                           wParam      : Windows.WPARAM;
                                           lParam      : Windows.LPARAM) : Windows.LRESULT;
(***************************************************************************)
VAR
  hdc     :  Windows.HDC;
  ps      :  Windows.PAINTSTRUCT;
  rect    :  Windows.RECT;
BEGIN
     CASE (iMsg) OF
          | Windows.WM_CREATE :
               Windows.SetWindowWord (hwnd, 0, 0);       (* on\off flag               *)
               RETURN 0;

          | Windows.WM_LBUTTONDOWN :
               Windows.SetWindowWord (hwnd, 0, 1 *Windows.GetWindowWord (hwnd, 0));
               Windows.InvalidateRect (hwnd, NIL, FALSE);
               RETURN 0;

          | Windows.WM_PAINT :
               hdc := Windows.BeginPaint (hwnd, ps);

               Windows.GetClientRect (hwnd, rect);
               Windows.Rectangle (hdc, 0, 0, rect.right, rect.bottom);

               IF (Windows.GetWindowWord (hwnd, 0)=1) THEN
                    Windows.MoveToEx (hdc, 0,          0,NIL);
                    Windows.LineTo (hdc, rect.right, rect.bottom);
                    Windows.MoveToEx (hdc, 0,          rect.bottom,NIL);
                    Windows.LineTo (hdc, rect.right, 0);
                END;

               Windows.EndPaint (hwnd, ps);
               RETURN 0;
     ELSE
         RETURN Windows.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
END ChildWndProc;

(*+++***********************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(***************************************************************************)
VAR
  rc   :  CARDINAL;
BEGIN
  wc.cbSize         := SIZE(Windows.WNDCLASSEX);
  wc.style          := Windows.CS_HREDRAW + Windows.CS_VREDRAW;
  wc.lpfnWndProc    := WndProc;
  wc.cbClsExtra     := 0;
  wc.cbWndExtra     := 0;
  wc.hInstance      := Windows.MyInstance();
  wc.hIcon          := Windows.LoadIcon (NIL, Windows.IDI_APPLICATION);
  wc.hCursor        := Windows.LoadCursor (NIL, Windows.IDC_ARROW);
  wc.hbrBackground  := SYSTEM.CAST(Windows.HBRUSH, Windows.GetStockObject (Windows.WHITE_BRUSH));
  wc.lpszMenuName   := NIL;
  wc.lpszClassName  := SYSTEM.ADR(szAppName);
  wc.hIconSm        := Windows.LoadIcon (NIL, Windows.IDI_APPLICATION);
  rc := Windows.RegisterClassEx(wc);

  wc.lpfnWndProc    := ChildWndProc;
  wc.cbWndExtra     := SIZE(Windows.WORD);
  wc.hIcon          := NIL;
  wc.lpszClassName  := SYSTEM.ADR(szChildClass);
  wc.hIconSm        := NIL;
  RETURN Windows.RegisterClassEx(wc)#0;
END InitApplication;
(*+++***********************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(***************************************************************************)
BEGIN
  hwnd  := Windows.CreateWindow (szAppName,
                       "Checker3 Mouse Hit-Test Demo: Translation to XDS Modula-2",
                       Windows.WS_OVERLAPPEDWINDOW,
                       Windows.CW_USEDEFAULT,
                       Windows.CW_USEDEFAULT,
                       Windows.CW_USEDEFAULT,
                       Windows.CW_USEDEFAULT,
                       NIL,
                       NIL,
                       wc.hInstance,
                       NIL);

  IF hwnd = NIL THEN
     RETURN FALSE;
  END;
  Windows.ShowWindow (hwnd, Windows.SW_SHOWDEFAULT);
  Windows.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;
BEGIN
  IF InitApplication() AND InitMainWindow() THEN
    WHILE (Windows.GetMessage (msg, NIL, 0, 0)) DO
      Windows.TranslateMessage (msg);
      Windows.DispatchMessage (msg);
    END;
  END;
END Checker3.
