<* +M2EXTENSIONS *>
(*--------------------------------------------------------------
   CONNECT.C       --- Connect-the-Dots Mouse Demo Program
                   (c) Charles Petzold, 1996
   Connect.mod     --- Translation to XDS Modula-2
                   (c) Peter Stadler,   1997
  ------------------------------------------------------------*)
MODULE Connect;



IMPORT Windows;
IMPORT SYSTEM;

CONST
   MAXPOINTS  = 1000;
CONST
   szAppName = "Connect";
 
VAR
  hwnd       :  Windows.HWND;
  msg        :  Windows.MSG;
  wc         :  Windows.WNDCLASSEX;
  iCount     :  INTEGER;
  points     :  ARRAY[0..MAXPOINTS] OF Windows.POINT;
  hdc        :  Windows.HDC;
  ps         :  Windows.PAINTSTRUCT;


    

    

(*++++**********************************************************************)
PROCEDURE [Windows.CALLBACK] WndProc (hwnd        : Windows.HWND;
                                      iMsg        : Windows.UINT;
                                      wParam      : Windows.WPARAM;
                                      lParam      : Windows.LPARAM) : Windows.LRESULT;
(***************************************************************************)
VAR
  i,j     :  INTEGER;
BEGIN
  CASE (iMsg) OF
  | Windows.WM_LBUTTONDOWN :
      iCount  := 0;
      Windows.InvalidateRect (hwnd, NIL, TRUE);
      RETURN 0;
  | Windows.WM_MOUSEMOVE :
     IF (wParam=1) AND (Windows.MK_LBUTTON=SYSTEM.CAST(Windows.MK_SET,1)) AND (iCount < 1000) THEN
       points[iCount].x  := Windows.LOWORD (lParam);
       points[iCount].y  := Windows.HIWORD (lParam);
       INC(iCount);

       hdc  := Windows.GetDC (hwnd);
       Windows.SetPixel (hdc, Windows.LOWORD (lParam), Windows.HIWORD (lParam), 0000h);
       Windows.ReleaseDC (hwnd, hdc);
     END;
     RETURN 0;
  | Windows.WM_LBUTTONUP :
      Windows.InvalidateRect (hwnd, NIL, FALSE);
      RETURN 0;
  | Windows.WM_PAINT :
      hdc  := Windows.BeginPaint (hwnd, ps);
      Windows.SetCursor (Windows.LoadCursor (NIL, Windows.IDC_WAIT));
      Windows.ShowCursor (TRUE);
      FOR i := 0 TO iCount - 2 DO
        FOR j  := i + 1 TO  iCount-1 DO
          Windows.MoveToEx (hdc, points[i].x, points[i].y,NIL);
          Windows.LineTo (hdc, points[j].x, points[j].y);
        END;
      END;
      Windows.ShowCursor (FALSE);
      Windows.SetCursor (Windows.LoadCursor (NIL, Windows.IDC_ARROW));
      Windows.EndPaint (hwnd, ps);
      RETURN 0;
  | Windows.WM_DESTROY :
      Windows.PostQuitMessage (0);
      RETURN 0;
  ELSE
    RETURN Windows.DefWindowProc (hwnd, iMsg, wParam, lParam);
  END;
END WndProc;

(*+++***********************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(***************************************************************************)
BEGIN
  wc.cbSize         := SIZE(Windows.WNDCLASSEX);
  wc.style          := Windows.CS_HREDRAW + Windows.CS_VREDRAW;
  wc.lpfnWndProc    := WndProc;
  wc.cbClsExtra     := 0;
  wc.cbWndExtra     := 0;
  wc.hInstance      := Windows.MyInstance();
  wc.hIcon          := Windows.LoadIcon (NIL, Windows.IDI_APPLICATION);
  wc.hCursor        := Windows.LoadCursor (NIL, Windows.IDC_ARROW);
  wc.hbrBackground  := SYSTEM.CAST(Windows.HBRUSH, Windows.GetStockObject (Windows.WHITE_BRUSH));
  wc.lpszMenuName   := NIL;
  wc.lpszClassName  := SYSTEM.ADR(szAppName);
  wc.hIconSm        := Windows.LoadIcon (NIL, Windows.IDI_APPLICATION);
  RETURN Windows.RegisterClassEx(wc)#0;
END InitApplication;
(*+++***********************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(***************************************************************************)
BEGIN
  hwnd  := Windows.CreateWindow (szAppName,
                       "Connect-the-Points Mouse Demo: Translation to Stony Brook Modula-2",
                       Windows.WS_OVERLAPPEDWINDOW,
                       Windows.CW_USEDEFAULT,
                       Windows.CW_USEDEFAULT,
                       Windows.CW_USEDEFAULT,
                       Windows.CW_USEDEFAULT,
                       NIL,
                       NIL,
                       wc.hInstance,
                       NIL);

  IF hwnd = NIL THEN
     RETURN FALSE;
  END;
  Windows.ShowWindow (hwnd, Windows.SW_SHOWDEFAULT);
  Windows.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;
BEGIN
  IF InitApplication() AND InitMainWindow() THEN
    WHILE (Windows.GetMessage (msg, NIL, 0, 0)) DO
      Windows.TranslateMessage (msg);
      Windows.DispatchMessage (msg);
    END;
  END;
END Connect.
