<* +M2EXTENSIONS *>
MODULE AnaClock;
(*-----------------------------------------
   ANACLOCK.C      --- Analog Clock Program
                   (c) Charles Petzold, 1996
   AnaClock.mod    --- Translation to XDS Modula-2
                   (c) Peter Stadler,   1998
  -----------------------------------------*)



IMPORT Windows;

IMPORT SYSTEM;
IMPORT SysClock;
IMPORT Str;
IMPORT RealMath;
IMPORT Lib;

CONST ID_TIMER = 1;
CONST TWOPI = 2.0 * 3.14159;
CONST szAppName = "DigClock";
VAR
  cxClient   : INTEGER;
  cyClient   : INTEGER;
  (*static in WndProc *)
  dtPrevious : SysClock.DateTime;
  datetime   : SysClock.DateTime;
VAR
   hwnd            :  Windows.HWND;
   msg             :  Windows.MSG;
   wc              :  Windows.WNDCLASSEX;
   iDHAngle        :  ARRAY[0..2] OF INTEGER;
TYPE
   PTARRAY              =  ARRAY[0..2],[0..4] OF Windows.POINT;
CONST(* static in DrawHands *)
   pt                   =  PTARRAY
                              {
                              {
                              {0, -150},{100, 0},{0, 600},{-100, 0},{0, -150}
                              },
                              {
                              {0, -200},{50, 0},{0, 800},{-50, 0},{0, -200}
                              },
                              {
                              {0,    0},{0, 0},{0,   0},{0, 0},{0,  800}
                              }
                              };

(*++++*****************************************************************)
PROCEDURE SetIsotropic (hdc         : Windows.HDC;
(**********************************************************************)
                        cxClient    : INTEGER;
                        cyClient    : INTEGER);
BEGIN
     Windows.SetMapMode (hdc, Windows.MM_ISOTROPIC);
     Windows.SetWindowExtEx (hdc, 1000, 1000, NIL);
     Windows.SetViewportExtEx (hdc, cxClient DIV 2, -cyClient DIV 2, NIL);
     Windows.SetViewportOrgEx (hdc, cxClient DIV 2,  cyClient DIV 2, NIL);
END SetIsotropic;

(*++++*****************************************************************)
PROCEDURE RotatePoint (VAR pt     : ARRAY OF Windows.POINT;
(**********************************************************************)
                       iNum       : INTEGER;
                       iAngle     : INTEGER);
VAR
  i       : INTEGER;
  ptTemp  : Windows.POINT;
  BEGIN
     FOR i := 0 TO iNum-1 DO
          ptTemp.x := VAL(INTEGER,(FLOAT(pt[i].x) * RealMath.cos (TWOPI * FLOAT(iAngle)/ 360.)) +
                             FLOAT(pt[i].y) * RealMath.sin (TWOPI * FLOAT(iAngle)/ 360.));
			
          ptTemp.y := VAL(INTEGER,(FLOAT(pt[i].y) * RealMath.cos (TWOPI * FLOAT(iAngle)/ 360.)) -
                             FLOAT(pt[i].x) * RealMath.sin (TWOPI * FLOAT(iAngle)/ 360.));

          pt[i] := ptTemp;
     END;
END RotatePoint;

(*++++*****************************************************************)
PROCEDURE DrawClock (hdc        : Windows.HDC);
(**********************************************************************)
VAR
  iAngle   : INTEGER;
  pt       : ARRAY[0..2] OF Windows.POINT;
BEGIN
     FOR iAngle := 0 TO 360-1 BY 6 DO
          pt[0].x :=   0;
          pt[0].y := 900;

          RotatePoint (pt, 1, iAngle);

          IF(iAngle REM 5 #0) THEN
             pt[2].x := 33;
             pt[2].y := 33;
          ELSE
             pt[2].x := 100;
             pt[2].y := 100;
          END;

          pt[0].x := pt[0].x - pt[2].x DIV 2;
          pt[0].y := pt[0].y - pt[2].y DIV 2;

          pt[1].x  := pt[0].x + pt[2].x;
          pt[1].y  := pt[0].y + pt[2].y;

          Windows.SelectObject (hdc, Windows.GetStockObject (Windows.BLACK_BRUSH));

          Windows.Ellipse (hdc, pt[0].x, pt[0].y, pt[1].x, pt[1].y);
     END;
END DrawClock;

(*++++*****************************************************************)
PROCEDURE DrawHands    (hdc         : Windows.HDC;
(**********************************************************************)
                        datetime    : SysClock.DateTime;
                        bChange     : BOOLEAN);
VAR
  i     :  INTEGER;

  ptTemp:  ARRAY[0..2],[0..4] OF Windows.POINT;
BEGIN
     iDHAngle[0] := (datetime.hour * 30) REM 360 + datetime.minute DIV 2;
     iDHAngle[1] :=  datetime.minute  *  6;
     iDHAngle[2] :=  datetime.second  *  6;


     SYSTEM.MOVE(SYSTEM.ADR(pt),SYSTEM.ADR(ptTemp), SIZE(pt));

     IF(bChange=TRUE) THEN
       FOR i := 0 TO 3-1 DO
            RotatePoint (ptTemp[i], 5, iDHAngle[i]);
            Windows.Polyline (hdc, ptTemp[i], 5);
       END;
     ELSE
       FOR i := 2 TO 3-1 DO
            RotatePoint (ptTemp[i], 5, iDHAngle[i]);
            Windows.Polyline (hdc, ptTemp[i], 5);
       END;
     END;
END DrawHands;







(*++++*****************************************************************)
PROCEDURE [Windows.CALLBACK] WndProc (hwnd        : Windows.HWND;
(**********************************************************************)
                             iMsg        : Windows.UINT;
                             wParam      : Windows.WPARAM;
                             lParam      : Windows.LPARAM) : Windows.LRESULT;
  VAR
      hdc    : Windows.HDC;
      ps     : Windows.PAINTSTRUCT;
      bChange: BOOLEAN;
BEGIN
     CASE (iMsg) OF
          | Windows.WM_CREATE :
               SysClock.GetClock(datetime);

               dtPrevious := datetime;
               RETURN 0;

          | Windows.WM_SIZE :
               cxClient := Windows.LOWORD (lParam);
               cyClient := Windows.HIWORD (lParam);
               RETURN 0;

          | Windows.WM_TIMER :
               SysClock.GetClock(datetime);

               bChange := (datetime.hour    # dtPrevious.hour) OR
                          (datetime.minute  # dtPrevious.minute);

               hdc := Windows.GetDC (hwnd);

               SetIsotropic (hdc, cxClient, cyClient);

               Windows.SelectObject (hdc, Windows.GetStockObject (Windows.WHITE_PEN));
               DrawHands (hdc, dtPrevious, bChange);

               Windows.SelectObject (hdc, Windows.GetStockObject (Windows.BLACK_PEN));
               DrawHands (hdc, datetime, TRUE);

               Windows.ReleaseDC (hwnd, hdc);

               dtPrevious := datetime;
               RETURN 0;

          | Windows.WM_PAINT :
               hdc := Windows.BeginPaint (hwnd, ps);

               SetIsotropic (hdc, cxClient, cyClient);
               DrawClock    (hdc);
               DrawHands    (hdc, dtPrevious, TRUE);

               Windows.EndPaint (hwnd, ps);
               RETURN 0;

          | Windows.WM_DESTROY :
               Windows.KillTimer (hwnd, ID_TIMER);
               Windows.PostQuitMessage (0);
               RETURN 0;
     ELSE
         RETURN Windows.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
END WndProc;

(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
VAR
  rc    :  CARDINAL;
BEGIN
  wc.cbSize        := SIZE(wc);
  wc.style         := Windows.CS_HREDRAW + Windows.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := Windows.MyInstance();
  wc.hIcon         := NIL;
  wc.hCursor       := Windows.LoadCursor (NIL, Windows.IDC_ARROW);
  wc.hbrBackground := SYSTEM.CAST(Windows.HBRUSH, Windows.GetStockObject (Windows.WHITE_BRUSH));
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := NIL;

  rc := Windows.RegisterClassEx(wc);
  RETURN rc#0;
END InitApplication;

(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := Windows.CreateWindow (szAppName,
                        "Analog Clock: Translation to XDS Modula-2",
                        Windows.WS_OVERLAPPEDWINDOW,
                        Windows.CW_USEDEFAULT, Windows.CW_USEDEFAULT,
                        Windows.CW_USEDEFAULT, Windows.CW_USEDEFAULT,
                        NIL,
                        NIL,
                        Windows.MyInstance(),
                        NIL);

  WHILE(Windows.SetTimer (hwnd, ID_TIMER, 1000, NIL)=0) DO
      Windows.MessageBox (hwnd,
                "Too many clocks or timers!",
                szAppName,
                Windows.MB_ICONEXCLAMATION + Windows.MB_OK);
      RETURN FALSE;
  END;
  Windows.ShowWindow (hwnd, Windows.SW_SHOWNOACTIVATE);
(*????*)
  Windows.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;


BEGIN
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (Windows.GetMessage(msg,NIL,0,0)) DO
      Windows.TranslateMessage(msg);
      Windows.DispatchMessage(msg);
    END;
  END;
END AnaClock.
