<* +M2EXTENSIONS *>
MODULE Beeper1;
(*-----------------------------------------
   BEEPER1.C       --- Timer Demo Program No. 1
                   (c) Charles Petzold, 1996
   Beeper1.mod     --- Translation to XDS Modula-2
                   (c) Peter Stadler,   1997
  -----------------------------------------*)



IMPORT Windows;

IMPORT SYSTEM;

CONST ID_TIMER = 1;

CONST szAppName = "Beeper1";
VAR
   hwnd            :  Windows.HWND;
   msg             :  Windows.MSG;
   wc              :  Windows.WNDCLASSEX;
   fFlipFlop       :  BOOLEAN;



    

    

(*++++*****************************************************************)
PROCEDURE [Windows.CALLBACK] WndProc (hwnd        : Windows.HWND;
(**********************************************************************)
                             iMsg        : Windows.UINT;
                             wParam      : Windows.WPARAM;
                             lParam      : Windows.LPARAM) : Windows.LRESULT;
  VAR hBrush : Windows.HBRUSH;
      hdc    : Windows.HDC;
      ps     : Windows.PAINTSTRUCT;
      rc     : Windows.RECT;
BEGIN      
     CASE (iMsg) OF                                                                                                                                                                                   
          | Windows.WM_TIMER :
               Windows.MessageBeep (SYSTEM.CAST(Windows.MB_SET,0));

               fFlipFlop :=  NOT fFlipFlop;
               Windows.InvalidateRect (hwnd, NIL, FALSE);

               RETURN 0;

          | Windows.WM_PAINT :
               hdc := Windows.BeginPaint (hwnd, ps);

               Windows.GetClientRect (hwnd, rc);

               IF(fFlipFlop=TRUE) THEN
                 hBrush := Windows.CreateSolidBrush (Windows.RGB(255,0,0));
               ELSE
                 hBrush := Windows.CreateSolidBrush (Windows.RGB(0,0,255));
               END;
               Windows.FillRect (hdc, rc, hBrush);
               Windows.EndPaint (hwnd, ps);
               Windows.DeleteObject (SYSTEM.CAST(Windows.HGDIOBJ,hBrush));
               RETURN 0;

          | Windows.WM_DESTROY :
               Windows.KillTimer (hwnd, ID_TIMER);
               Windows.PostQuitMessage (0);
               RETURN 0;
     ELSE
        RETURN Windows.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
END WndProc;

(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)

BEGIN
  wc.cbSize        := SIZE(wc);
  wc.style         := Windows.CS_HREDRAW + Windows.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := Windows.MyInstance();
  wc.hIcon         := Windows.LoadIcon (NIL, Windows.IDI_APPLICATION);
  wc.hCursor       := Windows.LoadCursor (NIL, Windows.IDC_ARROW);
  wc.hbrBackground := SYSTEM.CAST(Windows.HBRUSH, Windows.GetStockObject (Windows.WHITE_BRUSH));
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := Windows.LoadIcon (NIL,Windows.IDI_APPLICATION);

  RETURN Windows.RegisterClassEx(wc)#0;
END InitApplication;

(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := Windows.CreateWindow (szAppName,
                        "Beeper1 Timer Demo: Translation to XDS Modula-2",
                        Windows.WS_OVERLAPPEDWINDOW,
                        Windows.CW_USEDEFAULT,
                        Windows.CW_USEDEFAULT,
                        Windows.CW_USEDEFAULT,
                        Windows.CW_USEDEFAULT,
                        NIL,
                        NIL,
                        Windows.MyInstance(),
                        NIL);

  WHILE(Windows.SetTimer (hwnd, ID_TIMER, 1000, NIL)=0) DO 
      IF(Windows.IDCANCEL = Windows.MessageBox (hwnd,
                "Too many clocks or timers!",
                szAppName,
                Windows.MB_ICONEXCLAMATION + Windows.MB_RETRYCANCEL)) THEN
         RETURN FALSE;
      END;
	 
  END;
  Windows.ShowWindow (hwnd, Windows.SW_SHOWDEFAULT);
  Windows.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;


BEGIN
  fFlipFlop := FALSE;
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (Windows.GetMessage(msg,NIL,0,0)) DO
      Windows.TranslateMessage(msg);
      Windows.DispatchMessage(msg);
    END;
  END;
END Beeper1.
