<* +M2EXTENSIONS *>
MODULE BtnLook;
(*----------------------------------------
   BTNLOOK.C       --- Button Look Program
                   (c) Charles Petzold, 1996
   BtnLook.MOD     --- Translation to XDS Modula-2
                   (c) Peter Stadler,   1997
  ----------------------------------------*)
IMPORT Windows;



IMPORT SYSTEM;


CONST
  szAppName    =  "BtnLook";

TYPE
  Button    =  RECORD
                 style  :  Windows.WS_SET;
                 lpText :  ARRAY[0..50] OF CHAR;
               END;
  ButtonArr =   ARRAY[0..9] OF Button;


(*

*)
VAR
  hwnd         :  Windows.HWND;
  msg          :  Windows.MSG;
  wc           :  Windows.WNDCLASSEX;

(* static in WndProc *)
CONST
  szTop     = "iMsg            wParam       lParam";
  szUnd     = "____            ______       ______";
  szFormat  = "%-16s%04X-%04X    %04X-%04X";
  button = ButtonArr
   {
      {Windows.BS_PUSHBUTTON,      "PUSHBUTTON"},
      {Windows.BS_DEFPUSHBUTTON,   "DEFPUSHBUTTON"},
      {Windows.BS_CHECKBOX,        "CHECKBOX"},
      {Windows.BS_AUTOCHECKBOX,    "AUTOCHECKBOX"},
      {Windows.BS_RADIOBUTTON,     "RADIOBUTTON"},
      {Windows.BS_3STATE,          "3STATE"},
      {Windows.BS_AUTO3STATE,      "AUTO3STATE"},
      {Windows.BS_GROUPBOX,        "GROUPBOX"},
      {Windows.BS_AUTORADIOBUTTON, "AUTORADIO"},
      {Windows.BS_OWNERDRAW,       "OWNERDRAW"}
     };
CONST NUM = SIZE(button) DIV SIZE(button[0]);
VAR
  szBuffer  : ARRAY[0..49] OF CHAR;
  hwndButton: ARRAY[0..NUM-1] OF Windows.HWND;
  rect      : Windows.RECT;
  cxChar    : INTEGER;
  cyChar    : INTEGER;



    

    

(*++++*****************************************************************)
PROCEDURE [Windows.CALLBACK] WndProc (hwnd        : Windows.HWND;
(**********************************************************************)
                                      iMsg        : Windows.UINT;
                                      wParam      : Windows.WPARAM;
                                      lParam      : Windows.LPARAM) : Windows.LRESULT;
VAR
  i    :  INTEGER;
  tm   :  Windows.TEXTMETRIC;
  hdc  :  Windows.HDC;
  ps   :  Windows.PAINTSTRUCT;
  lpcr :  Windows.PCREATESTRUCT;
BEGIN
  CASE (iMsg) OF
          | Windows.WM_CREATE :
               hdc := Windows.GetDC (hwnd);
               Windows.SelectObject (hdc, Windows.GetStockObject (Windows.SYSTEM_FIXED_FONT));
               Windows.GetTextMetrics (hdc, tm);
               cxChar := tm.tmAveCharWidth;
               cyChar := tm.tmHeight + tm.tmExternalLeading;
               Windows.ReleaseDC (hwnd, hdc);

               FOR i := 0 TO NUM-1 DO
	            lpcr := SYSTEM.CAST(Windows.PCREATESTRUCT,lParam);
                    hwndButton[i] := Windows.CreateWindow ("button", button[i].lpText,
                              Windows.WS_CHILD + Windows.WS_VISIBLE + button[i].style,
                              cxChar, cyChar * (1 + 2 * i),
                              20 * cxChar, 7 * cyChar DIV 4,
                              hwnd, SYSTEM.CAST(Windows.HMENU,i),
                              lpcr^.hInstance,
                              NIL);
               END;
               RETURN 0;

          | Windows.WM_SIZE :
               rect.left   := 24 * cxChar;
               rect.top    :=  2 * cyChar;
               rect.right  := Windows.LOWORD (lParam);
               rect.bottom := Windows.HIWORD (lParam);
               RETURN 0;

          | Windows.WM_PAINT :
               Windows.InvalidateRect (hwnd, rect, TRUE);

               hdc := Windows.BeginPaint (hwnd, ps);
               Windows.SelectObject (hdc, Windows.GetStockObject (Windows.SYSTEM_FIXED_FONT));
               Windows.SetBkMode (hdc, Windows.TRANSPARENT);

               Windows.TextOut (hdc, 24 * cxChar, cyChar, szTop, SIZE (szTop) - 1);
               Windows.TextOut (hdc, 24 * cxChar, cyChar, szUnd, SIZE (szUnd) - 1);

               Windows.EndPaint (hwnd, ps);
               RETURN 0;

          | Windows.WM_DRAWITEM :
               Windows.ScrollWindow (hwnd, 0, -cyChar, rect, rect);

               hdc := Windows.GetDC (hwnd);
               Windows.SelectObject (hdc, Windows.GetStockObject (Windows.SYSTEM_FIXED_FONT));
               Windows.TextOut (hdc, 24 * cxChar, cyChar * (rect.bottom DIV cyChar - 1),
                        szBuffer,
                        Windows.wsprintf (szBuffer, szFormat,
                        "WM_DRAWITEM",
                        Windows.HIWORD (wParam), Windows.LOWORD (wParam),
                        Windows.HIWORD (lParam), Windows.LOWORD (lParam)));
               Windows.ReleaseDC (hwnd, hdc);
               Windows.ValidateRect (hwnd, rect);
               RETURN 0;
          | Windows.WM_COMMAND :
              Windows.ScrollWindow (hwnd, 0, -cyChar, rect, rect);

               hdc := Windows.GetDC (hwnd);
               Windows.SelectObject (hdc, Windows.GetStockObject (Windows.SYSTEM_FIXED_FONT));
               Windows.TextOut (hdc, 24 * cxChar, cyChar * (rect.bottom DIV cyChar - 1),
                        szBuffer,
                        Windows.wsprintf (szBuffer, szFormat,
                        "WM_COMMAND",
                        Windows.HIWORD (wParam), Windows.LOWORD (wParam),
                        Windows.HIWORD (lParam), Windows.LOWORD (lParam)));
               Windows.ReleaseDC (hwnd, hdc);
               Windows.ValidateRect (hwnd, rect);
               RETURN 0;
          | Windows.WM_DESTROY :
               Windows.PostQuitMessage (0);
               RETURN 0;
     ELSE
         RETURN Windows.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
     RETURN Windows.DefWindowProc (hwnd, iMsg, wParam, lParam);
END WndProc;


(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
BEGIN
  wc.cbSize        := SIZE(wc);
  wc.style         := Windows.CS_HREDRAW + Windows.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := Windows.MyInstance();
  wc.hIcon         := Windows.LoadIcon (NIL, Windows.IDI_APPLICATION);
  wc.hCursor       := Windows.LoadCursor (NIL, Windows.IDC_ARROW);
  wc.hbrBackground := SYSTEM.CAST(Windows.HBRUSH,Windows.GetStockObject (Windows.WHITE_BRUSH));
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := Windows.LoadIcon (NIL,Windows.IDI_APPLICATION);

  RETURN Windows.RegisterClassEx(wc)#0;
END InitApplication;

(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := Windows.CreateWindow (
                       szAppName,                      (* window class name            *)
                       "Button Look: Translation to XDS Modula-2",
                                                       (* window caption               *)
                       Windows.WS_OVERLAPPEDWINDOW,    (* window style                 *)
                       Windows.CW_USEDEFAULT,          (* initial x position           *)
                       Windows.CW_USEDEFAULT,          (* initial y position           *)
                       Windows.CW_USEDEFAULT,          (* initial x size               *)
                       Windows.CW_USEDEFAULT,          (* initial y size               *)
                       NIL,                            (* parent window handle         *)
                       NIL,                            (* window menu handle           *)
                       wc.hInstance,                   (* program instance handle      *)
                       NIL);                           (* creation parameters          *)

  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  Windows.ShowWindow (hwnd, Windows.SW_SHOWDEFAULT);
  Windows.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;


BEGIN
(*
   button := ButtonArr
   {
      {Windows.BS_PUSHBUTTON,      SYSTEM.ADR("PUSHBUTTON")},
      {Windows.BS_DEFPUSHBUTTON,   SYSTEM.ADR("DEFPUSHBUTTON")},
      {Windows.BS_CHECKBOX,        SYSTEM.ADR("CHECKBOX")},
      {Windows.BS_AUTOCHECKBOX,    SYSTEM.ADR("AUTOCHECKBOX")},
      {Windows.BS_RADIOBUTTON,     SYSTEM.ADR("RADIOBUTTON")},
      {Windows.BS_3STATE,          SYSTEM.ADR("3STATE")},
      {Windows.BS_AUTO3STATE,      SYSTEM.ADR("AUTO3STATE")},
      {Windows.BS_GROUPBOX,        SYSTEM.ADR("GROUPBOX")},
      {Windows.BS_AUTORADIOBUTTON, SYSTEM.ADR("AUTORADIO")},
      {Windows.BS_OWNERDRAW,       SYSTEM.ADR("OWNERDRAW")}
     };
*)
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (Windows.GetMessage(msg,NIL,0,0)) DO
      Windows.TranslateMessage(msg);
      Windows.DispatchMessage(msg);
    END;
  END;
END BtnLook.
