<* +M2EXTENSIONS *>
MODULE Environ;
(*----------------------------------------
   ENVIRON.C       --- Environment List Box
                   (c) Charles Petzold, 1996
   Environ.MOD     --- Translation to XDS Modula-2
                   (c) Peter Stadler,   1997
  ----------------------------------------*)
IMPORT Windows;



IMPORT SYSTEM;
IMPORT Str;
IMPORT ProgEnv;

CONST MAXENV =4096;
  szAppName    =  "Environ";
VAR
  hwnd         :  Windows.HWND;
  msg          :  Windows.MSG;
  wc           :  Windows.WNDCLASSEX;
TYPE
  PBUFFER      = POINTER TO ARRAY[0..MAXENV-1] OF CHAR;
  ONECHARSTR   = ARRAY[0..0] OF CHAR;

VAR
  lpszBuffer   :  PBUFFER;
  hwndList     :  Windows.HWND;
  hwndText     :  Windows.HWND;
  item         :  ARRAY[0..100] OF CHAR;



    

    

(*++++*****************************************************************)
PROCEDURE [Windows.CALLBACK] WndProc (hwnd        : Windows.HWND;
(**********************************************************************)
                                      iMsg        : Windows.UINT;
                                      wParam      : Windows.WPARAM;
                                      lParam      : Windows.LPARAM) : Windows.LRESULT;
VAR
  i,j  :  INTEGER;
  tm   :  Windows.TEXTMETRIC;
  hdc  :  Windows.HDC;
  ok   :  BOOLEAN;
CONST
  lb   =  "listbox";
  st   =  "static";
BEGIN
  CASE (iMsg) OF
          | Windows.WM_CREATE :
               hdc := Windows.GetDC (hwnd);
               Windows.GetTextMetrics (hdc, tm);
               Windows.ReleaseDC (hwnd, hdc);

               hwndList := Windows.CreateWindow (SYSTEM.ADR(lb), "",
                              Windows.WS_CHILD + Windows.WS_VISIBLE + Windows.LBS_STANDARD,
                              tm.tmAveCharWidth, tm.tmHeight * 3,
                              tm.tmAveCharWidth * 16 +
                              Windows.GetSystemMetrics (Windows.SM_CXVSCROLL),
                              tm.tmHeight * 5,
                              hwnd, SYSTEM.CAST(Windows.HMENU,1),
                              SYSTEM.CAST(Windows.HINSTANCE,Windows.GetWindowLong (hwnd, Windows.GWL_HINSTANCE)),
                              NIL);

               hwndText := Windows.CreateWindow (SYSTEM.ADR(st), "",
                              Windows.WS_CHILD + Windows.WS_VISIBLE + Windows.SS_LEFT,
                              tm.tmAveCharWidth,          tm.tmHeight,
                              tm.tmAveCharWidth * MAXENV, tm.tmHeight,
                              hwnd, SYSTEM.CAST(Windows.HMENU,2),
                              SYSTEM.CAST(Windows.HINSTANCE,Windows.GetWindowLong (hwnd, Windows.GWL_HINSTANCE)),
                              NIL);


               lpszBuffer:= SYSTEM.CAST(PBUFFER,Windows.GetEnvironmentStrings());
               i := 0;
	       item[0] := '';
               LOOP
                 LOOP
                   IF(lpszBuffer^[i]='') THEN
                     INC(i);
		     EXIT;
                   END;
                   Str.Append(item,SYSTEM.CAST(ONECHARSTR,lpszBuffer^[i]));
                   INC(i);
                 END;
                 IF(lpszBuffer^[i+1]='') THEN
                     EXIT;
                 END;
	         j := 0;
		 LOOP
		   IF(item[j]='=') THEN
		     item[j] := '';
		     EXIT;
		   END;  
                   INC(j);
		 END;
                 Windows.SendMessage (hwndList, Windows.LB_ADDSTRING, 0, SYSTEM.CAST(Windows.LPARAM,SYSTEM.ADR(item)));
	
                 item[0] := '';
	       END;
               RETURN 0;

          | Windows.WM_SETFOCUS :
               Windows.SetFocus (hwndList);
               RETURN 0;

          | Windows.WM_COMMAND :
               IF (Windows.LOWORD (wParam) = 1) AND (Windows.HIWORD (wParam) = Windows.LBN_SELCHANGE) THEN
                    i := Windows.SendMessage (hwndList, Windows.LB_GETCURSEL, 0, 0);
                    i := Windows.SendMessage (hwndList, Windows.LB_GETTEXT, i,
                                               SYSTEM.CAST(Windows.LPARAM,lpszBuffer)); 
                    ProgEnv.GetArg(i,item);
(*  
		    ok := Environment.GetSymbol(lpszBuffer^,item);
		    Str.Append(lpszBuffer^,'=');
		    Str.Append(lpszBuffer^,item);
*)
                    Windows.SetWindowText (hwndText, item);
               END;
               RETURN 0;

          | Windows.WM_DESTROY :
               Windows.PostQuitMessage (0);
               RETURN 0;
     ELSE
          RETURN Windows.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
END WndProc;

(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
VAR
  rc  :  CARDINAL;
BEGIN
  wc.cbSize        := SIZE(wc);
  wc.style         := Windows.CS_HREDRAW + Windows.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := Windows.MyInstance();
  wc.hIcon         := Windows.LoadIcon (NIL, Windows.IDI_APPLICATION);
  wc.hCursor       := Windows.LoadCursor (NIL, Windows.IDC_ARROW);
  wc.hbrBackground := SYSTEM.CAST(Windows.HBRUSH, SYSTEM.CAST(CARDINAL,Windows.COLOR_WINDOW)+1);
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := Windows.LoadIcon (NIL,Windows.IDI_APPLICATION);

 rc := Windows.RegisterClassEx(wc);
 RETURN rc#0;
END InitApplication;

(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := Windows.CreateWindow (
                       SYSTEM.ADR(szAppName),          (* window class name            *)
                       "Environment List Box: Translation to XDS Modula-2",
                                                       (* window caption               *)
                       Windows.WS_OVERLAPPEDWINDOW,    (* window style                 *)
                       Windows.CW_USEDEFAULT,          (* initial x position           *)
                       Windows.CW_USEDEFAULT,          (* initial y position           *)
                       Windows.CW_USEDEFAULT,          (* initial x size               *)
                       Windows.CW_USEDEFAULT,          (* initial y size               *)
                       NIL,                            (* parent window handle         *)
                       NIL,                            (* window menu handle           *)
                       wc.hInstance,                   (* program instance handle      *)
                       NIL);                           (* creation parameters          *)

  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  Windows.ShowWindow (hwnd, Windows.SW_SHOWDEFAULT);
  Windows.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;


BEGIN
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (Windows.GetMessage(msg,NIL,0,0)) DO
      Windows.TranslateMessage(msg);
      Windows.DispatchMessage(msg);
    END;
  END;
END Environ.
