<* +M2EXTENSIONS *>
MODULE PopPad1;
(*-------------------------------------------------------
   POPPAD1.C       --- Popup Editor using child window edit box
                   (c) Charles Petzold, 1996
   PopPad1.mod     --- Translation to XDS Modula-2
                   (c) Peter Stadler,   1998
  -------------------------------------------------------*)
IMPORT Windows;



IMPORT SYSTEM;

CONST
  szAppName    =  "PopPad1";

VAR
  hwnd         :  Windows.HWND;
  msg          :  Windows.MSG;
  wc           :  Windows.WNDCLASSEX;
  hwndEdit     :  Windows.HWND;


    

    

(*++++*****************************************************************)
PROCEDURE [Windows.CALLBACK] WndProc (hwnd        : Windows.HWND;
(**********************************************************************)
                                      iMsg        : Windows.UINT;
                                      wParam      : Windows.WPARAM;
                                      lParam      : Windows.LPARAM) : Windows.LRESULT;
VAR
  lpcr    : Windows.PCREATESTRUCT;
BEGIN
  CASE (iMsg) OF
          | Windows.WM_CREATE :
               lpcr := SYSTEM.CAST(Windows.PCREATESTRUCT,lParam);
               hwndEdit := Windows.CreateWindow ("edit",
                         "",
                         Windows.WS_CHILD + Windows.WS_VISIBLE + Windows.WS_HSCROLL + Windows.WS_VSCROLL +
                              Windows.WS_BORDER + Windows.ES_LEFT + Windows.ES_MULTILINE +
                              Windows.ES_AUTOHSCROLL + Windows.ES_AUTOVSCROLL,
                         0,
                         0,
                         0,
                         0,
                         hwnd,
                         SYSTEM.CAST(Windows.HMENU,1),
                         (* statt
                         (SYSTEM.CAST(Windows.LPCREATESTRUCT, lParam) ^. hInstance, NIL);
                         *)    
                         lpcr^.hInstance,
                         NIL);
                               
               RETURN 0;

          | Windows.WM_SETFOCUS :
               Windows.SetFocus (hwndEdit);
               RETURN 0;

          | Windows.WM_SIZE :
               Windows.MoveWindow (hwndEdit, 0, 0, Windows.LOWORD (lParam),
                                           Windows.HIWORD (lParam), TRUE);
               RETURN 0;

          | Windows.WM_COMMAND :
               IF (Windows.LOWORD (wParam) = 1) THEN
                    IF (Windows.HIWORD (wParam) = Windows.EN_ERRSPACE) OR
                       (Windows.HIWORD (wParam) = Windows.EN_MAXTEXT) THEN
                              Windows.MessageBox (hwnd, "Edit control out of space.",
                                          szAppName, Windows.MB_OK + Windows.MB_ICONSTOP);
                    END;
	       END;
	       RETURN 0;

          | Windows.WM_DESTROY :
               Windows.PostQuitMessage (0);
               RETURN 0;
     ELSE
               RETURN Windows.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
END WndProc;

(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
VAR
  rc   :  CARDINAL;
BEGIN
  wc.cbSize        := SIZE(wc);
  wc.style         := Windows.CS_HREDRAW + Windows.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := Windows.MyInstance();
  wc.hIcon         := Windows.LoadIcon (NIL, Windows.IDI_APPLICATION);
  wc.hCursor       := Windows.LoadCursor (NIL, Windows.IDC_ARROW);
  wc.hbrBackground := SYSTEM.CAST(Windows.HBRUSH,Windows.GetStockObject(Windows.WHITE_BRUSH));
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := Windows.LoadIcon (NIL,Windows.IDI_APPLICATION);

  rc := Windows.RegisterClassEx(wc);
  RETURN rc#0;           END InitApplication;

(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := Windows.CreateWindow (
                       szAppName,                      (* window class name            *)
                       "PopPad1: Translation to XDS Modula-2",
                                                       (* window caption               *)
                       Windows.WS_OVERLAPPEDWINDOW,    (* window style                 *)
                       Windows.CW_USEDEFAULT,          (* initial x position           *)
                       Windows.CW_USEDEFAULT,          (* initial y position           *)
                       Windows.CW_USEDEFAULT,          (* initial x size               *)
                       Windows.CW_USEDEFAULT,          (* initial y size               *)
                       NIL,                            (* parent window handle         *)
                       NIL,                            (* window menu handle           *)
                       wc.hInstance,                   (* program instance handle      *)
                       NIL);                           (* creation parameters          *)

  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  Windows.ShowWindow (hwnd, Windows.SW_SHOWDEFAULT);
  Windows.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;


BEGIN
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (Windows.GetMessage(msg,NIL,0,0)) DO
      Windows.TranslateMessage(msg);
      Windows.DispatchMessage(msg);
    END;
  END;
END PopPad1.
