<* +M2EXTENSIONS *>

MODULE Resourc2;
(*-----------------------------------------------------------
   RESOURC2.C      --- Icon and Cursor Demonstration Program No. 2
                   (c) Charles Petzold, 1996
   Resourc2.mod    --- Translation to XDS Modula-2
                   (c) Peter Stadler,   1997
  -----------------------------------------------------------*)






IMPORT Windows;


IMPORT SYSTEM;

CONST
     szAppName = "Resourc2";
VAR
   hwnd            :  Windows.HWND;
   msg             :  Windows.MSG;
   wc              :  Windows.WNDCLASSEX;
   hInst           :  Windows.HINSTANCE;
   hIcon           :  Windows.HICON;
   hBitmap         :  Windows.HBITMAP;
   hBrush          :  Windows.HBRUSH;
   cxIcon          :  INTEGER;
   cyIcon          :  INTEGER;
   cxClient        :  INTEGER;
   cyClient        :  INTEGER;
   hdc             :  Windows.HDC;
   ps              :  Windows.PAINTSTRUCT;



    

    

(*++++*****************************************************************)
PROCEDURE [Windows.CALLBACK] WndProc (hwnd        : Windows.HWND;
(**********************************************************************)
                                      iMsg        : Windows.UINT;
                                      wParam      : Windows.WPARAM;
                                      lParam      : Windows.LPARAM) : Windows.LRESULT;
VAR
   x               :  INTEGER;
   y               :  INTEGER;
BEGIN
     CASE (iMsg) OF
          | Windows.WM_CREATE :
               hIcon := Windows.LoadIcon (hInst, szAppName);
               cxIcon := Windows.GetSystemMetrics (Windows.SM_CXICON);
               cyIcon := Windows.GetSystemMetrics (Windows.SM_CYICON);
               RETURN 0;

          | Windows.WM_SIZE :
               cxClient := Windows.LOWORD (lParam);
               cyClient := Windows.HIWORD (lParam);
               RETURN 0;

          | Windows.WM_PAINT :
               hdc := Windows.BeginPaint (hwnd, ps);
                y := cyIcon;
                LOOP
                  x := cxIcon;
                  LOOP 
                     Windows.DrawIcon (hdc, x, y, hIcon);
                     INC(x,2*cxIcon);
                     IF(x > cxClient) THEN
                        EXIT;
                     END;
                  END;
                  INC(y,2*cyIcon);
                  IF(y > cyClient) THEN
                     EXIT;
                  END;
               END;
               Windows.EndPaint (hwnd, ps);
               RETURN 0;

          | Windows.WM_DESTROY :
               Windows.PostQuitMessage (0);
               RETURN 0;
          ELSE
               RETURN Windows.DefWindowProc (hwnd, iMsg, wParam, lParam);
          END;
  END WndProc;

(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)

VAR
  rc : CARDINAL;
BEGIN
     hBitmap := Windows.LoadBitmap (Windows.MyInstance(), szAppName);
     hBrush := Windows.CreatePatternBrush (hBitmap);

     wc.cbSize        := SIZE(wc);
     wc.style         := Windows.CS_HREDRAW + Windows.CS_VREDRAW;
     wc.lpfnWndProc   := WndProc;
     wc.cbClsExtra    := 0;
     wc.cbWndExtra    := 0;
     wc.hInstance     := Windows.MyInstance();
     wc.hIcon         := Windows.LoadIcon (Windows.MyInstance(), szAppName);
     wc.hCursor       := Windows.LoadCursor (Windows.MyInstance(), szAppName);
     wc.hbrBackground := hBrush;
     wc.lpszMenuName  := NIL;
     wc.lpszClassName := SYSTEM.ADR(szAppName);
     wc.hIconSm       := Windows.LoadIcon (Windows.MyInstance(), szAppName);

     rc :=  Windows.RegisterClassEx(wc);
     RETURN rc#0;
END InitApplication;
(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hInst := Windows.MyInstance();

  hwnd := Windows.CreateWindow (szAppName,
                        "Icon and Cursor Demo 2: Translation to XDS Modula-2",
                        Windows.WS_OVERLAPPEDWINDOW,
                        Windows.CW_USEDEFAULT,
                        Windows.CW_USEDEFAULT,
                        Windows.CW_USEDEFAULT,
                        Windows.CW_USEDEFAULT,
                        NIL,
                        NIL,
                        Windows.MyInstance(),
                        NIL);

  Windows.ShowWindow (hwnd, Windows.SW_SHOWDEFAULT);
  Windows.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;

BEGIN
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (Windows.GetMessage(msg,NIL,0,0)) DO
      Windows.TranslateMessage(msg);
      Windows.DispatchMessage(msg);
    END;
  END;
  Windows.DeleteObject (SYSTEM.CAST(Windows.HGDIOBJ,hBrush));       (* clean-up      *)
  Windows.DeleteObject (SYSTEM.CAST(Windows.HGDIOBJ,hBitmap));
END Resourc2.
