<* +M2EXTENSIONS *>
MODULE NoPopUps;
(*-------------------------------------------------
   NOPOPUPS.C      --- Demonstrates No-Popup Nested Menu
                   (c) Charles Petzold, 1996
   NoPopUps.mod    --- Translation to XDS Modula-2
                   (c) Peter Stadler,   1997
  -------------------------------------------------*)




IMPORT h2d_NoPopUps;

IMPORT Windows;


IMPORT SYSTEM;
CONST
   szAppName = "NoPopUps";
VAR
   hwnd            :  Windows.HWND;
   msg             :  Windows.MSG;
   wc              :  Windows.WNDCLASSEX;
   hMenuMain       :  Windows.HMENU;
   hMenuEdit       :  Windows.HMENU;
   hMenuFile       :  Windows.HMENU;



    

    

(*++++*****************************************************************)
PROCEDURE [Windows.CALLBACK]  WndProc (hwnd        : Windows.HWND;
                                       iMsg        : Windows.UINT;
                                       wParam      : Windows.WPARAM;
                                       lParam      : Windows.LPARAM) : Windows.LRESULT;
(**********************************************************************)
VAR
   hInstance   :  Windows.HINSTANCE;
BEGIN

  CASE (iMsg) OF
          | Windows.WM_CREATE :
               hInstance := SYSTEM.CAST(Windows.HINSTANCE,Windows.GetWindowLong (hwnd, Windows.GWL_HINSTANCE));

               hMenuMain := Windows.LoadMenu (hInstance, "MenuMain");
               hMenuFile := Windows.LoadMenu (hInstance, "MenuFile");
               hMenuEdit := Windows.LoadMenu (hInstance, "MenuEdit");

               Windows.SetMenu (hwnd, hMenuMain);
               RETURN 0;

          | Windows.WM_COMMAND :
               CASE (Windows.LOWORD (wParam))                                                                                                                                                          OF
                    | h2d_NoPopUps.IDM_MAIN :
                         Windows.SetMenu (hwnd, hMenuMain);
                         RETURN 0;

                    | h2d_NoPopUps.IDM_FILE :
                         Windows.SetMenu (hwnd, hMenuFile);
                         RETURN 0;

                    | h2d_NoPopUps.IDM_EDIT :
                         Windows.SetMenu (hwnd, hMenuEdit);
                         RETURN 0;

                    | h2d_NoPopUps.IDM_NEW :
                         Windows.MessageBeep (SYSTEM.CAST(Windows.MB_SET,0));
                         RETURN 0;
                    | h2d_NoPopUps.IDM_OPEN :
                         Windows.MessageBeep (SYSTEM.CAST(Windows.MB_SET,0));
                         RETURN 0;
                    | h2d_NoPopUps.IDM_SAVE :
                         Windows.MessageBeep (SYSTEM.CAST(Windows.MB_SET,0));
                         RETURN 0;
                    | h2d_NoPopUps.IDM_SAVEAS :
                         Windows.MessageBeep (SYSTEM.CAST(Windows.MB_SET,0));
                         RETURN 0;
                    | h2d_NoPopUps.IDM_UNDO :
                         Windows.MessageBeep (SYSTEM.CAST(Windows.MB_SET,0));
                         RETURN 0;
                    | h2d_NoPopUps.IDM_CUT :
                         Windows.MessageBeep (SYSTEM.CAST(Windows.MB_SET,0));
                         RETURN 0;
                    | h2d_NoPopUps.IDM_COPY :
                         Windows.MessageBeep (SYSTEM.CAST(Windows.MB_SET,0));
                         RETURN 0;
                    | h2d_NoPopUps.IDM_PASTE :
                         Windows.MessageBeep (SYSTEM.CAST(Windows.MB_SET,0));
                         RETURN 0;
                    | h2d_NoPopUps.IDM_DEL :
                         Windows.MessageBeep (SYSTEM.CAST(Windows.MB_SET,0));
                         RETURN 0;
               ELSE
                 RETURN 0;
               END;

          | Windows.WM_DESTROY :
               Windows.SetMenu (hwnd, hMenuMain);
               Windows.DestroyMenu (hMenuFile);
               Windows.DestroyMenu (hMenuEdit);

               Windows.PostQuitMessage (0);
               RETURN 0;
     ELSE
         RETURN Windows.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
END WndProc;


(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
BEGIN
  wc.cbSize        := SIZE(Windows.WNDCLASSEX);
  wc.style         := Windows.CS_HREDRAW + Windows.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := Windows.MyInstance();
  wc.hIcon         := Windows.LoadIcon (NIL, Windows.IDI_APPLICATION);
  wc.hCursor       := Windows.LoadCursor (NIL, Windows.IDC_ARROW);
  wc.hbrBackground := SYSTEM.CAST(Windows.HBRUSH, Windows.GetStockObject (Windows.WHITE_BRUSH));
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := Windows.LoadIcon (NIL, Windows.IDI_APPLICATION);

  RETURN Windows.RegisterClassEx (wc)#0;
END InitApplication;
(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := Windows.CreateWindow
           (szAppName,                           (* window class name            *)
           "No-Popup Nested Menu Demonstration: Translation to XDS Modula-2",
                                                 (* window caption               *)
           Windows.WS_OVERLAPPEDWINDOW,          (* window style                 *)
           Windows.CW_USEDEFAULT,                (* initial x position           *)
           Windows.CW_USEDEFAULT,                (* initial y position           *)
           Windows.CW_USEDEFAULT,                (* initial x size               *)
           Windows.CW_USEDEFAULT,                (* initial y size               *)
           NIL,                                  (* parent window handle         *)
           NIL,                                  (* window menu handle           *)
           Windows.MyInstance(),                        (* program instance handle      *)
           NIL);                                 (* creation parameters          *)

  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  Windows.ShowWindow (hwnd, Windows.SW_SHOWDEFAULT);
  Windows.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;
(*++++*****************************************************************)
BEGIN
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (Windows.GetMessage(msg,NIL,0,0)) DO
      Windows.TranslateMessage(msg);
      Windows.DispatchMessage(msg);
    END;
  END;
END NoPopUps.
