<* +M2EXTENSIONS *>
MODULE PoorMenu;
(*-----------------------------------------
   POORMENU.C      --- The Poor Person's Menu
                   (c) Charles Petzold, 1996
   PoorMenu.mod    --- Translation to XDS Modula-2
                   (c) Peter Stadler,   1998
  -----------------------------------------*)

IMPORT h2d_PopMenu;

IMPORT Windows;


IMPORT SYSTEM;
CONST
   szAppName = "PoorMenu";
VAR
   hwnd            :  Windows.HWND;
   msg             :  Windows.MSG;
   wc              :  Windows.WNDCLASSEX;
   hMenu           :  Windows.HMENU;
CONST IDM_ABOUT  = 1;
CONST IDM_HELP   = 2;
CONST IDM_REMOVE = 3;



    

    

(*++++*****************************************************************)
PROCEDURE [Windows.CALLBACK]  WndProc (hwnd        : Windows.HWND;
                                       iMsg        : Windows.UINT;
                                       wParam      : Windows.WPARAM;
                                       lParam      : Windows.LPARAM) : Windows.LRESULT;
(**********************************************************************)
BEGIN

  CASE (iMsg) OF
          | Windows.WM_SYSCOMMAND :
               CASE (Windows.LOWORD (wParam)) OF
                    | IDM_ABOUT :
                         Windows.MessageBox (hwnd, "A Poor-Person's Menu Program.",
                                     szAppName, Windows.MB_OK + Windows.MB_ICONINFORMATION);
                         RETURN 0;

                    | IDM_HELP :
                         Windows.MessageBox (hwnd, "Help not yet implemented!",
                                     szAppName, Windows.MB_OK + Windows.MB_ICONEXCLAMATION);
                         RETURN 0;

                    | IDM_REMOVE :
                         Windows.GetSystemMenu (hwnd, TRUE);
                         RETURN 0;
               ELSE
               END;

          | Windows.WM_DESTROY :
               Windows.PostQuitMessage (0);
               RETURN 0;
  ELSE
        RETURN Windows.DefWindowProc (hwnd, iMsg, wParam, lParam);
  END;
  RETURN Windows.DefWindowProc (hwnd, iMsg, wParam, lParam);
END WndProc;

(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
VAR
  rc    :  CARDINAL;
BEGIN
  wc.cbSize        := SIZE(Windows.WNDCLASSEX);
  wc.style         := Windows.CS_HREDRAW + Windows.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := Windows.MyInstance();
  wc.hIcon         := Windows.LoadIcon (NIL, Windows.IDI_APPLICATION);
  wc.hCursor       := Windows.LoadCursor (NIL, Windows.IDC_ARROW);
  wc.hbrBackground := SYSTEM.CAST(Windows.HBRUSH, Windows.GetStockObject (Windows.WHITE_BRUSH));
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := Windows.LoadIcon (NIL, Windows.IDI_APPLICATION);

  rc := Windows.RegisterClassEx (wc);
  RETURN rc #0;
END InitApplication;
(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := Windows.CreateWindow (szAppName,
           "The Poor-Person's Menu: Translation to XDS Modula-2",
                                                 (* window caption               *)
           Windows.WS_OVERLAPPEDWINDOW,          (* window style                 *)
           Windows.CW_USEDEFAULT,                (* initial x position           *)
           Windows.CW_USEDEFAULT,                (* initial y position           *)
           Windows.CW_USEDEFAULT,                (* initial x size               *)
           Windows.CW_USEDEFAULT,                (* initial y size               *)
           NIL,                                  (* parent window handle         *)
           NIL,                                  (* window menu handle           *)
           Windows.MyInstance(),                        (* program instance handle      *)
           NIL);                                 (* creation parameters          *)

  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  hMenu := Windows.GetSystemMenu (hwnd, FALSE);

  Windows.AppendMenu (hMenu, Windows.MF_SEPARATOR, 0,          NIL);
  Windows.AppendMenu (hMenu, Windows.MF_STRING,    IDM_ABOUT,  "About...");
  Windows.AppendMenu (hMenu, Windows.MF_STRING,    IDM_HELP,   "Help...");
  Windows.AppendMenu (hMenu, Windows.MF_STRING,    IDM_REMOVE, "Remove Additions");

  Windows.ShowWindow (hwnd, Windows.SW_SHOWDEFAULT);
  Windows.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;
(*++++*****************************************************************)
BEGIN
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (Windows.GetMessage(msg,NIL,0,0)) DO
      Windows.TranslateMessage(msg);
      Windows.DispatchMessage(msg);
    END;
  END;
END PoorMenu.
