<* +M2EXTENSIONS *>
MODULE PopPad2;
(*-----------------------------------------------------
   POPPAD2.C       --- Popup Editor Version 2 (includes menu)
                   (c) Charles Petzold, 1996
   PopPad2.mod     --- Translation to XDS Modula-2
                   (c) Peter Stadler,   1997
  -----------------------------------------------------*)






IMPORT Windows;


IMPORT h2d_poppad2;
IMPORT SYSTEM;
CONST
   szAppName = "PopPad2";
   szAppTitle = "PopPad2 : Translation to XDS Modula-2";

VAR
   hAccel          :  Windows.HACCEL;
   hwnd            :  Windows.HWND;
   msg             :  Windows.MSG;
   wc              :  Windows.WNDCLASSEX;
   hwndEdit        :  Windows.HWND;
   iSelect         :  INTEGER;
   iEnable         :  Windows.MF_SET;

PROCEDURE AskConfirmation (hwnd : Windows.HWND) : INTEGER;
BEGIN
     RETURN Windows.MessageBox (hwnd, "Really want to close PopPad2?",
                        szAppName, Windows.MB_YESNO + Windows.MB_ICONQUESTION);
END AskConfirmation;


    

    

(*++++*****************************************************************)
PROCEDURE [Windows.CALLBACK] WndProc (hwnd        : Windows.HWND;
(**********************************************************************)
                                      iMsg        : Windows.UINT;
                                      wParam      : Windows.WPARAM;
                                      lParam      : Windows.LPARAM) : Windows.LRESULT;

VAR
  bo   :  Windows.BOOL;
  lr   :  Windows.LRESULT;
  mf   :  Windows.MF_SET;
  lpcr    : Windows.PCREATESTRUCT;
BEGIN

     CASE (iMsg) OF
          | Windows.WM_CREATE :
               lpcr := SYSTEM.CAST(Windows.PCREATESTRUCT,lParam);
               hwndEdit := Windows.CreateWindow ("edit",
                         "",
                         Windows.WS_CHILD + Windows.WS_VISIBLE + Windows.WS_HSCROLL + Windows.WS_VSCROLL +
                              Windows.WS_BORDER + Windows.ES_LEFT + Windows.ES_MULTILINE +
                              Windows.ES_AUTOHSCROLL + Windows.ES_AUTOVSCROLL,
                         0,
                         0,
                         0,
                         0,
                         hwnd,
                         SYSTEM.CAST(Windows.HMENU,1),
                         (* statt
                         (SYSTEM.CAST(Windows.PCREATESTRUCT, lParam) ^. hInstance, NIL);
                         *)    
                         lpcr^.hInstance,
                         NIL);
               RETURN 0;

          | Windows.WM_SETFOCUS :
               Windows.SetFocus (hwndEdit);
               RETURN 0;

          | Windows.WM_SIZE :
               Windows.MoveWindow (hwndEdit, 0, 0, Windows.LOWORD (lParam),
                                           Windows.HIWORD (lParam), TRUE);
               RETURN 0;

          | Windows.WM_INITMENUPOPUP :
               IF (lParam = 1) THEN
                    lr := Windows.SendMessage (hwndEdit, Windows.EM_CANUNDO, 0, 0);
                    IF(lr=1) THEN
                      mf := Windows.MF_ENABLED;
                    ELSIF(lr=0) THEN
                      mf := Windows.MF_GRAYED;
                    END;
                    Windows.EnableMenuItem (SYSTEM.CAST(Windows.HMENU,wParam), h2d_poppad2.IDM_UNDO,mf);
                    bo := Windows.IsClipboardFormatAvailable (Windows.CF_TEXT);
                    IF(bo=TRUE) THEN
                      mf := Windows.MF_ENABLED;
                    ELSE
                      mf := Windows.MF_GRAYED;
                    END;
                    Windows.EnableMenuItem (SYSTEM.CAST(Windows.HMENU,wParam), h2d_poppad2.IDM_PASTE,mf);
                    iSelect := Windows.SendMessage (hwndEdit, Windows.EM_GETSEL, 0, 0);

                    IF (Windows.HIWORD (iSelect) = Windows.LOWORD (iSelect)) THEN
                         iEnable := Windows.MF_GRAYED;
                    ELSE
                         iEnable := Windows.MF_ENABLED;
	            END;
                    Windows.EnableMenuItem (SYSTEM.CAST(Windows.HMENU,wParam), h2d_poppad2.IDM_CUT,   iEnable);
                    Windows.EnableMenuItem (SYSTEM.CAST(Windows.HMENU,wParam), h2d_poppad2.IDM_COPY,  iEnable);
                    Windows.EnableMenuItem (SYSTEM.CAST(Windows.HMENU,wParam), h2d_poppad2.IDM_DEL,   iEnable);
                    RETURN 0;
               END;
          | Windows.WM_COMMAND :

               IF (lParam=1) THEN
                    IF (Windows.LOWORD (lParam) = 1) AND
                         ((Windows.HIWORD (wParam) = Windows.EN_ERRSPACE) OR (Windows.HIWORD (wParam) = Windows.EN_MAXTEXT)) THEN
                              Windows.MessageBox (hwnd, "Edit control out of space.",
                                          szAppName, Windows.MB_OK + Windows.MB_ICONSTOP);
                    RETURN 0;
                    END;
               ELSE
                 CASE (Windows.LOWORD (wParam)) OF
                         | h2d_poppad2.IDM_NEW :
                         | h2d_poppad2.IDM_OPEN :
                         | h2d_poppad2.IDM_SAVE :
                         | h2d_poppad2.IDM_SAVEAS :
                         | h2d_poppad2.IDM_PRINT :
                              Windows.MessageBeep (SYSTEM.CAST(Windows.MB_SET,0));
                              RETURN 0;

                         | h2d_poppad2.IDM_EXIT :
                              Windows.SendMessage (hwnd, Windows.WM_CLOSE, 0, 0);
                              RETURN 0;

                         | h2d_poppad2.IDM_UNDO :
                              Windows.SendMessage (hwndEdit, Windows.WM_UNDO, 0, 0);
                              RETURN 0;

                         | h2d_poppad2.IDM_CUT :
                              Windows.SendMessage (hwndEdit, Windows.WM_CUT, 0, 0);
                              RETURN 0;

                         | h2d_poppad2.IDM_COPY :
                              Windows.SendMessage (hwndEdit, Windows.WM_COPY, 0, 0);
                              RETURN 0;

                         | h2d_poppad2.IDM_PASTE :
                              Windows.SendMessage (hwndEdit, Windows.WM_PASTE, 0, 0);
                              RETURN 0;

                         | h2d_poppad2.IDM_DEL :
                              Windows.SendMessage (hwndEdit, Windows.WM_CLEAR, 0, 0);
                              RETURN 0;

                         | h2d_poppad2.IDM_SELALL :
                              Windows.SendMessage (hwndEdit, Windows.EM_SETSEL, 0,-1);
                              RETURN 0;

                         | h2d_poppad2.IDM_HELP :
                              Windows.MessageBox (hwnd, "Help not yet implemented!",
                                   szAppName, Windows.MB_OK + Windows.MB_ICONEXCLAMATION);
                              RETURN 0;

                         | h2d_poppad2.IDM_ABOUT :
                              Windows.MessageBox (hwnd,
                                   "POPPAD2 (c) Charles Petzold, 1996, Translation to XDS Modula-2 (c) Peter Stadler, 1997",
                                   szAppName, Windows.MB_OK + Windows.MB_ICONINFORMATION);
                              RETURN 0;
                 ELSE
                              RETURN 0;
                 END;
               END;
          | Windows.WM_CLOSE :
               IF (Windows.IDYES = AskConfirmation (hwnd)) THEN
                    Windows.DestroyWindow (hwnd);
               END;
               RETURN 0;

          | Windows.WM_QUERYENDSESSION :
               IF (Windows.IDYES = AskConfirmation (hwnd)) THEN
                    RETURN 1;
               ELSE
                    RETURN 0;
               END;
          | Windows.WM_DESTROY :
               Windows.PostQuitMessage (0);
               RETURN 0;
     ELSE
       RETURN Windows.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
     RETURN Windows.DefWindowProc (hwnd, iMsg, wParam, lParam);
END WndProc;

(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
BEGIN
  wc.cbSize        := SIZE(wc);
  wc.style         := Windows.CS_HREDRAW + Windows.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := Windows.MyInstance();
  wc.hIcon         := Windows.LoadIcon (Windows.MyInstance(), szAppName);
  wc.hCursor       := Windows.LoadCursor (NIL, Windows.IDC_ARROW);
  wc.hbrBackground := SYSTEM.CAST(Windows.HBRUSH, Windows.GetStockObject (Windows.WHITE_BRUSH));
  wc.lpszMenuName  := SYSTEM.ADR(szAppName);
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := Windows.LoadIcon (NIL,Windows.IDI_APPLICATION);
  RETURN Windows.RegisterClassEx(wc)#0;
END InitApplication;

(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := Windows.CreateWindow (
                       szAppName,                      (* window class name            *)
                       szAppTitle,                     (* window caption               *)
                       Windows.WS_OVERLAPPEDWINDOW,          (* window style                 *)
                       Windows.GetSystemMetrics (Windows.SM_CXSCREEN) / 4,
                       Windows.GetSystemMetrics (Windows.SM_CYSCREEN) / 4,
                       Windows.GetSystemMetrics (Windows.SM_CXSCREEN) / 2,
                       Windows.GetSystemMetrics (Windows.SM_CYSCREEN) / 2,
                       NIL,                            (* parent window handle         *)
                       NIL,                            (* window menu handle           *)
                       wc.hInstance,                   (* program instance handle      *)
                       NIL);                           (* creation parameters          *)

  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  Windows.ShowWindow (hwnd, Windows.SW_SHOWDEFAULT);
  Windows.UpdateWindow (hwnd);
  hAccel := Windows.LoadAccelerators (wc.hInstance, szAppName);
  RETURN TRUE;
END InitMainWindow;


BEGIN
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (Windows.GetMessage(msg,NIL,0,0)) DO
      IF (Windows.TranslateAccelerator (hwnd, hAccel, msg)=FALSE) THEN
        Windows.TranslateMessage(msg);
        Windows.DispatchMessage(msg);
      END;
    END;
  END;
END PopPad2.
