<* +M2EXTENSIONS *>
MODULE About1;
(*--------------------------------------------
   ABOUT1.C        --- About Box Demo Program No. 3
                   (c) Charles Petzold, 1996
   About1.MOD      --- Translation to XDS Modula-2
                   (c) Peter Stadler,   1997
  ------------------------------------------*)




IMPORT h2d_about1;
IMPORT Windows;

IMPORT SYSTEM;



CONST szAppName = "About1";

VAR
  msg        :  Windows.MSG;
  hwnd       :  Windows.HWND;
  wc         :  Windows.WNDCLASSEX;
  hInstance         : Windows.HINSTANCE;











(*++++*****************************************************************)
PROCEDURE [Windows.CALLBACK]  AboutDlgProc (hDlg        : Windows.HWND;
(**********************************************************************)
                                            iMsg        : Windows.UINT;
                                            wParam      : Windows.WPARAM;
                                            lParam      : Windows.LPARAM) : Windows.BOOL;
BEGIN
     CASE (iMsg) OF
          | Windows.WM_INITDIALOG :
               RETURN TRUE;

          | Windows.WM_COMMAND :
               CASE (Windows.LOWORD (wParam))                                                                                                                                                          OF
                            | Windows.IDOK :
                         Windows.EndDialog (hDlg, 0);
                                     RETURN TRUE;
                            | Windows.IDCANCEL :
                         Windows.EndDialog (hDlg, 0);
                                     RETURN TRUE;
               ELSE
                 RETURN FALSE;
	       END;	
     ELSE
         RETURN FALSE;
     END;
	
END AboutDlgProc;


    

(*++++*****************************************************************)
PROCEDURE [Windows.CALLBACK]  WndProc (hwnd        : Windows.HWND;
(**********************************************************************)
                                       iMsg        : Windows.UINT;
                                       wParam      : Windows.WPARAM;
                                       lParam      : Windows.LPARAM) : Windows.LRESULT;
BEGIN
     CASE (iMsg) OF
          | Windows.WM_CREATE :
(*
               hInstance := ((PCREATESTRUCT) lParam)^.hInstance;
*)
               hInstance := Windows.MyInstance();
               RETURN 0;


          | Windows.WM_COMMAND :
               CASE (Windows.LOWORD (wParam))                                                                                                                                                          OF
                    | h2d_about1.IDM_ABOUT :
                         Windows.DialogBox (hInstance, "AboutBox", hwnd, AboutDlgProc);
                         RETURN 0;
               ELSE
                    RETURN 0;
               END;

          | Windows.WM_DESTROY :
               Windows.PostQuitMessage (0);
               RETURN 0;
     ELSE
         RETURN Windows.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
END WndProc;


(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
VAR rc : CARDINAL;
BEGIN
  wc.cbSize        := SIZE(wc);
  wc.style         := Windows.CS_HREDRAW + Windows.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := Windows.MyInstance();
  wc.hIcon         := Windows.LoadIcon (wc.hInstance,szAppName);
  wc.hCursor       := Windows.LoadCursor (NIL, Windows.IDC_ARROW);
  wc.hbrBackground := SYSTEM.CAST(Windows.HBRUSH,Windows.GetStockObject(Windows.WHITE_BRUSH));
  wc.lpszMenuName  := SYSTEM.ADR(szAppName);
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := Windows.LoadIcon (wc.hInstance,szAppName);

  rc := Windows.RegisterClassEx(wc);
  RETURN rc#0;
END InitApplication;

(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
   hwnd := Windows.CreateWindow (szAppName, "About Box Demo Program #1: Translation to XDS Modula-2",
                          Windows.WS_OVERLAPPEDWINDOW,
                          Windows.CW_USEDEFAULT,
                          Windows.CW_USEDEFAULT,
                          Windows.CW_USEDEFAULT,
                          Windows.CW_USEDEFAULT,
                          NIL,
                          NIL,
                          Windows.MyInstance(),
                          NIL);
  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  Windows.ShowWindow (hwnd, Windows.SW_SHOWDEFAULT);
  Windows.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;


BEGIN
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (Windows.GetMessage(msg,NIL,0,0)) DO
      Windows.TranslateMessage(msg);
      Windows.DispatchMessage(msg);
    END;
  END;
END About1.
