<* +M2EXTENSIONS *>
MODULE About3;
(*------------------------------------------
   ABOUT3.C        --- About Box Demo Program No. 3
                   (c) Charles Petzold, 1996
   About3.mod      --- Translation to XDS Modula-2
                   (c) Peter Stadler,   1997
  ------------------------------------------*)




IMPORT h2d_about3;
IMPORT Windows;

IMPORT SYSTEM;



CONST szAppName = "About3";
VAR
  msg        :  Windows.MSG;
  hwnd       :  Windows.HWND;
  wc         :  Windows.WNDCLASSEX;
  hInstance  :  Windows.HINSTANCE;


(*++++*****************************************************************)
PROCEDURE [Windows.CALLBACK]  AboutDlgProc (hDlg        : Windows.HWND;
(**********************************************************************)
                                            iMsg        : Windows.UINT;
                                            wParam      : Windows.WPARAM;
                                            lParam      : Windows.LPARAM) : Windows.BOOL;
BEGIN
     CASE (iMsg) OF
          | Windows.WM_INITDIALOG :
               RETURN TRUE;

          | Windows.WM_COMMAND :
               CASE (Windows.LOWORD (wParam))                                                                                                                                                          OF
                    | Windows.IDOK :
                         Windows.EndDialog (hDlg, 0);
                         RETURN TRUE;
               ELSE
                         RETURN FALSE;

               END;
     ELSE
               RETURN FALSE;
     END;
END AboutDlgProc;



    

    

(*++++*****************************************************************)
PROCEDURE [Windows.CALLBACK]  WndProc (hwnd        : Windows.HWND;
(**********************************************************************)
                                       iMsg        : Windows.UINT;
                                       wParam      : Windows.WPARAM;
                                       lParam      : Windows.LPARAM) : Windows.LRESULT;
BEGIN
     CASE (iMsg) OF
          | Windows.WM_CREATE :
(*
               hInstance := ((PCREATESTRUCT) lParam)^.hInstance;
*)
               hInstance := Windows.MyInstance();
               RETURN 0;

          | Windows.WM_COMMAND :
               CASE (Windows.LOWORD (wParam))                                                                                                                                                          OF
                    | h2d_about3.IDM_ABOUT :
                         Windows.DialogBox (hInstance, "AboutBox", hwnd,
                                    AboutDlgProc);
                         RETURN 0;
               ELSE
                         RETURN 0;
               END;

          | Windows.WM_DESTROY :
               Windows.PostQuitMessage (0);
               RETURN 0;
     ELSE
              RETURN Windows.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
END WndProc;




    

    





    

    

(*++++*****************************************************************)
PROCEDURE [Windows.CALLBACK]  EllipPushwndProc (hwnd        : Windows.HWND;
(**********************************************************************)
                                                iMsg        : Windows.UINT;
                                                wParam      : Windows.WPARAM;
                                                lParam      : Windows.LPARAM) : Windows.LRESULT;
VAR
  szText  :  ARRAY[0..39] OF CHAR;
  hBrush  :  Windows.HBRUSH;
  hdc     :  Windows.HDC;
  ps      :  Windows.PAINTSTRUCT;
  rect    :  Windows.RECT;
BEGIN
     CASE (iMsg) OF
          | Windows.WM_PAINT :
               Windows.GetClientRect (hwnd, rect);
               Windows.GetWindowText (hwnd, szText, SIZE (szText));

               hdc := Windows.BeginPaint (hwnd, ps);

               hBrush := Windows.CreateSolidBrush (Windows.GetSysColor (Windows.COLOR_WINDOW));
               hBrush := SYSTEM.CAST(Windows.HBRUSH,Windows.SelectObject (hdc, SYSTEM.CAST(Windows.HGDIOBJ,hBrush)));
               Windows.SetBkColor (hdc, Windows.GetSysColor (Windows.COLOR_WINDOW));
               Windows.SetTextColor (hdc, Windows.GetSysColor (Windows.COLOR_WINDOWTEXT));

               Windows.Ellipse (hdc, rect.left, rect.top, rect.right, rect.bottom);
               Windows.DrawText (hdc, szText, -1, rect,
                              Windows.DT_SINGLELINE + Windows.DT_CENTER + Windows.DT_VCENTER);

               Windows.DeleteObject (Windows.SelectObject (hdc, SYSTEM.CAST(Windows.HGDIOBJ,hBrush)));

               Windows.EndPaint (hwnd, ps);
               RETURN 0;

          | Windows.WM_KEYUP :
               IF (wParam # Windows.VK_SPACE) THEN
                    RETURN 0;
               END;
                                        (* fall through                        *)
          | Windows.WM_LBUTTONUP :
               Windows.SendMessage (Windows.GetParent (hwnd), Windows.WM_COMMAND,
                    Windows.GetWindowLong (hwnd, Windows.GWL_ID), SYSTEM.CAST(Windows.LPARAM,hwnd));
               RETURN 0;
     ELSE
               RETURN Windows.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
END EllipPushwndProc;

(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
VAR rc : CARDINAL;
CONST
  szClassName = 'EllipPush';
BEGIN
  wc.cbSize        := SIZE(wc);
  wc.style         := Windows.CS_HREDRAW + Windows.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := Windows.MyInstance();
  wc.hIcon         := Windows.LoadIcon (wc.hInstance,szAppName);
  wc.hCursor       := Windows.LoadCursor (NIL, Windows.IDC_ARROW);
  wc.hbrBackground := SYSTEM.CAST(Windows.HBRUSH,Windows.GetStockObject(Windows.WHITE_BRUSH));
  wc.lpszMenuName  := SYSTEM.ADR(szAppName);
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := Windows.LoadIcon (wc.hInstance,szAppName);

  rc := Windows.RegisterClassEx(wc);

  wc.cbSize        := SIZE(wc);
  wc.style         := Windows.CS_HREDRAW + Windows.CS_VREDRAW;
  wc.lpfnWndProc   := EllipPushwndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := Windows.MyInstance();
  wc.hIcon         := Windows.LoadIcon (wc.hInstance,szAppName);
  wc.hCursor       := Windows.LoadCursor (NIL, Windows.IDC_ARROW);
  wc.hbrBackground := SYSTEM.CAST(Windows.HBRUSH, SYSTEM.CAST(CARDINAL,Windows.COLOR_BTNFACE)+1);
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szClassName);
  wc.hIconSm       := NIL;
  rc := Windows.RegisterClassEx(wc);
  RETURN rc#0;
END InitApplication;

(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
   hwnd := Windows.CreateWindow (szAppName, "About Box Demo Program #3: Translation to XDS Modula-2",
                          Windows.WS_OVERLAPPEDWINDOW,
                          Windows.CW_USEDEFAULT,
                          Windows.CW_USEDEFAULT,
                          Windows.CW_USEDEFAULT,
                          Windows.CW_USEDEFAULT,
                          NIL,
                          NIL,
                          Windows.MyInstance(),
                          NIL);
  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  Windows.ShowWindow (hwnd, Windows.SW_SHOWDEFAULT);
  Windows.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;


BEGIN
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (Windows.GetMessage(msg,NIL,0,0)) DO
      Windows.TranslateMessage(msg);
      Windows.DispatchMessage(msg);
    END;
  END;
END About3.
