<* +M2EXTENSIONS *>
MODULE Colors2;
(*------------------------------------------------
   COLORS2.C       --- Version using Modeless Dialog Box
                   (c) Charles Petzold, 1996
   Colors2.mod     --- Translation to XDS Modula-2
                   (c) Peter Stadler,   1997
  ------------------------------------------------*)




IMPORT Windows;

IMPORT SYSTEM;



CONST szAppName = "Colors2";

VAR
  msg          :  Windows.MSG;
  hwnd         :  Windows.HWND;
  wc           :  Windows.WNDCLASSEX;
  hDlgModeless :  Windows.HWND;
  iColor       :  ARRAY[0..2] OF INTEGER;

(*++++*****************************************************************)
PROCEDURE MaxInt (a,b : INTEGER) : INTEGER;
(**********************************************************************)
BEGIN
  IF(a>b) THEN
    RETURN a;
  ELSE
    RETURN b;
  END;
END MaxInt;
(*++++*****************************************************************)
PROCEDURE MinInt (a,b : INTEGER) : INTEGER;
(**********************************************************************)
BEGIN
  IF(a>b) THEN
    RETURN b;
  ELSE
    RETURN a;
  END;
END MinInt;



    

    

(*++++*****************************************************************)
PROCEDURE [Windows.CALLBACK]  WndProc (hwnd        : Windows.HWND;
(**********************************************************************)
                                       iMsg        : Windows.UINT;
                                       wParam      : Windows.WPARAM;
                                       lParam      : Windows.LPARAM) : Windows.LRESULT;
BEGIN
     CASE (iMsg) OF
          | Windows.WM_DESTROY :
               Windows.DeleteObject (
                    SYSTEM.CAST(Windows.HGDIOBJ,Windows.SetClassLong (hwnd, Windows.GCL_HBRBACKGROUND,
                         SYSTEM.CAST(Windows.LONG,Windows.GetStockObject (Windows.WHITE_BRUSH)))));

               Windows.PostQuitMessage (0);
               RETURN 0;
     ELSE
        RETURN Windows.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
END WndProc;




    

    

(*++++*****************************************************************)
PROCEDURE [Windows.CALLBACK]  ColorScrDlg (hDlg        : Windows.HWND;
(**********************************************************************)
                                            iMsg        : Windows.UINT;
                                            wParam      : Windows.WPARAM;
                                            lParam      : Windows.LPARAM) : Windows.BOOL;
VAR
  hwndParent   :  Windows.HWND;
  hCtrl        :  Windows.HWND;
  iCtrlID      :  INTEGER;
  iIndex       :  INTEGER;
BEGIN
     CASE (iMsg) OF
          | Windows.WM_INITDIALOG :
               FOR iCtrlID := 10 TO 13-1 DO
                    hCtrl := Windows.GetDlgItem (hDlg, iCtrlID);
                    Windows.SetScrollRange (hCtrl, Windows.SB_CTL, 0, 255, FALSE);
                    Windows.SetScrollPos   (hCtrl, Windows.SB_CTL, 0, FALSE);
               END;
               RETURN TRUE;

          | Windows.WM_VSCROLL :
               hCtrl   := SYSTEM.CAST(Windows.HWND,lParam);
               iCtrlID := Windows.GetWindowLong (hCtrl, Windows.GWL_ID);
               iIndex  := iCtrlID - 10;
               hwndParent := Windows.GetParent (hDlg);

               CASE SYSTEM.CAST(Windows.SB_ENUM,(Windows.LOWORD (wParam)))                                                                                                                                                          OF
                    | Windows.SB_PAGEDOWN :
                         iColor[iIndex] := iColor[iIndex] + 15;        (* fall through         *)
                    | Windows.SB_LINEDOWN :
                         iColor[iIndex] := MinInt (255, iColor[iIndex] + 1);
                    | Windows.SB_PAGEUP :
                         iColor[iIndex] := iColor[iIndex] - 15;        (* fall through         *)
                    | Windows.SB_LINEUP :
                         iColor[iIndex] := MaxInt (0, iColor[iIndex] - 1);
                    | Windows.SB_TOP :
                         iColor[iIndex] := 0;
                    | Windows.SB_BOTTOM :
                         iColor[iIndex] := 255;
                    | Windows.SB_THUMBPOSITION :
                         iColor[iIndex] := Windows.HIWORD (wParam);
                    | Windows.SB_THUMBTRACK :
                         iColor[iIndex] := Windows.HIWORD (wParam);
               ELSE
                         RETURN FALSE;
               END;
               Windows.SetScrollPos  (hCtrl, Windows.SB_CTL,      iColor[iIndex], TRUE);
               Windows.SetDlgItemInt (hDlg,  iCtrlID + 3, iColor[iIndex], FALSE);

               Windows.DeleteObject (
                    (SYSTEM.CAST(Windows.HGDIOBJ,Windows.SetClassLong (hwndParent, Windows.GCL_HBRBACKGROUND,
                         (SYSTEM.CAST(Windows.LONG, Windows.CreateSolidBrush (
                              Windows.RGB (iColor[0], iColor[1], iColor[2]))))))));

               Windows.InvalidateRect (hwndParent, NIL, TRUE);
               RETURN TRUE;
     ELSE
         RETURN FALSE;
     END;
END ColorScrDlg;

(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
VAR rc : CARDINAL;
BEGIN
  wc.cbSize        := SIZE(wc);
  wc.style         := Windows.CS_HREDRAW + Windows.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := Windows.MyInstance();
  wc.hIcon         := Windows.LoadIcon (wc.hInstance,Windows.IDI_APPLICATION);
  wc.hCursor       := Windows.LoadCursor (NIL, Windows.IDC_ARROW);
  wc.hbrBackground := Windows.CreateSolidBrush(00000h);
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := Windows.LoadIcon (wc.hInstance,Windows.IDI_APPLICATION);

  rc := Windows.RegisterClassEx(wc);
  RETURN rc#0;
END InitApplication;

(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
   hwnd := Windows.CreateWindow (szAppName, "Colors Scroll:Translation to XDS Modula-2",
                          Windows.WS_OVERLAPPEDWINDOW + Windows.WS_CLIPCHILDREN,
                          Windows.CW_USEDEFAULT,
                          Windows.CW_USEDEFAULT,
                          Windows.CW_USEDEFAULT,
                          Windows.CW_USEDEFAULT,
                          NIL,
                          NIL,
                          Windows.MyInstance(),
                          NIL);
  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  Windows.ShowWindow (hwnd, Windows.SW_SHOWDEFAULT);
  Windows.UpdateWindow (hwnd);
  hDlgModeless := Windows.CreateDialog (Windows.MyInstance(), "ColorScrDlg", hwnd, ColorScrDlg);
  RETURN TRUE;
END InitMainWindow;


BEGIN
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (Windows.GetMessage(msg,NIL,0,0)) DO
      IF (hDlgModeless = NIL) OR (Windows.IsDialogMessage (hDlgModeless, msg)=FALSE) THEN
        Windows.TranslateMessage(msg);
        Windows.DispatchMessage(msg);
      END;
    END;
  END;
END Colors2.
