<* +M2EXTENSIONS *>
MODULE HexCalc;
(*----------------------------------------
   HEXCALC.C       --- Hexadecimal Calculator
                   (c) Charles Petzold, 1996
   HexCalc.mod     --- Translation to XDS Modula-2
                   (c) Peter Stadler,   1997
  ----------------------------------------*)


IMPORT Windows;


IMPORT CharClass;
IMPORT FormatString;
IMPORT SYSTEM;





CONST
  szAppName  =  "HexCalc: Translated To XDS Modula-2";
VAR
   hwnd            :  Windows.HWND;
   msg             :  Windows.MSG;
   wc              :  Windows.WNDCLASSEX;
   bNewNumber      :  BOOLEAN;
   iOperation      :  CARDINAL;
   iNumber         :  Windows.UINT;
   iFirstNum       :  Windows.UINT;
   hButton         :  Windows.HWND;
(*++++*****************************************************************)
PROCEDURE ShowNumber (hwnd    : Windows.HWND;
                      iNumber : Windows.UINT);
(**********************************************************************)
VAR
  szBuffer  :  ARRAY[0..19] OF CHAR;
BEGIN
    FormatString.CardToHexStr(iNumber, szBuffer);
    Windows.SetDlgItemText (hwnd, Windows.VK_ESCAPE,szBuffer);
END ShowNumber;

(*++++*****************************************************************)
PROCEDURE CalcIt (iFirstNum :  Windows.UINT;
                  iOperation:  CARDINAL;
                  iNum      :  Windows.UINT) :  Windows.DWORD;
(**********************************************************************)
BEGIN
     CASE (iOperation) OF
          | ORD('=') : RETURN iNum;
          | ORD('+') : RETURN iFirstNum +    iNum;
          | ORD('-') : RETURN iFirstNum -    iNum;
          | ORD('*') : RETURN iFirstNum *    iNum;
          | ORD('&') : RETURN iFirstNum - iNum;
          | ORD('|') : RETURN iFirstNum +  iNum;
          | ORD('^') : RETURN iFirstNum *iNum;
	  (*
          | ORD('<') : RETURN SYSTEM.SHIFT(VAL(INTEGER,iFirstNum),VAL(INTEGER,iNum));
          | ORD('>') : RETURN SYSTEM.SHIFT(iFirstNum,-VAL(INTEGER,iNum));
	  *)
          | ORD('/') : IF(iNum=0) THEN
                    RETURN MAX(CARDINAL);
                  ELSE
                    RETURN iFirstNum / iNum;
                  END;
          | ORD('%') : IF(iNum=0) THEN
                    RETURN MAX(CARDINAL);;
                  ELSE
                    RETURN iFirstNum REM iNum;
                  END;
     ELSE
          RETURN 0;
     END;
END CalcIt;



    

    

(*++++*****************************************************************)
PROCEDURE [Windows.CALLBACK]  WndProc (hwnd        : Windows.HWND;
(**********************************************************************)
                                       iMsg        : Windows.UINT;
                                       wParam      : Windows.WPARAM;
                                       lParam      : Windows.LPARAM) : Windows.LRESULT;
VAR
  c : Windows.UINT;

BEGIN

     CASE (iMsg) OF
          | Windows.WM_KEYDOWN :                   (* left arrow --> backspace *)
               IF (wParam = Windows.VK_LEFT) THEN
                    wParam := Windows.VK_BACK;
               END;
                                             (* fall through           *)
          | Windows.WM_CHAR :
               wParam := ORD(Windows.CharUpper1(CHR(wParam)));
               IF (wParam = Windows.VK_RETURN) THEN
                    wParam := ORD('=');
               END;

               hButton := Windows.GetDlgItem (hwnd, wParam);

               IF (hButton # NIL) THEN
                    Windows.SendMessage (hButton, Windows.BM_SETSTATE, 1, 0);
                    Windows.SendMessage (hButton, Windows.BM_SETSTATE, 0, 0);
               ELSE
                    Windows.MessageBeep (SYSTEM.CAST(Windows.MB_SET,0));
               END;
                                             (* fall through           *)
          | Windows.WM_COMMAND :
               Windows.SetFocus (hwnd);

               IF (Windows.LOWORD (wParam) = Windows.VK_BACK) THEN    (* backspace    *)
                    iNumber := iNumber/16;
                    ShowNumber (hwnd, iNumber);

               ELSIF (Windows.LOWORD (wParam) = Windows.VK_ESCAPE) THEN (* escape       *)
                    iNumber := 0;
                    ShowNumber (hwnd, iNumber);

               ELSIF (FormatString.IsHexadecimalDigit (Windows.LOWORD (wParam))) THEN  (* hex digit    *)
                    IF (bNewNumber) THEN
                         iFirstNum := iNumber;
                         iNumber := 0;
                    END;
                    bNewNumber := FALSE;

                    IF (iNumber <= (MAX(CARDINAL)/(2*2*2*2))) THEN
                         IF(CharClass.IsNumeric(CHR(wParam))) THEN
                            c := ORD('0');
                         ELSE
                            c := ORD('A')-10;
                         END;
                         iNumber := 16 * iNumber + wParam - c;
                         ShowNumber (hwnd, iNumber);
                    ELSE
                         Windows.MessageBeep (SYSTEM.CAST(Windows.MB_SET,0));
                    END;
               ELSE                                    (* operation    *)
                    IF (bNewNumber=FALSE) THEN
                         iNumber := CalcIt(iFirstNum, iOperation, iNumber);
                         ShowNumber (hwnd,iNumber);
                    END;
                    bNewNumber := TRUE;
                    iOperation := Windows.LOWORD (wParam);
               END;
               RETURN 0;

          | Windows.WM_DESTROY :
               Windows.PostQuitMessage (0);
               RETURN 0;
     ELSE
               RETURN Windows.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
     RETURN Windows.DefWindowProc (hwnd, iMsg, wParam, lParam);
END WndProc;

(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
VAR rc : CARDINAL;
BEGIN
  wc.cbSize        := SIZE(wc);
  wc.style         := Windows.CS_HREDRAW + Windows.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := Windows.DLGWINDOWEXTRA;
  wc.hInstance     := Windows.MyInstance();
  wc.hIcon         := Windows.LoadIcon (wc.hInstance,szAppName);
  wc.hCursor       := Windows.LoadCursor (NIL, Windows.IDC_ARROW);
  wc.hbrBackground := SYSTEM.CAST(Windows.HBRUSH, SYSTEM.CAST(CARDINAL,Windows.COLOR_WINDOW)+1);
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := Windows.LoadIcon (wc.hInstance,szAppName);
  rc := Windows.RegisterClassEx(wc);
  RETURN rc#0;
END InitApplication;

(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := Windows.CreateDialog (Windows.MyInstance(),
                          szAppName,
                          SYSTEM.CAST(Windows.HWND,0),
                          SYSTEM.CAST(Windows.DLGPROC, NIL));


  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  Windows.ShowWindow (hwnd, Windows.SW_SHOWDEFAULT);
  Windows.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;


BEGIN
  bNewNumber := TRUE;
  iOperation := ORD('=');
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (Windows.GetMessage(msg,NIL,0,0)) DO
      Windows.TranslateMessage(msg);
      Windows.DispatchMessage(msg);
    END;
  END;
END HexCalc.
