<* +M2EXTENSIONS *>
IMPLEMENTATION MODULE PopFind;
(*--------------------------------------------------------
   POPFIND.C -- Popup Editor Search and Replace Functions
  --------------------------------------------------------*)


IMPORT Windows;


IMPORT SYSTEM;
IMPORT Strings;
IMPORT Storage;
CONST
  MAX_STRING_LEN = 256;
TYPE
  TEXT = ARRAY[0..MAX_STRING_LEN] OF CHAR;
  PTEXT = POINTER TO TEXT;
VAR
  szFindText : TEXT;
  szReplText : TEXT;
VAR
  fr1 : Windows.FINDREPLACE;       (* must be static for modeless dialog!!!                *)
  fr2 : Windows.FINDREPLACE;       (* must be static for modeless dialog!!!                *)

(*++++****************************************************************)
PROCEDURE FindDlg (hwnd :  Windows.HWND)  :  Windows.HWND;
(*********************************************************************)
BEGIN
     fr1.lStructSize      := SIZE (Windows.FINDREPLACE);
     fr1.hwndOwner        := hwnd;
     fr1.hInstance        := NIL;
     fr1.Flags            := Windows.FR_HIDEUPDOWN + Windows.FR_HIDEMATCHCASE + Windows.FR_HIDEWHOLEWORD;
     fr1.lpstrFindWhat    := SYSTEM.ADR(szFindText);
     fr1.lpstrReplaceWith := NIL;
     fr1.wFindWhatLen     := SIZE (szFindText);
     fr1.wReplaceWithLen  := 0;
     fr1.lCustData        := 0;
     fr1.lpfnHook         := NIL;
     fr1.lpTemplateName   := NIL;

     RETURN Windows.FindText (fr1);
END FindDlg;

(*++++****************************************************************)
PROCEDURE ReplaceDlg (hwnd :  Windows.HWND)  :  Windows.HWND;
(*********************************************************************)
BEGIN
     fr2.lStructSize      := SIZE (Windows.FINDREPLACE);
     fr2.hwndOwner        := hwnd;
     fr2.hInstance        := NIL;
     fr2.Flags            := Windows.FR_HIDEUPDOWN + Windows.FR_HIDEMATCHCASE + Windows.FR_HIDEWHOLEWORD;
     fr2.lpstrFindWhat    := SYSTEM.ADR(szFindText);
     fr2.lpstrReplaceWith := SYSTEM.ADR(szReplText);
     fr2.wFindWhatLen     := SIZE (szFindText);
     fr2.wReplaceWithLen  := SIZE (szReplText);
     fr2.lCustData        := 0;
     fr2.lpfnHook         := NIL;
     fr2.lpTemplateName   := NIL;

     RETURN Windows.ReplaceText (fr2);
END ReplaceDlg;

(*++++****************************************************************)
PROCEDURE FindText (hwndEdit       :  Windows.HWND;
                    piSearchOffset :  INTEGER;
                    pfr            :  Windows.PFINDREPLACE) : Windows.BOOL;
(*********************************************************************)
VAR
  iLength   :  INTEGER;
  iPos      :  INTEGER;
  pstrDoc   :  PTEXT;
  pstrPos   :  CARDINAL;
  text,text1      :  TEXT;
  found     :  BOOLEAN;
BEGIN

               (* Read in the edit document                                         *)
     iLength := Windows.GetWindowTextLength (hwndEdit);
     Storage.ALLOCATE(pstrDoc,iLength+1);
     IF (pstrDoc=NIL) THEN
          RETURN FALSE;
     END;
     Windows.GetWindowText (hwndEdit, pstrDoc^, iLength + 1);

               (* Search the document for the find string                           *)
     
     text1 := SYSTEM.CAST(TEXT,pfr^.lpstrFindWhat^);
     Strings.FindNext(text1,pstrDoc^,piSearchOffset,found,pstrPos);
     Storage.DEALLOCATE(pstrDoc,iLength+1);

               (* Return an error code if the string cannot be found                *)

     IF (pstrPos = 0) THEN
          RETURN FALSE;
     END;

               (* Find the position in the document and the new start offset        *)

     iPos := pstrPos;
     Strings.Replace(text,0,text1);
     piSearchOffset := iPos + VAL(INTEGER,LENGTH(text));

               (* Select the found text                                             *)

     Windows.SendMessage (hwndEdit, Windows.EM_SETSEL, iPos, piSearchOffset);
     Windows.SendMessage (hwndEdit, Windows.EM_SCROLLCARET, 0, 0);

     RETURN TRUE;
END FindText;

(*++++****************************************************************)
PROCEDURE NextText (hwndEdit       :  Windows.HWND;
                    piSearchOffset :  INTEGER) : Windows.BOOL;
(*********************************************************************)
VAR
  fr :  Windows.FINDREPLACE;
BEGIN
     fr.lpstrFindWhat := SYSTEM.ADR(szFindText);

     RETURN FindText (hwndEdit, piSearchOffset, SYSTEM.ADR(fr));
END NextText;

(*++++****************************************************************)
PROCEDURE ReplaceText (hwndEdit       :  Windows.HWND;
                       piSearchOffset :  INTEGER;
                       pfr            :  Windows.PFINDREPLACE) : Windows.BOOL;
(*********************************************************************)
               (* Find the text                                                     *)
BEGIN
     IF (FindText (hwndEdit, piSearchOffset, pfr)=FALSE) THEN
          RETURN FALSE;
     END;

               (* Replace it                                                        *)

     Windows.SendMessage (hwndEdit, Windows.EM_REPLACESEL, 0, SYSTEM.CAST(Windows.LPARAM, pfr^.lpstrReplaceWith));

     RETURN TRUE;
END ReplaceText;

(*++++****************************************************************)
PROCEDURE ValidFind () : Windows.BOOL;
(*********************************************************************)
BEGIN
     RETURN szFindText[0] #'';
END ValidFind;
BEGIN
END PopFind.
