<* +M2EXTENSIONS *>
MODULE CtlMacro;




(*--------------------------------------------
   CTLMACRO.C      --- Control Macro Helper Utility
                   (c) Paul Yao,      1996
   CtlMacro.mod    --- Translation to XDS Modula-2
                   (c) Peter Stadler, 1998
  --------------------------------------------*)

IMPORT TreeView;
IMPORT resource;
IMPORT Notify;

IMPORT Windows;
IMPORT WinUser;
IMPORT CommCtrl;

IMPORT SYSTEM;


VAR COL_WHITE  : INTEGER;

VAR
  hInst   :  Windows.HINSTANCE;
VAR 
  bFirstSelection : BOOLEAN; (* static *)




    

    

(*++++*****************************************************************)
PROCEDURE [Windows.CALLBACK] DlgProc (hwnd        : Windows.HWND;
(**********************************************************************)
                             mMsg        : Windows.UINT;
                             wParam      : Windows.WPARAM;
                             lParam      : Windows.LPARAM) : BOOLEAN;
(*******************************************************************-          *)
VAR
  hicon        :  Windows.HICON;
  himl         :  CommCtrl.HIMAGELIST;
  hItem        :  CommCtrl.HTREEITEM;
  hwndEdit     :  Windows.HWND;
  hwndCopy     :  Windows.HWND;
  hwndCtrl     :  Windows.HWND;
  hwndButton   :  Windows.HWND;
  wNotifyCode  :  Windows.WORD;
  cb           :  INTEGER;
  idCtrl       :  INTEGER;
  pnmtv        :  CommCtrl.PNM_TREEVIEW;
  pnmh         :  WinUser.PNMHDR;
  lpstr        :  Windows.PSTR;
  ok           :  BOOLEAN;

BEGIN
     CASE (mMsg) OF
          | Windows.WM_INITDIALOG :
               (* Add listview root items                                      *)
               hwndCtrl := Windows.GetDlgItem (hwnd, resource.IDC_MESSAGES);
               ok := TreeView.tv_BuildRootFolder (hwndCtrl);

               (* Select first item                                            *)
               hItem := CommCtrl.TreeView_GetFirstVisible (hwndCtrl);
               CommCtrl.TreeView_SelectItem (hwndCtrl, hItem);

               (* Create image list & connect to list view                     *)
	       lpstr := Windows.MAKEINTRESOURCE (resource.IDR_TVITEMS);
               himl :=
               CommCtrl.ImageList_LoadBitmap (hInst,
                                     lpstr,
                                     16,
                                     0,
                                     COL_WHITE);

               CommCtrl.TreeView_SetImageList (hwndCtrl, himl, CommCtrl.TVSIL_NORMAL);

               (* Disable [Copy] button when no macro is present               *)
               hwndCtrl := Windows.GetDlgItem (hwnd, resource.IDC_COPY);
               Windows.EnableWindow (hwndCtrl, FALSE);

               (* Install icon                                                 *)
	       lpstr := Windows.MAKEINTRESOURCE (resource.IDI_APP);
               hicon := Windows.LoadIcon (hInst,lpstr);
               Windows.SendMessage (hwnd, Windows.WM_SETICON, SYSTEM.CAST(Windows.WPARAM,SYSTEM.CAST(BOOLEAN,TRUE)),
                            SYSTEM.CAST(Windows.LPARAM, hicon));

               RETURN TRUE;

          | Windows.WM_COMMAND :
               CASE (Windows.LOWORD (wParam)) OF
                    (* Copy macro data to clipboard                            *)
                    | resource.IDC_COPY :
                         hwndEdit := Windows.GetDlgItem (hwnd, resource.IDC_MACROS);
			 (*
                         Windowsx.Edit_SetSel (hwndEdit, 0, -1);
			 *)
                         Windows.SendMessage (hwndEdit, Windows.WM_COPY, 0, 0h);

                    (* Close dialog                                            *)
                    | Windows.IDOK :
                         Windows.EndDialog (hwnd, 0);

                    (* Enable & disable [Copy] button when edit changes        *)
                    | resource.IDC_MACROS :
                         wNotifyCode := Windows.HIWORD (wParam);
                         IF (wNotifyCode = Windows.EN_CHANGE) THEN
                              hwndEdit := SYSTEM.CAST(Windows.HWND,lParam);
                              hwndCopy := Windows.GetDlgItem (hwnd, resource.IDC_COPY);
                              cb := WINX.Edit_GetTextLength (hwndEdit);
                              Windows.EnableWindow (hwndCopy, SYSTEM.CAST(BOOLEAN,cb));
                         END;

               ELSE
                 RETURN TRUE;
               END;
               RETURN TRUE;

          | Windows.WM_NOTIFY :
               idCtrl := SYSTEM.CAST(INTEGER,wParam);
               pnmh := SYSTEM.CAST(WinUser.PNMHDR, lParam);

               (* Expand tree as required                                      *)
               IF (pnmh^.code = CommCtrl.TVN_ITEMEXPANDING) THEN
                    pnmtv := SYSTEM.CAST(CommCtrl.PNM_TREEVIEW,lParam);
                    TreeView.tv_ExpandChild (pnmh^.hwndFrom, pnmtv^.itemNew.lParam);
               END;
               (* Respond to selection of items                                *)
               IF (pnmh^.code = CommCtrl.TVN_SELCHANGED) THEN
                    pnmtv := SYSTEM.CAST(CommCtrl.PNM_TREEVIEW, lParam);
                    hwndEdit := Windows.GetDlgItem (hwnd, resource.IDC_MACROS);

                    (* Ignore first selection request                          *)
                    IF (bFirstSelection) THEN
                         bFirstSelection := FALSE;
                         RETURN TRUE;
                    END;

                    (* Fetch macro for leaf nodes                              *)
                    IF (TreeView.tv_FetchMacro (pnmtv^.itemNew.lParam, hwndEdit)) THEN
                         WINX.Edit_SetSel (hwndEdit, 0, -1);
                    ELSE
                         (* Expand tree for folder nodes                       *)
                         CommCtrl.TreeView_Expand (pnmh^.hwndFrom,
                                          pnmtv^.itemNew.hItem,
                                          CommCtrl.TVE_EXPAND);
                         WINX.Edit_SetText (hwndEdit, "");
                    END;
                    RETURN TRUE;
               END;

               (* Double-click means copy macro to clipboard                   *)
               IF (pnmh^.code = CommCtrl.NM_DBLCLK) THEN
                    hwndEdit   := Windows.GetDlgItem (hwnd, resource.IDC_MACROS);
                    hwndButton := Windows.GetDlgItem (hwnd, resource.IDC_COPY);
                    IF (WINX.Edit_GetTextLength (hwndEdit) > 0) THEN
                         CommCtrl.FORWARD_WM_COMMAND (hwnd, resource.IDC_COPY,
                                             hwndButton, Windows.BN_CLICKED,
                                             Windows.SendMessage);
                    END;
               END;

               RETURN TRUE;

          ELSE
               RETURN FALSE;
          END;
END DlgProc;

(*******************************************************************-          *)
VAR
   lpstr        :  Windows.PSTR;
BEGIN
     bFirstSelection := TRUE;
     COL_WHITE := (Windows.RGB (255, 255, 255));
     hInst := Windows.MyInstance();

     (* Load common control library                                            *)
     CommCtrl.InitCommonControls ();


     lpstr :=   Windows.MAKEINTRESOURCE (resource.IDD_DIALOG);
     Windows.DialogBox (hInst,lpstr, NIL, SYSTEM.CAST(Windows.DLGPROC,DlgProc));

END CtlMacro.
