IMPLEMENTATION MODULE Notify;
(*---------------------------------------
   NOTIFY.C        --- Gadgets for a frame window.
                   (c) Paul Yao,      1996
   Notify.mod      --- Translation to XDS Modula-2
                   (c) Peter Stadler, 1998
  ---------------------------------------*)



IMPORT Windows;

IMPORT SYSTEM;
IMPORT CommCtrl;
IMPORT comcthlp;
(*-------------------------------------------------------------------*)
(* QueryNotifyText: Convert notification codes into text.*)
(*-------------------------------------------------------------------*)
(*++++*****************************************************************)
PROCEDURE QueryNotifyText (nNotifyCode : CARDINAL; pName : Windows.PSTR) : BOOLEAN;
(**********************************************************************)

VAR
  bFound    :  BOOLEAN;
  iNotify   :  INTEGER;
BEGIN
  bFound := FALSE;
     FOR iNotify := 0 TO  NOTIFY_COUNT-1 DO
          IF (cnLookupTable[iNotify].nCode = VAL(INTEGER,nNotifyCode)) THEN;
               pName := cnLookupTable[iNotify].pName;
               RETURN TRUE;
          END;
     END;
     (* Unknown notification code.*)
     pName := SYSTEM.ADR("** Unknown **");
     RETURN FALSE;
END QueryNotifyText;
BEGIN


     cnLookupTable := cnLookupTableArray 
  {
    {CommCtrl.NM_OUTOFMEMORY,       SYSTEM.ADR("NM_OUTOFMEMORY")},
    {CommCtrl.NM_CLICK,             SYSTEM.ADR("NM_CLICK")},
    {CommCtrl.NM_DBLCLK,            SYSTEM.ADR("NM_DBLCLK")},
    {CommCtrl.NM_RETURN,            SYSTEM.ADR("NM_RETURN")},
    {CommCtrl.NM_RCLICK,            SYSTEM.ADR("NM_RCLICK")},
    {CommCtrl.NM_RDBLCLK,           SYSTEM.ADR("NM_RDBLCLK")},
    {CommCtrl.NM_SETFOCUS,          SYSTEM.ADR("NM_SETFOCUS")},
    {CommCtrl.NM_KILLFOCUS,         SYSTEM.ADR("NM_KILLFOCUS")},
    {CommCtrl.LVN_ITEMCHANGING,     SYSTEM.ADR("LVN_ITEMCHANGING")},
    {CommCtrl.LVN_ITEMCHANGED,      SYSTEM.ADR("LVN_ITEMCHANGED")},
    {CommCtrl.LVN_INSERTITEM,       SYSTEM.ADR("LVN_INSERTITEM")},
    {CommCtrl.LVN_DELETEITEM,       SYSTEM.ADR("LVN_DELETEITEM")},
    {CommCtrl.LVN_DELETEALLITEMS,   SYSTEM.ADR("LVN_DELETEALLITEMS")},
    {CommCtrl.LVN_BEGINLABELEDITA,  SYSTEM.ADR("LVN_BEGINLABELEDITA")},
    {CommCtrl.LVN_BEGINLABELEDITW,  SYSTEM.ADR("LVN_BEGINLABELEDITW")},
    {CommCtrl.LVN_ENDLABELEDITA,    SYSTEM.ADR("LVN_ENDLABELEDITA")},
    {CommCtrl.LVN_ENDLABELEDITW,    SYSTEM.ADR("LVN_ENDLABELEDITW")},
    {CommCtrl.LVN_COLUMNCLICK,      SYSTEM.ADR("LVN_COLUMNCLICK")},
    {CommCtrl.LVN_BEGINDRAG,        SYSTEM.ADR("LVN_BEGINDRAG")},
    {CommCtrl.LVN_BEGINRDRAG,       SYSTEM.ADR("LVN_BEGINRDRAG")},
    {CommCtrl.LVN_GETDISPINFOA,     SYSTEM.ADR("LVN_GETDISPINFOA")},
    {CommCtrl.LVN_GETDISPINFOW,     SYSTEM.ADR("LVN_GETDISPINFOW")},
    {CommCtrl.LVN_SETDISPINFOA,     SYSTEM.ADR("LVN_SETDISPINFOA")},
    {CommCtrl.LVN_SETDISPINFOW,     SYSTEM.ADR("LVN_SETDISPINFOW")},
    {CommCtrl.LVN_KEYDOWN,          SYSTEM.ADR("LVN_KEYDOWN")},
    {CommCtrl.HDN_ITEMCHANGINGA,    SYSTEM.ADR("HDN_ITEMCHANGINGA")},
    {CommCtrl.HDN_ITEMCHANGINGW,    SYSTEM.ADR("HDN_ITEMCHANGINGW")},
    {CommCtrl.HDN_ITEMCHANGEDA,     SYSTEM.ADR("HDN_ITEMCHANGEDA")},
    {CommCtrl.HDN_ITEMCHANGEDW,     SYSTEM.ADR("HDN_ITEMCHANGEDW")},
    {CommCtrl.HDN_ITEMCLICKA,       SYSTEM.ADR("HDN_ITEMCLICKA")},
    {CommCtrl.HDN_ITEMCLICKW,       SYSTEM.ADR("HDN_ITEMCLICKW")},
    {CommCtrl.HDN_ITEMDBLCLICKA,    SYSTEM.ADR("HDN_ITEMDBLCLICKA")},
    {CommCtrl.HDN_ITEMDBLCLICKW,    SYSTEM.ADR("HDN_ITEMDBLCLICKW")},
    {CommCtrl.HDN_DIVIDERDBLCLICKA, SYSTEM.ADR("HDN_DIVIDERDBLCLICKA")},
    {CommCtrl.HDN_DIVIDERDBLCLICKW, SYSTEM.ADR("HDN_DIVIDERDBLCLICKW")},
    {CommCtrl.HDN_BEGINTRACKA,      SYSTEM.ADR("HDN_BEGINTRACKA")},
    {CommCtrl.HDN_BEGINTRACKW,      SYSTEM.ADR("HDN_BEGINTRACKW")},
    {CommCtrl.HDN_ENDTRACKA,        SYSTEM.ADR("HDN_ENDTRACKA")},
    {CommCtrl.HDN_ENDTRACKW,        SYSTEM.ADR("HDN_ENDTRACKW")},
    {CommCtrl.HDN_TRACKA,           SYSTEM.ADR("HDN_TRACKA")},
    {CommCtrl.HDN_TRACKW,           SYSTEM.ADR("HDN_TRACKW")},
    {CommCtrl.TVN_SELCHANGINGA,     SYSTEM.ADR("TVN_SELCHANGINGA")},
    {CommCtrl.TVN_SELCHANGINGW,     SYSTEM.ADR("TVN_SELCHANGINGW")},
    {CommCtrl.TVN_SELCHANGEDA,      SYSTEM.ADR("TVN_SELCHANGEDA")},
    {CommCtrl.TVN_SELCHANGEDW,      SYSTEM.ADR("TVN_SELCHANGEDW")},
    {CommCtrl.TVN_GETDISPINFOA,     SYSTEM.ADR("TVN_GETDISPINFOA")},
    {CommCtrl.TVN_GETDISPINFOW,     SYSTEM.ADR("TVN_GETDISPINFOW")},
    {CommCtrl.TVN_SETDISPINFOA,     SYSTEM.ADR("TVN_SETDISPINFOA")},
    {CommCtrl.TVN_SETDISPINFOW,     SYSTEM.ADR("TVN_SETDISPINFOW")},
    {CommCtrl.TVN_ITEMEXPANDINGA,   SYSTEM.ADR("TVN_ITEMEXPANDINGA")},
    {CommCtrl.TVN_ITEMEXPANDINGW,   SYSTEM.ADR("TVN_ITEMEXPANDINGW")},
    {CommCtrl.TVN_ITEMEXPANDEDA,    SYSTEM.ADR("TVN_ITEMEXPANDEDA")},
    {CommCtrl.TVN_ITEMEXPANDEDW,    SYSTEM.ADR("TVN_ITEMEXPANDEDW")},
    {CommCtrl.TVN_BEGINDRAGA,       SYSTEM.ADR("TVN_BEGINDRAGA")},
    {CommCtrl.TVN_BEGINDRAGW,       SYSTEM.ADR("TVN_BEGINDRAGW")},
    {CommCtrl.TVN_BEGINRDRAGA,      SYSTEM.ADR("TVN_BEGINRDRAGA")},
    {CommCtrl.TVN_BEGINRDRAGW,      SYSTEM.ADR("TVN_BEGINRDRAGW")},
    {CommCtrl.TVN_DELETEITEMA,      SYSTEM.ADR("TVN_DELETEITEMA")},
    {CommCtrl.TVN_DELETEITEMW,      SYSTEM.ADR("TVN_DELETEITEMW")},
    {CommCtrl.TVN_BEGINLABELEDITA,  SYSTEM.ADR("TVN_BEGINLABELEDITA")},
    {CommCtrl.TVN_BEGINLABELEDITW,  SYSTEM.ADR("TVN_BEGINLABELEDITW")},
    {CommCtrl.TVN_ENDLABELEDITA,    SYSTEM.ADR("TVN_ENDLABELEDITA")},
    {CommCtrl.TVN_ENDLABELEDITW,    SYSTEM.ADR("TVN_ENDLABELEDITW")},
    {CommCtrl.TVN_KEYDOWN,          SYSTEM.ADR("TVN_KEYDOWN")},
    {CommCtrl.TTN_NEEDTEXTA,        SYSTEM.ADR("TTN_NEEDTEXTA")},
    {CommCtrl.TTN_NEEDTEXTW,        SYSTEM.ADR("TTN_NEEDTEXTW")},
    {CommCtrl.TTN_SHOW,             SYSTEM.ADR("TTN_SHOW")},
    {CommCtrl.TTN_POP,              SYSTEM.ADR("TTN_POP")},
    {CommCtrl.TCN_KEYDOWN,          SYSTEM.ADR("TCN_KEYDOWN")},
    {CommCtrl.TCN_SELCHANGE,        SYSTEM.ADR("TCN_SELCHANGE")},
    {CommCtrl.TCN_SELCHANGING,      SYSTEM.ADR("TCN_SELCHANGING")},
    {CommCtrl.TBN_GETBUTTONINFOA,   SYSTEM.ADR("TBN_GETBUTTONINFOA")},
    {CommCtrl.TBN_GETBUTTONINFOW,   SYSTEM.ADR("TBN_GETBUTTONINFOW")},
    {CommCtrl.TBN_BEGINDRAG,        SYSTEM.ADR("TBN_BEGINDRAG")},
    {CommCtrl.TBN_ENDDRAG,          SYSTEM.ADR("TBN_ENDDRAG")},
    {CommCtrl.TBN_BEGINADJUST,      SYSTEM.ADR("TBN_BEGINADJUST")},
    {CommCtrl.TBN_ENDADJUST,        SYSTEM.ADR("TBN_ENDADJUST")},
    {CommCtrl.TBN_RESET,            SYSTEM.ADR("TBN_RESET")},
    {CommCtrl.TBN_QUERYINSERT,      SYSTEM.ADR("TBN_QUERYINSERT")},
    {CommCtrl.TBN_QUERYDELETE,      SYSTEM.ADR("TBN_QUERYDELETE")},
    {CommCtrl.TBN_TOOLBARCHANGE,    SYSTEM.ADR("TBN_TOOLBARCHANGE")},
    {CommCtrl.TBN_CUSTHELP,         SYSTEM.ADR("TBN_CUSTHELP")},
    {CommCtrl.UDN_DELTAPOS,         SYSTEM.ADR("UDN_DELTAPOS")},
    {CommCtrl.PSN_SETACTIVE,        SYSTEM.ADR("PSN_SETACTIVE")},
    {CommCtrl.PSN_KILLACTIVE,       SYSTEM.ADR("PSN_KILLACTIVE")},
    {CommCtrl.PSN_APPLY,            SYSTEM.ADR("PSN_APPLY")},
    {CommCtrl.PSN_RESET,            SYSTEM.ADR("PSN_RESET")},
    {CommCtrl.PSN_HELP,             SYSTEM.ADR("PSN_HELP")},
    {CommCtrl.PSN_WIZBACK,          SYSTEM.ADR("PSN_WIZBACK")},
    {CommCtrl.PSN_WIZNEXT,          SYSTEM.ADR("PSN_WIZNEXT")},
    {CommCtrl.PSN_WIZFINISH,        SYSTEM.ADR("PSN_WIZFINISH")},
    {CommCtrl.PSN_QUERYCANCEL,      SYSTEM.ADR("PSN_QUERYCANCEL")}
     };
NOTIFY_COUNT := SIZE(cnLookupTable) / SIZE(CONTROLNOTIFICATIONS);

END Notify.
