<* +M2EXTENSIONS *>
IMPLEMENTATION MODULE TreeView;
(*----------------------------------------------
   TREEVIEW.C      --- Functions to support tree view
                   (c) Paul Yao, 1996
   TreeView.mod    --- Translation to XDS Modula-2
                   (c) Peter Stadler 1997
  ----------------------------------------------*)
IMPORT resource;
IMPORT Windows;
IMPORT CommCtrl;
IMPORT MemUtils;
IMPORT SYSTEM;
IMPORT Str;

IMPORT TreeData;

(*-------------------------------------------------------------------          *)
PROCEDURE tv_BuildRootFolder (hwndLV : Windows.HWND) : BOOLEAN;
VAR
  i     : INTEGER;
  tvis  : CommCtrl.TV_INSERTSTRUCT;
BEGIN

     (* Initialize list view item structure                                    *)
     MemUtils.FillMemBYTE (tvis, SIZE (CommCtrl.TV_INSERTSTRUCT),0);
     tvis.hParent := NIL;
     tvis.hInsertAfter := CommCtrl.TVI_LAST;
     tvis.item.mask := CommCtrl.TVIF_TEXT + CommCtrl.TVIF_PARAM + CommCtrl.TVIF_CHILDREN +
                      CommCtrl.TVIF_IMAGE + CommCtrl.TVIF_SELECTEDIMAGE;
     tvis.item.iImage := 0;
     tvis.item.iSelectedImage := 0;
     tvis.item.cchTextMax := 256;

     FOR i := 0 TO TreeData.cRootFolders-1 DO
          tvis.item.pszText := TreeData.fldRoot[i].pName;
          tvis.item.lParam := SYSTEM.CAST(Windows.LPARAM,SYSTEM.ADR(TreeData.fldRoot[i]));
          tvis.item.cChildren := 1;
          TreeData.fldRoot[i].hItem := CommCtrl.TreeView_InsertItem (hwndLV, tvis);
     END;

     RETURN TRUE;
END tv_BuildRootFolder;

(*******************************************************************-          *)
PROCEDURE tv_ExpandChild (hwndLV : Windows.HWND; lParam : Windows.LPARAM);
VAR
  pFolder  :  TreeData.LPFOLDER;
  pItem    :  TreeData.LPITEM;
  pFldr    :  TreeData.LPFOLDER;
  tvis     :  CommCtrl.TV_INSERTSTRUCT;
BEGIN
     pFolder := SYSTEM.CAST(TreeData.LPFOLDER,lParam);
     pItem := pFolder^.piChild;

     (* Initialize list view item structure                                    *)
     MemUtils.FillMemBYTE (tvis, SIZE (CommCtrl.TV_INSERTSTRUCT),0);
     tvis.hParent := pFolder^.hItem;
     tvis.hInsertAfter := CommCtrl.TVI_LAST;
     tvis.item.mask := CommCtrl.TVIF_TEXT + CommCtrl.TVIF_PARAM +
                      CommCtrl.TVIF_IMAGE + CommCtrl.TVIF_SELECTEDIMAGE;
     tvis.item.iImage := 1;
     tvis.item.iSelectedImage := 1;
     tvis.item.cchTextMax := 256;

     IF (pItem^.hItem = NIL) THEN
          IF (pItem^.nType = TreeData.TYPE_ITEM) THEN        (* Add macro items             *)
               LOOP     
                    tvis.item.pszText :=  pItem^.pName;
                    tvis.item.lParam := SYSTEM.CAST(Windows.LPARAM,pItem);
		    (* Fehler in C-Text ???    
		    tvis.item.lParam := SYSTEM.CAST(Windows.LPARAM,SYSTEM.ADR(pItem));
		    *)
                    pItem^.hItem := CommCtrl.TreeView_InsertItem (hwndLV, tvis);
		    pItem := SYSTEM.ADDADR(pItem,SIZE(TreeData.ITEM));
                    IF(pItem^.hItem = TreeData.LASTITEM) THEN
                      EXIT;
                    END;
               END;
          ELSE (* (pItem^.nType = TYPE_FOLDER)  Add folder items            *)
               pFldr := SYSTEM.CAST(TreeData.LPFOLDER,pFolder^.piChild);
               tvis.item.mask := CommCtrl.TVIF_TEXT + CommCtrl.TVIF_PARAM + CommCtrl.TVIF_CHILDREN +
                                CommCtrl.TVIF_IMAGE + CommCtrl.TVIF_SELECTEDIMAGE;
               tvis.item.iImage := 0;
               tvis.item.iSelectedImage := 0;
               LOOP 
                    tvis.item.pszText := pFldr^.pName;
                    tvis.item.lParam := SYSTEM.CAST(Windows.LPARAM,pFldr);
		    (* Fehler in C-Text ???      
		    tvis.item.lParam := SYSTEM.CAST(Windows.LPARAM,SYSTEM.ADR(pFldr));
		    *)
                    tvis.item.cChildren := 1;
                    
                    pFldr^.hItem := CommCtrl.TreeView_InsertItem (hwndLV, tvis);
		    pFldr := SYSTEM.ADDADR(pFldr,SIZE(TreeData.FOLDER));
                    IF(pFldr^.hItem = TreeData.LASTITEM) THEN
                      EXIT;
                    END;
               END;
          END;
      END;
END tv_ExpandChild;

(*******************************************************************-          *)
PROCEDURE tv_FetchMacro (lParam : Windows.LPARAM; hwndCtrl : Windows.HWND): BOOLEAN;
VAR
   pItem  : TreeData.LPITEM;
BEGIN
     pItem := SYSTEM.CAST(TreeData.LPITEM,lParam);

     IF (pItem^.nType = TreeData.TYPE_FOLDER) THEN
          RETURN FALSE;
     END;
     WINX.Edit_SetText (hwndCtrl, pItem^.pMacro^);
     RETURN TRUE;
END tv_FetchMacro;
END TreeView.
