<* +M2EXTENSIONS *>

IMPLEMENTATION MODULE comcthlp;
(*---------------------------------------------------
   COMCTHLP.H -- Helper macros for common controls
                 (c) Paul Yao, 1996

   Portions Copyright (c) 1992-1996, Microsoft Corp.
  ---------------------------------------------------*)

(*-------------------------------------------------------------------
  Hot-Key Helper Macros
-------------------------------------------------------------------*)
IMPORT SYSTEM;
IMPORT Windows;

IMPORT CommCtrl;



PROCEDURE HotKey_SetHotKey ( hwnd : Windows.HWND; bVKHotKey, bfMods:BOOLEAN);

BEGIN
    Windows.SendMessage(hwnd, CommCtrl.HKM_SETHOTKEY, Windows.MAKEWORD(SYSTEM.CAST(Windows.BYTE,bVKHotKey), SYSTEM.CAST(Windows.BYTE,bfMods)), 0000h);

END HotKey_SetHotKey;

PROCEDURE HotKey_GetHotKey ( hwnd:Windows.HWND);
BEGIN
    Windows.SendMessage(hwnd, CommCtrl.HKM_SETHOTKEY, 0, 0000h);
END HotKey_GetHotKey;

PROCEDURE HotKey_SetRules ( hwnd : Windows.HWND; fwCombInv, fwModInv: Windows.WORD);
BEGIN
    Windows.SendMessage(hwnd, CommCtrl.HKM_SETRULES, SYSTEM.CAST(Windows.WPARAM,fwCombInv), Windows.MAKELPARAM(fwModInv, 0000h));

END HotKey_SetRules;

(*-------------------------------------------------------------------*)
(*   Progress Bar Helper Macros                                      *)
(*-------------------------------------------------------------------*)
PROCEDURE Progress_SetRange ( hwnd : Windows.HWND; nMinRange, nMaxRange:INTEGER);
BEGIN
    Windows.SendMessage(hwnd,CommCtrl.PBM_SETRANGE,0, Windows.MAKELPARAM(nMinRange, nMaxRange));
END Progress_SetRange;

PROCEDURE Progress_SetPos ( hwnd : Windows.HWND; nNewPos: CARDINAL);
BEGIN
    Windows.SendMessage(hwnd, CommCtrl.PBM_SETPOS, SYSTEM.CAST(Windows.WPARAM,nNewPos), 0000h);
END Progress_SetPos;

(*
#define Progress_DeltaPos(hwnd, nIncrement) \
BEGIN
    Windows.SendMessage(SYSTEM.CAST(Windows.HWND, HKM_SETHOTKEY), 0, 0000h);
END HotKey_GetHotKey;
    (int)SendMessage((hwnd), PBM_DELTAPOS, (WPARAM) nIncrement, 0000h)

#define Progress_SetStep(hwnd, nStepInc) \
BEGIN
    Windows.SendMessage(SYSTEM.CAST(Windows.HWND, HKM_SETHOTKEY), 0, 0000h);
END HotKey_GetHotKey;
    (int)SendMessage((hwnd), PBM_SETSTEP, (WPARAM) nStepInc, 0000h)

#define Progress_StepIt(hwnd) \
BEGIN
    Windows.SendMessage(SYSTEM.CAST(Windows.HWND, HKM_SETHOTKEY), 0, 0000h);
END HotKey_GetHotKey;
    (int)SendMessage((hwnd), PBM_STEPIT, 0, 0000h)

(*-------------------------------------------------------------------*)
   Rich Edit Control Helper Macros
(*-------------------------------------------------------------------*)

(*---------------- Begin Macros Copied from windowsx.h---------------*)
#define RichEdit_Enable(hwndCtl, fEnable) \
    (BOOL)EnableWindow((hwndCtl), (fEnable))

#define RichEdit_GetText(hwndCtl, lpch, cchMax) \
    (int)GetWindowText((hwndCtl), (lpch), (cchMax))

#define RichEdit_GetTextLength(hwndCtl) \
    (int)GetWindowTextLength(hwndCtl)

#define RichEdit_SetText(hwndCtl, lpsz)  \
    (BOOL)SetWindowText((hwndCtl), (lpsz))

#define RichEdit_LimitText(hwndCtl, cchMax) \
    ((void)SendMessage((hwndCtl), EM_LIMITTEXT, (WPARAM)(cchMax), 0000h))

#define RichEdit_GetLineCount(hwndCtl) \
    ((int)(DWORD)SendMessage((hwndCtl), EM_GETLINECOUNT, 0000h, 0000h))

#define RichEdit_GetLine(hwndCtl, line, lpch, cchMax) \
    (( *((int * )(lpch)) = (cchMax)), ((int)(DWORD)SendMessage((hwndCtl), EM_GETLINE, (WPARAM)(int)(line), (LPARAM)(LPTSTR)(lpch))))

#define RichEdit_GetRect(hwndCtl, lprc) \
    ((void)SendMessage((hwndCtl), EM_GETRECT, 0000h, (LPARAM)(RECT * )(lprc)))

#define RichEdit_SetRect(hwndCtl, lprc) \
    ((void)SendMessage((hwndCtl), EM_SETRECT, 0000h, (LPARAM)(const RECT * )(lprc)))

#define RichEdit_GetSel(hwndCtl) \
    ((DWORD)SendMessage((hwndCtl), EM_GETSEL, 0000h, 0000h))

#define RichEdit_SetSel(hwndCtl, ichStart, ichEnd) \
    ((void)SendMessage((hwndCtl), EM_SETSEL, (ichStart), (ichEnd)))

#define RichEdit_ReplaceSel(hwndCtl, lpszReplace) \
    ((void)SendMessage((hwndCtl), EM_REPLACESEL, 0000h, (LPARAM)(LPCTSTR)(lpszReplace)))

#define RichEdit_GetModify(hwndCtl) \
    ((BOOL)(DWORD)SendMessage((hwndCtl), EM_GETMODIFY, 0000h, 0000h))

#define RichEdit_SetModify(hwndCtl, fModified) \
    ((void)SendMessage((hwndCtl), EM_SETMODIFY, (WPARAM)(UINT)(fModified), 0000h))

#define RichEdit_ScrollCaret(hwndCtl) \
    ((BOOL)(DWORD)SendMessage((hwndCtl), EM_SCROLLCARET, 0, 0000h))

#define RichEdit_LineFromChar(hwndCtl, ich) \
    ((int)(DWORD)SendMessage((hwndCtl), EM_LINEFROMCHAR, (WPARAM)(int)(ich), 0000h))

#define RichEdit_LineIndex(hwndCtl, line) \
    ((int)(DWORD)SendMessage((hwndCtl), EM_LINEINDEX, (WPARAM)(int)(line), 0000h))

#define RichEdit_LineLength(hwndCtl, line) \
    ((int)(DWORD)SendMessage((hwndCtl), EM_LINELENGTH, (WPARAM)(int)(line), 0000h))

#define RichEdit_Scroll(hwndCtl, dv, dh) \
    ((void)SendMessage((hwndCtl), EM_LINESCROLL, (WPARAM)(dh), (LPARAM)(dv)))

#define RichEdit_CanUndo(hwndCtl)  \
    ((BOOL)(DWORD)SendMessage((hwndCtl), EM_CANUNDO, 0000h, 0000h))

#define RichEdit_Undo(hwndCtl)  \
    ((BOOL)(DWORD)SendMessage((hwndCtl), EM_UNDO, 0000h, 0000h))

#define RichEdit_EmptyUndoBuffer(hwndCtl) \
    ((void)SendMessage((hwndCtl), EM_EMPTYUNDOBUFFER, 0000h, 0000h))

#define RichEdit_GetFirstVisibleLine(hwndCtl) \
    ((int)(DWORD)SendMessage((hwndCtl), EM_GETFIRSTVISIBLELINE, 0000h, 0000h))

#define RichEdit_SetReadOnly(hwndCtl, fReadOnly) \
    ((BOOL)(DWORD)SendMessage((hwndCtl), EM_SETREADONLY, (WPARAM)(BOOL)(fReadOnly), 0000h))

#define RichEdit_SetWordBreakProc(hwndCtl, lpfnWordBreak) \
    ((void)SendMessage((hwndCtl), EM_SETWORDBREAKPROC, 0000h, (LPARAM)(EDITWORDBREAKPROC)(lpfnWordBreak)))

#define RichEdit_GetWordBreakProc(hwndCtl) \
    ((EDITWORDBREAKPROC)SendMessage((hwndCtl), EM_GETWORDBREAKPROC, 0000h, 0000h))

#define RichEdit_CanPaste(hwnd, uFormat) \
    (BOOL)SendMessage((hwnd), EM_CANPASTE, (WPARAM) (UINT) uFormat, 0000h)

#define RichEdit_CharFromPos(hwnd, x, y) \
    (DWORD)SendMessage((hwnd), EM_CHARFROMPOS, 0, MAKELPARAM(x, y))

#define RichEdit_DisplayBand(hwnd, lprc) \
    (BOOL)SendMessage((hwnd), EM_DISPLAYBAND, 0, (LPARAM) (LPRECT) lprc)

#define RichEdit_ExGetSel(hwnd, lpchr) \
    (void)SendMessage((hwnd), EM_EXGETSEL, 0, (LPARAM) (CHARRANGE FAR * ) lpchr)

#define RichEdit_ExLimitText(hwnd, cchTextMax) \
    (void)SendMessage((hwnd), EM_EXLIMITTEXT, 0, (LPARAM) (DWORD) cchTextMax)

#define RichEdit_ExLineFromChar(hwnd, ichCharPos) \
    (int)SendMessage((hwnd), EM_EXLINEFROMCHAR, 0, (LPARAM) (DWORD) ichCharPos)

#define RichEdit_ExSetSel(hwnd, ichCharRange) \
    (int)SendMessage((hwnd), EM_EXSETSEL, 0, (LPARAM) (CHARRANGE FAR * ) ichCharRange)

#define RichEdit_FindText(hwnd, fuFlags, lpFindText) \
    (int)SendMessage((hwnd), EM_FINDTEXT, (WPARAM) (UINT) fuFlags, (LPARAM) (FINDTEXT FAR * ) lpFindText)

#define RichEdit_FindTextEx(hwnd, fuFlags, lpFindText) \
    (int)SendMessage((hwnd), EM_FINDTEXTEX, (WPARAM) (UINT) fuFlags, (LPARAM) (FINDTEXT FAR * ) lpFindText)

#define RichEdit_FindWordBreak(hwnd, code, ichStart) \
    (int)SendMessage((hwnd), EM_FINDWORDBREAK, (WPARAM) (UINT) code, (LPARAM) (DWORD) ichStart)

#define RichEdit_FormatRange(hwnd, fRender, lpFmt) \
    (int)SendMessage((hwnd), EM_FORMATRANGE, (WPARAM) (BOOL) fRender, (LPARAM) (FORMATRANGE FAR * ) lpFmt)

#define RichEdit_GetCharFormat(hwnd, fSelection, lpFmt) \
    (DWORD)SendMessage((hwnd), EM_GETCHARFORMAT, (WPARAM) (BOOL) fSelection, (LPARAM) (CHARFORMAT FAR * ) lpFmt)

#define RichEdit_GetEventMask(hwnd) \
    (DWORD)SendMessage((hwnd), EM_GETEVENTMASK, 0, 0000h)

#define RichEdit_GetLimitText(hwnd) \
    (int)SendMessage((hwnd), EM_GETLIMITTEXT, 0, 0000h)

#define RichEdit_GetOleInterface(hwnd, ppObject) \
    (BOOL)SendMessage((hwnd), EM_GETOLEINTERFACE, 0, (LPARAM) (LPVOID FAR * ) ppObject)

#define RichEdit_GetOptions(hwnd) \
    (UINT)SendMessage((hwnd), EM_GETOPTIONS, 0, 0000h)

#define RichEdit_GetParaFormat(hwnd, lpFmt) \
    (DWORD)SendMessage((hwnd), EM_GETPARAFORMAT, 0, (LPARAM) (PARAFORMAT FAR * ) lpFmt)

#define RichEdit_GetSelText(hwnd, lpBuf) \
    (int)SendMessage((hwnd), EM_GETSELTEXT, 0, (LPARAM) (PSTR) lpBuf)

#define RichEdit_GetTextRange(hwnd, lpRange) \
    (int)SendMessage((hwnd), EM_GETTEXTRANGE, 0, (LPARAM) (TEXTRANGE FAR * ) lpRange)

#define RichEdit_GetWordBreakProcEx(hwnd) \
    (EDITWORDBREAKPROCEX * )SendMessage((hwnd), EM_GETWORDBREAKPROCEX, 0, 0000h)
(*----------------- End Macros Copied from windowsx.h----------------*)

#define RichEdit_HideSelection(hwnd, fHide, fChangeStyle) \
    (void)SendMessage((hwnd), EM_HIDESELECTION, (WPARAM) (BOOL) fHide, (LPARAM) (BOOL) fChangeStyle)

#define RichEdit_PasteSpecial(hwnd, uFormat) \
    (void)SendMessage((hwnd), EM_PASTESPECIAL, (WPARAM) (UINT) uFormat, 0000h)

#define RichEdit_PosFromChar(hwnd, wCharIndex) \
    (DWORD)SendMessage((hwnd), EM_POSFROMCHAR, (WPARAM)wCharIndex, 0000h)

#define RichEdit_RequestResize(hwnd) \
    (void)SendMessage((hwnd), EM_REQUESTRESIZE, 0, 0000h)

#define RichEdit_SelectionType(hwnd) \
    (int)SendMessage((hwnd), EM_SELECTIONTYPE, 0, 0000h)

#define RichEdit_SetBkgndColor(hwnd, fUseSysColor, clr) \
    (COLORREF)SendMessage((hwnd), EM_SETBKGNDCOLOR, (WPARAM) (BOOL) fUseSysColor, (LPARAM) (COLORREF) clr)

#define RichEdit_SetCharFormat(hwnd, uFlags, lpFmt) \
    (BOOL)SendMessage((hwnd), EM_SETCHARFORMAT, (WPARAM) (UINT) uFlags, (LPARAM) (CHARFORMAT FAR * ) lpFmt)

#define RichEdit_SetEventMask(hwnd, dwMask) \
    (DWORD)SendMessage((hwnd), EM_SETEVENTMASK, 0, (LPARAM) (DWORD) dwMask)

#define RichEdit_SetOleCallback(hwnd, lpObj) \
    (BOOL)SendMessage((hwnd), EM_SETOLECALLBACK, 0, (LPARAM) (IRichEditOleCallback FAR * ) lpObj)

#define RichEdit_SetOptions(hwnd, fOperation, fOptions) \
    (UINT)SendMessage((hwnd), EM_SETOPTIONS, (WPARAM) (UINT) fOperation, (LPARAM) (UINT) fOptions)

#define RichEdit_SetParaFormat(hwnd, lpFmt) \
    (BOOL)SendMessage((hwnd), EM_SETPARAFORMAT, 0, (LPARAM) (PARAFORMAT FAR * ) lpFmt)

#define RichEdit_SetTargetDevice(hwnd, hdcTarget, cxLineWidth) \
    (BOOL)SendMessage((hwnd), EM_SETTARGETDEVICE, (WPARAM) (HDC) hdcTarget, (LPARAM) (int) cxLineWidth)

#define RichEdit_SetWordBreakProcEx(hwnd, pfnWordBreakProcEx) \
    (EDITWORDBREAKPROCEX * )SendMessage((hwnd), EM_SETWORDBREAKPROCEX, 0, (LPARAM) (EDITWORDBREAKPROCEX * )pfnWordBreakProcEx)

#define RichEdit_StreamIn(hwnd, uFormat, lpStream) \
    (int)SendMessage((hwnd), EM_STREAMIN, (WPARAM) (UINT) uFormat, (LPARAM) (EDITSTREAM FAR * ) lpStream)

#define RichEdit_StreamOut(hwnd, uFormat, lpStream) \
    (int)SendMessage((hwnd), EM_STREAMOUT, (WPARAM) (UINT) uFormat, (LPARAM) (EDITSTREAM FAR * ) lpStream)

(*-------------------------------------------------------------------*)
  Status Bar Helper Macros
(*-------------------------------------------------------------------*)
*)
PROCEDURE Status_GetBorders (hwnd : Windows.HWND; aBorders : ARRAY OF INTEGER) : BOOLEAN;
BEGIN
   RETURN SYSTEM.CAST(BOOLEAN,Windows.SendMessage(hwnd,CommCtrl.SB_GETBORDERS,0, SYSTEM.CAST(Windows.LPARAM,aBorders)));
END Status_GetBorders;
   (*
#define Status_GetBorders(hwnd, aBorders) \
    (BOOL)SendMessage((hwnd), SB_GETBORDERS, 0, (LPARAM) (LPINT) aBorders)
*)
PROCEDURE Status_GetParts (hwnd : Windows.HWND; nParts,aRightCoord : INTEGER) : INTEGER;
BEGIN
   RETURN SYSTEM.CAST(INTEGER,Windows.SendMessage(hwnd,CommCtrl.SB_GETPARTS,SYSTEM.CAST(Windows.WPARAM,nParts),SYSTEM.CAST(Windows.LPARAM,aRightCoord)));
END Status_GetParts;
(*

#define Status_GetParts(hwnd, nParts, aRightCoord) \
    (int)SendMessage((hwnd), SB_GETPARTS, (WPARAM) nParts, (LPARAM) (LPINT) aRightCoord)

#define Status_GetRect(hwnd, iPart, lprc) \
    (BOOL)SendMessage((hwnd), SB_GETRECT, (WPARAM) iPart, (LPARAM) (LPRECT) lprc)

#define Status_GetText(hwnd, iPart, szText) \
    (DWORD)SendMessage((hwnd), SB_GETTEXT, (WPARAM) iPart, (LPARAM) (PSTR) szText)

#define Status_GetTextLength(hwnd, iPart) \
    (DWORD)SendMessage((hwnd), SB_GETTEXTLENGTH, (WPARAM) iPart, 0000h)

#define Status_SetMinHeight(hwnd, minHeight) \
    (void)SendMessage((hwnd), SB_SETMINHEIGHT, (WPARAM) minHeight, 0000h)

#define Status_SetParts(hwnd, nParts, aWidths) \
    (BOOL)SendMessage((hwnd), SB_SETPARTS, (WPARAM) nParts, (LPARAM) (LPINT) aWidths)
    *)
PROCEDURE Status_SetText (hwnd : Windows.HWND; iPart : INTEGER; uType : Windows.UINT; szText : ARRAY OF CHAR) : INTEGER;
BEGIN
   RETURN SYSTEM.CAST(INTEGER,Windows.SendMessage(hwnd,CommCtrl.SB_SETTEXT,SYSTEM.CAST(Windows.WPARAM,iPart + SYSTEM.CAST(INTEGER,uType)),SYSTEM.CAST(Windows.LPARAM,szText)));
END Status_SetText;

(*
#define Status_SetText(hwnd, iPart, uType, szText) \
    (BOOL)SendMessage((hwnd), SB_SETTEXT, (WPARAM) (iPart | uType), (LPARAM) (PSTR) szText)
    *)
PROCEDURE Status_Simple (hwnd : Windows.HWND; fSimple : Windows.WORD) : BOOLEAN;
BEGIN
    RETURN SYSTEM.CAST(BOOLEAN,Windows.SendMessage(hwnd,CommCtrl.SB_SIMPLE, SYSTEM.CAST(Windows.WPARAM,fSimple),00000h));
END Status_Simple;


(*
#define Status_Simple(hwnd, fSimple) \
    (BOOL)SendMessage((hwnd), SB_SIMPLE, (WPARAM) (BOOL) fSimple, 0000h)

(*-------------------------------------------------------------------*)
   Tool Bar Helper Macros
(*-------------------------------------------------------------------*)

#define ToolBar_AddBitmap(hwnd, nButtons, lptbab) \
    (int)SendMessage((hwnd), TB_ADDBITMAP, (WPARAM)nButtons, (LPARAM)(LPTBADDBITMAP) lptbab)

#define ToolBar_AddButtons(hwnd, uNumButtons, lpButtons) \
    (BOOL)SendMessage((hwnd), TB_ADDBUTTONS, (WPARAM)(UINT)uNumButtons, (LPARAM)(LPTBBUTTON)lpButtons)

*)
PROCEDURE ToolBar_AddString (hwnd : Windows.HWND; hinst : Windows.HINSTANCE; idString : ARRAY OF CHAR);
BEGIN
    Windows.SendMessage(hwnd,CommCtrl.TB_ADDSTRING,SYSTEM.CAST(Windows.WPARAM,hinst),SYSTEM.CAST(Windows.LPARAM,idString));
END ToolBar_AddString;

PROCEDURE ToolBar_AutoSize (hwnd : Windows.HWND);
BEGIN
  Windows.SendMessage(hwnd, CommCtrl.TB_AUTOSIZE, 0,00000h);
END ToolBar_AutoSize;

(*
#define ToolBar_AutoSize(hwnd) \
    (void)SendMessage((hwnd), TB_AUTOSIZE, 0, 0000h)

*)
PROCEDURE ToolBar_ButtonCount (hwnd : Windows.HWND) : INTEGER;
BEGIN
   RETURN SYSTEM.CAST(INTEGER,Windows.SendMessage(hwnd, CommCtrl.TB_BUTTONCOUNT, 0,00000h));
END ToolBar_ButtonCount;

(*
#define ToolBar_ButtonCount(hwnd) \
    (int)SendMessage((hwnd), TB_BUTTONCOUNT, 0, 0000h)

#define ToolBar_ButtonStructSize(hwnd) \
    (void)SendMessage((hwnd), TB_BUTTONSTRUCTSIZE, (WPARAM)sizeof(TBBUTTON), 0000h)

#define ToolBar_ChangeBitmap(hwnd, idButton, iBitmap) \
    (BOOL)SendMessage((hwnd), TB_CHANGEBITMAP, (WPARAM) idButton, (LPARAM)iBitmap);
*)

PROCEDURE ToolBar_CheckButton (hwnd : Windows.HWND; idButton : INTEGER; fCheck : Windows.WORD) : BOOLEAN;
BEGIN
   RETURN SYSTEM.CAST(BOOLEAN,Windows.SendMessage(hwnd, CommCtrl.TB_CHECKBUTTON, SYSTEM.CAST(Windows.WPARAM,idButton),SYSTEM.CAST(Windows.LPARAM,Windows.MAKELONG(fCheck,0))));
END ToolBar_CheckButton;
(*
#define ToolBar_CheckButton(hwnd, idButton, fCheck ) \
    (BOOL)SendMessage((hwnd), TB_CHECKBUTTON, (WPARAM) idButton, (LPARAM) MAKELONG(fCheck, 0))

#define ToolBar_CommandToIndex(hwnd, idButton) \
    (int)SendMessage((hwnd), TB_COMMANDTOINDEX, (WPARAM) idButton, 0000h)

#define ToolBar_Customize(hwnd) \
    (void)SendMessage((hwnd), TB_CUSTOMIZE, 0, 0000h)

#define ToolBar_DeleteButton(hwnd, idButton) \
    (BOOL)SendMessage((hwnd), TB_DELETEBUTTON, (WPARAM) idButton, 0000h)
*)

PROCEDURE ToolBar_EnableButton (hwnd : Windows.HWND; idButton : INTEGER; fEnable : Windows.WORD) : BOOLEAN;
BEGIN
   RETURN SYSTEM.CAST(BOOLEAN,Windows.SendMessage(hwnd, CommCtrl.TB_ENABLEBUTTON, SYSTEM.CAST(Windows.WPARAM,idButton),SYSTEM.CAST(Windows.LPARAM,Windows.MAKELONG(fEnable,0))));
END ToolBar_EnableButton;

(*
#define ToolBar_GetBitmap(hwnd, idButton) \
    (int)SendMessage((hwnd), TB_GETBITMAP, (WPARAM) idButton, 0000h)

#define ToolBar_GetBitmapFlags(hwnd) \
    (int)SendMessage((hwnd), TB_GETBITMAPFLAGS, 0, 0000h)

#define ToolBar_GetButton(hwnd, idButton, lpButton) \
    (BOOL)SendMessage((hwnd), TB_GETBUTTON, (WPARAM)idButton, (LPARAM)(LPTBBUTTON) lpButton)

#define ToolBar_GetButtonText(hwnd, idButton, lpszText) \
    (int)SendMessage((hwnd), TB_GETBUTTONTEXT, (WPARAM) idButton, (LPARAM)(PSTR)lpszText)

*)
PROCEDURE ToolBar_GetItemRect(hwnd : Windows.HWND; idButton : INTEGER; lprc : Windows.LPRECT) : BOOLEAN;
BEGIN
   RETURN SYSTEM.CAST(BOOLEAN,Windows.SendMessage(hwnd,CommCtrl.TB_GETITEMRECT,SYSTEM.CAST(Windows.WPARAM,idButton),SYSTEM.CAST(Windows.LPARAM,lprc)));
END ToolBar_GetItemRect;

PROCEDURE ToolBar_GetRows (hwnd : Windows.HWND) : INTEGER;
BEGIN
   RETURN SYSTEM.CAST(INTEGER,Windows.SendMessage(hwnd, CommCtrl.TB_GETROWS, 0,00000h));
END ToolBar_GetRows;
(*
#define ToolBar_GetRows(hwnd) \
    (int)SendMessage((hwnd), TB_GETROWS, 0, 0000h)
*)
PROCEDURE ToolBar_GetState(hwnd : Windows.HWND; idButton : INTEGER) : INTEGER;
BEGIN
  RETURN SYSTEM.CAST(INTEGER,Windows.SendMessage(hwnd,CommCtrl.TB_GETSTATE,SYSTEM.CAST(Windows.WPARAM,idButton),00000h));
END ToolBar_GetState;

PROCEDURE ToolBar_GetToolTips(hwnd : Windows.HWND) : Windows.HWND;
BEGIN
  RETURN SYSTEM.CAST(Windows.HWND,Windows.SendMessage(hwnd,CommCtrl.TB_GETTOOLTIPS,0,00000h));
END ToolBar_GetToolTips;

PROCEDURE ToolBar_HideButton (hwnd : Windows.HWND; idButton : INTEGER; fShow : Windows.WORD) : BOOLEAN;
BEGIN
   RETURN SYSTEM.CAST(BOOLEAN,Windows.SendMessage(hwnd, CommCtrl.TB_HIDEBUTTON, SYSTEM.CAST(Windows.WPARAM,idButton),SYSTEM.CAST(Windows.LPARAM,Windows.MAKELONG(fShow,0))));
END ToolBar_HideButton;
(*
#define ToolBar_HideButton(hwnd, idButton, fShow) \
    (BOOL)SendMessage((hwnd), TB_HIDEBUTTON, (WPARAM)idButton, (LPARAM)MAKELONG(fShow, 0))
*)

PROCEDURE ToolBar_Indeterminate (hwnd : Windows.HWND; idButton : INTEGER; fIndeterminate : Windows.WORD) : BOOLEAN;
BEGIN
   RETURN SYSTEM.CAST(BOOLEAN,Windows.SendMessage(hwnd, CommCtrl.TB_HIDEBUTTON, SYSTEM.CAST(Windows.WPARAM,idButton),SYSTEM.CAST(Windows.LPARAM,Windows.MAKELONG(fIndeterminate,0))));
END ToolBar_Indeterminate;
(*
#define ToolBar_Indeterminate(hwnd, idButton, fIndeterminate) \
    (BOOL)SendMessage((hwnd), TB_INDETERMINATE, (WPARAM)idButton, (LPARAM) MAKELONG(fIndeterminate, 0))

#define ToolBar_InsertButton(hwnd, idButton, lpButton) \
    (BOOL)SendMessage((hwnd), TB_INSERTBUTTON, (WPARAM)idButton, (LPARAM)(LPTBBUTTON)lpButton)

#define ToolBar_IsButtonChecked(hwnd, idButton) \
    (int)SendMessage((hwnd), TB_ISBUTTONCHECKED, (WPARAM)idButton, 0000h)

#define ToolBar_IsButtonEnabled(hwnd, idButton) \
    (int)SendMessage((hwnd), TB_ISBUTTONENABLED, (WPARAM) idButton, 0000h)

#define ToolBar_IsButtonHidden(hwnd, idButton) \
    (int)SendMessage((hwnd), TB_ISBUTTONHIDDEN, (WPARAM) idButton, 0000h)

#define ToolBar_IsButtonIndeterminate(hwnd, idButton) \
    (int)SendMessage((hwnd), TB_ISBUTTONINDETERMINATE, (WPARAM) idButton, 0000h)

#define ToolBar_IsButtonPressed(hwnd, idButton) \
    (int)SendMessage((hwnd), TB_ISBUTTONPRESSED, (WPARAM) idButton, 0000h

*)
PROCEDURE ToolBar_PressButton (hwnd : Windows.HWND; idButton : INTEGER; fPress : Windows.WORD) : BOOLEAN;
BEGIN
   RETURN SYSTEM.CAST(BOOLEAN,Windows.SendMessage(hwnd, CommCtrl.TB_HIDEBUTTON, SYSTEM.CAST(Windows.WPARAM,idButton),SYSTEM.CAST(Windows.LPARAM,Windows.MAKELONG(fPress,0))));
END ToolBar_PressButton;

(*
#define ToolBar_PressButton(hwnd, idButton, fPress) \
    (BOOL)SendMessage((hwnd), TB_PRESSBUTTON, (WPARAM)idButton, (LPARAM)MAKELONG(fPress, 0))

#define ToolBar_SaveRestore(hwnd, fSave, ptbsp) \
    (void)SendMessage((hwnd), TB_SAVERESTORE, (WPARAM)(BOOL)fSave, (LPARAM)(TBSAVEPARAMS * )ptbsp)

#define ToolBar_SetBitmapSize(hwnd, dxBitmap, dyBitmap) \
    (BOOL)SendMessage((hwnd), TB_SETBITMAPSIZE, 0, (LPARAM)MAKELONG(dxBitmap, dyBitmap))

#define ToolBar_SetButtonSize(hwnd, dxBitmap, dyBitmap) \
    (BOOL)SendMessage((hwnd), TB_SETBUTTONSIZE, 0, (LPARAM)MAKELONG(dxBitmap, dyBitmap))

#define ToolBar_SetCmdID(hwnd, index, cmdId) \
    (BOOL)SendMessage((hwnd), TB_SETCMDID, (WPARAM)(UINT)index, (WPARAM)(UINT)cmdId)

#define ToolBar_SetParent(hwnd, hwndParent) \
    (void)SendMessage((hwnd), TB_SETPARENT, (WPARAM) (hwnd) hwndParent, 0000h)

#define ToolBar_SetRows(hwnd, cRows, fLarger, lprc) \
    (void)SendMessage((hwnd), TB_SETROWS, (WPARAM)MAKEWPARAM(cRows, fLarger),(LPARAM)(LPRECT)lprc)

#define ToolBar_SetState(hwnd, idButton, fState) \
    (BOOL)SendMessage((hwnd), TB_SETSTATE, (WPARAM)idButton, (LPARAM)MAKELONG(fState, 0))

#define ToolBar_SetToolTips(hwnd) \
    (void)SendMessage((hwnd), TB_SETTOOLTIPS, (WPARAM)(hwnd) hwndToolTip, 0000h)

(*-------------------------------------------------------------------*)
   Tool Tip Helper Macros
(*-------------------------------------------------------------------*)
#define ToolTip_Activate(hwnd, fActivate) \
    (void)SendMessage((hwnd), TTM_ACTIVATE, (WPARAM) (BOOL) fActivate, 0000h)
*)

PROCEDURE ToolTip_AddTool(hwnd : Windows.HWND; lpti : CommCtrl.TOOLINFO) : BOOLEAN;
BEGIN
  RETURN SYSTEM.CAST(BOOLEAN,Windows.SendMessage(hwnd,CommCtrl.TTM_ADDTOOL,0,SYSTEM.CAST(Windows.LPARAM,lpti)));
END ToolTip_AddTool;


(*
#define ToolTip_DelTool(hwnd, lpti) \
    (void)SendMessage((hwnd), TTM_DELTOOL, 0, (LPARAM) (LPTOOLINFO) lpti)

#define ToolTip_EnumTools(hwnd, iTool, lpti) \
    (BOOL)SendMessage((hwnd), TTM_ENUMTOOLS, (WPARAM) (UINT) iTool, (LPARAM) (LPTOOLINFO) lpti)

#define ToolTip_GetCurrentTool(hwnd, lpti) \
    (BOOL)SendMessage((hwnd), TTM_GETCURRENTTOOL, 0, (LPARAM) (LPTOOLINFO) lpti)

#define ToolTip_GetText(hwnd, lpti) \
    (void)SendMessage((hwnd), TTM_GETTEXT, 0, (LPARAM) (LPTOOLINFO) lpti)

#define ToolTip_GetToolCount(hwnd) \
    (int)SendMessage((hwnd), TTM_GETTOOLCOUNT, 0, 0000h)

#define ToolTip_GetToolInfo(hwnd, lpti) \
    (BOOL)SendMessage((hwnd), TTM_GETTOOLINFO, 0, (LPARAM) (LPTOOLINFO) lpti)

#define ToolTip_HitText(hwnd, lphti) \
    (BOOL)SendMessage((hwnd), TTM_HITTEST, 0, (LPARAM) (LPHITTESTINFO) lphti)

#define ToolTip_NewToolRect(hwnd, lpti) \
    (void)SendMessage((hwnd), TTM_NEWTOOLRECT, 0, (LPARAM) (LPTOOLINFO) lpti)

#define ToolTip_RelayEvent(hwnd, lpmsg) \
    (void)SendMessage((hwnd), TTM_RELAYEVENT, 0, (LPARAM) (LPMSG) lpmsg)

#define ToolTip_SetDelayTime(hwnd, uFlag, iDelay) \
    (void)SendMessage((hwnd), TTM_SETDELAYTIME, (WPARAM) uFlag, (LPARAM) (int) iDelay)

#define ToolTip_SetToolInfo(hwnd, lpti) \
    (void)SendMessage((hwnd), TTM_SETTOOLINFO, (LPARAM) (LPTOOLINFO) lpti)

#define ToolTip_UpdateTipText(hwnd, lpti) \
    (void)SendMessage((hwnd), TTM_UPDATETIPTEXT, 0, (LPARAM) (LPTOOLINFO) lpti)

#define ToolTip_WindowFromPoint(hwnd, lppt) \
    (hwnd)SendMessage((hwnd), TTM_WINDOWFROMPOINT, 0, (POINT FAR * ) lppt)

(*-------------------------------------------------------------------*)
   Track Bar Helper Macros
(*-------------------------------------------------------------------*)
#define TrackBar_ClearSel(hwnd, fRedraw) \
    (void)SendMessage((hwnd), TBM_CLEARSEL, (WPARAM) (BOOL) fRedraw, 0000h)

#define TrackBar_ClearTics(hwnd, fRedraw) \
    (void)SendMessage((hwnd), TBM_CLEARTICS, (WPARAM) (BOOL) fRedraw, 0000h)

#define TrackBar_GetChannelRect(hwnd, lprc) \
    (void)SendMessage((hwnd), TBM_GETCHANNELRECT, 0, (LPARAM) (LPRECT) lprc)

#define TrackBar_GetLineSize(hwnd) \
    (LONG)SendMessage((hwnd), TBM_GETLINESIZE, 0, 0000h)

#define TrackBar_GetNumTics(hwnd) \
    (LONG)SendMessage((hwnd), TBM_GETNUMTICS, 0, 0000h)

#define TrackBar_GetPageSize(hwnd) \
    (LONG)SendMessage((hwnd), TBM_GETPAGESIZE, 0, 0000h)

#define TrackBar_GetPos(hwnd) \
    (LONG)SendMessage((hwnd), TBM_GETPOS, 0, 0000h)

#define TrackBar_GetPTics(hwnd) \
    (LPLONG)SendMessage((hwnd), TBM_GETPTICS, 0, 0000h)

#define TrackBar_GetRangeMax(hwnd) \
    (LONG)SendMessage((hwnd), TBM_GETRANGEMAX, 0, 0000h)

#define TrackBar_GetRangeMin(hwnd) \
    (LONG)SendMessage((hwnd), TBM_GETRANGEMIN, 0, 0000h)

#define TrackBar_GetSelEnd(hwnd) \
    (LONG)SendMessage((hwnd), TBM_GETSELEND, 0, 0000h)

#define TrackBar_GetSelStart(hwnd) \
    (LONG)SendMessage((hwnd), TBM_GETSELSTART, 0, 0000h)

#define TrackBar_GetThumbLength(hwnd) \
    (UINT)SendMessage((hwnd), TBM_GETTHUMBLENGTH, 0, 0000h)

#define TrackBar_GetThumbRect(hwnd, lprc) \
    (void)SendMessage((hwnd), TBM_GETTHUMBRECT, 0, (LPARAM) (LPRECT) lprc)

#define TrackBar_GetTic(hwnd, iTic) \
    (LONG)SendMessage((hwnd), TBM_GETTIC, (WPARAM) (WORD) iTic, 0000h)

#define TrackBar_GetTicPos(hwnd, iTic) \
    (LONG)SendMessage((hwnd), TBM_GETTICPOS, (WPARAM) (WORD) iTic, 0000h)

#define TrackBar_SetLineSize(hwnd, lLineSize) \
    (LONG)SendMessage((hwnd), TBM_SETLINESIZE, 0, (LONG) lLineSize)

#define TrackBar_SetPageSize(hwnd, lPageSize) \
    (LONG)SendMessage((hwnd), TBM_SETPAGESIZE, 0, (LONG) lPageSize)

#define TrackBar_SetPos(hwnd, bPosition, lPosition) \
    (void)SendMessage((hwnd), TBM_SETPOS, (WPARAM) (BOOL) bPosition, (LPARAM) (LONG) lPosition)

#define TrackBar_SetRange(hwnd, bRedraw, lMinimum, lMaximum) \
    (void)SendMessage((hwnd), TBM_SETRANGE, (WPARAM) (BOOL) bRedraw, (LPARAM) MAKELONG(lMinimum, lMaximum))

#define TrackBar_SetRangeMax(hwnd, bRedraw, lMaximum) \
    (void)SendMessage((hwnd), TBM_SETRANGEMAX, (WPARAM) bRedraw, (LPARAM) lMaximum)

#define TrackBar_SetRangeMin(hwnd, bRedraw, lMinimum) \
    (void)SendMessage((hwnd), TBM_SETRANGEMIN, (WPARAM) bRedraw, (LPARAM) lMinimum)

#define TrackBar_SetSel(hwnd, bRedraw, lMinimum, lMaximum) \
    (void)SendMessage((hwnd), TBM_SETSEL, (WPARAM) (BOOL) bRedraw, (LPARAM) MAKELONG(lMinimum, lMaximum))

#define TrackBar_SetSelEnd(hwnd, bRedraw, lEnd) \
    (void)SendMessage((hwnd), TBM_SETSELEND, (WPARAM) (BOOL) bRedraw, (LPARAM) (LONG) lEnd)

#define TrackBar_SetSelStart(hwnd, bRedraw, lStart) \
    (void)SendMessage((hwnd), TBM_SETSELSTART, (WPARAM) (BOOL) bRedraw, (LPARAM) (LONG) lStart)

#define TrackBar_SetThumbLength(hwnd, iLength) \
    (void)SendMessage((hwnd), TBM_SETTHUMBLENGTH, (WPARAM) (UINT) iLength, 0000h)

#define TrackBar_SetTic(hwnd, lPosition) \
    (BOOL)SendMessage((hwnd), TBM_SETTIC, 0, (LPARAM) (LONG) lPosition)

#define TrackBar_SetTicFreq(hwnd, wFreq, lPosition) \
    (void)SendMessage((hwnd), TBM_SETTICFREQ, (WPARAM) wFreq, (LPARAM) (LONG) lPosition)

(*-------------------------------------------------------------------*)
   Up \ Down Control Helper Macros
(*-------------------------------------------------------------------*)
#define UpDown_GetAccel(hwnd, cAccels, paAccels) \
    (int)SendMessage((hwnd), UDM_GETACCEL, (WPARAM) cAccels, (LPARAM) (LPUDACCEL) paAccels)

#define UpDown_GetBase(hwnd) \
    (int)SendMessage((hwnd), UDM_GETBASE, 0, 0000h)

#define UpDown_GetBuddy(hwnd) \
    (hwnd)SendMessage((hwnd), UDM_GETBUDDY, 0, 0000h)

#define UpDown_GetPos(hwnd) \
    (DWORD)SendMessage((hwnd), UDM_GETPOS, 0, 0000h)

#define UpDown_GetRange(hwnd) \
    (DWORD)SendMessage((hwnd), UDM_GETRANGE, 0, 0000h)

#define UpDown_SetAccel(hwnd, nAccels, aAccels) \
    (BOOL)SendMessage((hwnd), UDM_SETACCEL, (WPARAM) nAccels, (LPARAM) (LPUDACCEL) aAccels)

#define UpDown_SetBase(hwnd, nBase) \
    (int)SendMessage((hwnd), UDM_SETBASE, (WPARAM) nBase, 0000h)

#define UpDown_SetBuddy(hwnd, hwndBuddy) \
    (hwnd)SendMessage((hwnd), UDM_SETBUDDY, (WPARAM) (hwnd) hwndBuddy, 0000h)

#define UpDown_SetPos(hwnd, nPos) \
    (short)SendMessage((hwnd), UDM_SETPOS, 0, (LPARAM) MAKELONG((short) nPos, 0))

#define UpDown_SetRange(hwnd, nUpper, nLower) \
    (void)SendMessage((hwnd), UDM_SETRANGE, 0, (LPARAM) MAKELONG((short) nUpper, (short) nLower))
*)
END comcthlp.
