<* +M2EXTENSIONS *>

MODULE RndRctMT;
(*------------------------------------------
   RNDRCTMT.C      --- Displays Random Rectangles
                   (c) Charles Petzold, 1996
   RndRctMT.mod    --- Translation to XDS Modula-2
                   (c) Peter Stadler,   1997
  ------------------------------------------*)


IMPORT Windows;


IMPORT SYSTEM;
IMPORT Lib;
IMPORT Threads;

VAR
  hwnd      :  Windows.HWND;
  cxClient  :  INTEGER;
  cyClient  :  INTEGER;
  msg       :  Windows.MSG;
  wc        :  Windows.WNDCLASSEX;
CONST szAppName = "RndRctMT";

(*++++*****************************************************************)
PROCEDURE MaxInt (a,b : INTEGER) : INTEGER;
(**********************************************************************)
BEGIN
  IF(a>b) THEN
    RETURN a;
  ELSE
    RETURN b;
  END;
END MaxInt;
(*++++*****************************************************************)
PROCEDURE MinInt (a,b : INTEGER) : INTEGER;
(**********************************************************************)
BEGIN
  IF(a>b) THEN
    RETURN b;
  ELSE
    RETURN a;
  END;
END MinInt;

PROCEDURE Thread (dummy :  SYSTEM.ADDRESS) : Windows.DWORD;
 
    

VAR
  hBrush   :  Windows.HBRUSH;
  hdc      :  Windows.HDC;
  xLeft    :  INTEGER;
  xRight   :  INTEGER;
  yTop     :  INTEGER;
  yBottom  :  INTEGER;
  iRed     :  INTEGER;
  iGreen   :  INTEGER;
  iBlue    :  INTEGER;
BEGIN
(*
UNREFERENCED_PARAMETER(dummy);  *)

     LOOP
          IF (cxClient # 0) OR (cyClient # 0) THEN
	       xLeft   := SYSTEM.CAST(INTEGER,Lib.RANDOM(1000) REM VAL(CARDINAL,cxClient));
	       xRight  := SYSTEM.CAST(INTEGER,Lib.RANDOM(1000) REM VAL(CARDINAL,cxClient));
               yTop    := SYSTEM.CAST(INTEGER,Lib.RANDOM(1000) REM VAL(CARDINAL,cyClient));
	       yBottom := SYSTEM.CAST(INTEGER,Lib.RANDOM(1000) REM VAL(CARDINAL,cyClient));
	       iRed    := SYSTEM.CAST(INTEGER,Lib.RANDOM(1000) + 255);
	       iGreen  := SYSTEM.CAST(INTEGER,Lib.RANDOM(1000) + 255);
	       iBlue   := SYSTEM.CAST(INTEGER,Lib.RANDOM(1000) + 255);
	 
              
               hdc := Windows.GetDC (hwnd);
               hBrush := Windows.CreateSolidBrush (Windows.RGB (iRed, iGreen, iBlue));
               Windows.SelectObject (hdc, SYSTEM.CAST(Windows.HGDIOBJ,hBrush));

               Windows.Rectangle (hdc, MinInt(xLeft, xRight), MinInt (yTop, yBottom),
                               MaxInt (xLeft, xRight), MaxInt (yTop, yBottom));

               Windows.ReleaseDC (hwnd, hdc);
               Windows.DeleteObject (SYSTEM.CAST(Windows.HGDIOBJ,hBrush));
          END;
     END;
     RETURN 0;
END Thread;



    

    

(*++++*****************************************************************)
PROCEDURE [Windows.CALLBACK] WndProc(hwnd       : Windows.HWND;
(**********************************************************************)
                                    iMsg        : Windows.UINT;
                                    wParam      : Windows.WPARAM;
                                    lParam      : Windows.LPARAM) : Windows.LRESULT;
		 
VAR		 
  MessageThread : Threads.Thread;
  threadHandle : Windows.HANDLE;
  tid          : CARDINAL; 
BEGIN
     CASE (iMsg) OF
          | Windows.WM_CREATE :
	       (*
	       threadHandle := Windows.CreateThread(WINX.NIL_SECURITY_ATTRIBUTES,100000,SYSTEM.CAST(Windows.LPTHREAD_START_ROUTINE,Thread),
	       NIL,Windows.CREATE_SUSPENDED,tid);
	       *)
	       Threads.CreateThread(MessageThread, Thread, NIL, 8192, TRUE);
	       RETURN 0;

          | Windows.WM_SIZE :
               cxClient := Windows.LOWORD (lParam);
               cyClient := Windows.HIWORD (lParam);
               RETURN 0;

          | Windows.WM_DESTROY :
               Windows.PostQuitMessage (0);
               RETURN 0;
     ELSE
       RETURN Windows.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
END WndProc;


(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
VAR
  rc    :  CARDINAL;
BEGIN
  wc.cbSize        := SIZE(wc);
  wc.style         := Windows.CS_HREDRAW + Windows.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := Windows.MyInstance();
  wc.hIcon         := Windows.LoadIcon (NIL, Windows.IDI_APPLICATION);
  wc.hCursor       := Windows.LoadCursor (NIL, Windows.IDC_ARROW);
  wc.hbrBackground := SYSTEM.CAST(Windows.HBRUSH, Windows.GetStockObject (Windows.WHITE_BRUSH));
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := Windows.LoadIcon (NIL,Windows.IDI_APPLICATION);

  rc := Windows.RegisterClassEx(wc);
  RETURN rc#0;
END InitApplication;

(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := Windows.CreateWindow (
                       szAppName,                      (* window class name            *)
                       "Random Rectangles: Translation to XDS Modula-2",
                                                       (* window caption               *)
                       Windows.WS_OVERLAPPEDWINDOW,    (* window style                 *)
                       Windows.CW_USEDEFAULT,          (* initial x position           *)
                       Windows.CW_USEDEFAULT,          (* initial y position           *)
                       Windows.CW_USEDEFAULT,          (* initial x size               *)
                       Windows.CW_USEDEFAULT,          (* initial y size               *)
 
                       NIL,                            (* parent window handle         *)
                       NIL,                            (* window menu handle           *)
                       wc.hInstance,                   (* program instance handle      *)
                       NIL);                           (* creation parameters          *)

  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  Windows.ShowWindow (hwnd, Windows.SW_SHOWDEFAULT);
  Windows.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;


BEGIN
  Lib.RANDOMIZE(1000);
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (Windows.GetMessage(msg,NIL,0,0)) DO
      Windows.TranslateMessage(msg);
      Windows.DispatchMessage(msg);
    END;
  END;
END RndRctMT.
