<* +M2EXTENSIONS *>
MODULE FormFeed;
(*---------------------------------------------
   FORMFEED.C      --- Advances printer to next page
                   (c) Charles Petzold, 1996
   FormFeed.mod    --- Translation to XDS Modula-2
                   (c) Peter Stadler,   1997
  ---------------------------------------------*)
IMPORT Windows;

IMPORT SYSTEM;


VAR
  hdcPrint   :  Windows.HDC;
  di         :  Windows.DOCINFO;

(*++++*****************************************************************)
PROCEDURE GetPrinterDC ():Windows.HDC;
(**********************************************************************)
VAR
  pinfo5     :  ARRAY[0..2] OF Windows.PRINTER_INFO_5;
  dwNeeded   :  Windows.DWORD;
  dwReturned :  Windows.DWORD;
BEGIN
     IF (Windows.EnumPrinters (Windows.PRINTER_ENUM_DEFAULT, NIL, 5, SYSTEM.CAST(Windows.PBYTE,SYSTEM.ADR(pinfo5)),
                       SIZE (pinfo5), dwNeeded, dwReturned)) THEN
          RETURN Windows.CreateDC (NIL, pinfo5[0].pPrinterName, NIL, NIL);
     END;
     RETURN NIL;            (* EnumPrinters failed, so RETURN null hdc          *)
END GetPrinterDC;
(*++++*****************************************************************)
CONST
  form = 'FormFeed';
BEGIN
di :=  Windows.DOCINFO{ SIZE(Windows.DOCINFO), SYSTEM.ADR(form), NIL,NIL,0 } ;
     hdcPrint := GetPrinterDC () ;
     IF (hdcPrint # NIL) THEN
          IF (Windows.StartDoc (hdcPrint, di) > 0) THEN
               IF (Windows.StartPage (hdcPrint) > 0) AND (Windows.EndPage (hdcPrint) > 0) THEN
                    Windows.EndDoc (hdcPrint);
               END;
          END;
          Windows.DeleteDC (hdcPrint);
     END;
END FormFeed.
