<* +M2EXTENSIONS *>
IMPLEMENTATION MODULE PopFile;
(*------------------------------------------
   POPFILE.C -- Popup Editor File Functions
  ------------------------------------------*)

IMPORT Storage;

IMPORT Windows;

IMPORT Strings;

IMPORT SYSTEM;
IMPORT FIO;



VAR
  ofn    :   Windows.OPENFILENAME;
TYPE
     STR        =  ARRAY[0..50] OF CHAR;
     Buffer     =  ARRAY[0..MAX(SYSTEM.CARD16)] OF CHAR;
CONST
   szFilter  =
                    "Text Files (*.TXT)"+""+"*.txt"+""+
                    "ASCII Files (*.ASC)"+""+"*.asc"+""+
                    "All Files (*.*)"+""+"*.*";

   txt      = "txt";
   IDSTR_FILTER = 1000;
VAR   
    filter : ARRAY [0..1000] OF CHAR;

(*++++****************************************************************)
PROCEDURE Initialize (hwnd :   Windows.HWND);
(*********************************************************************)
BEGIN
     SYSTEM.FILL(SYSTEM.ADR(filter), 0,SIZE (filter));
     Windows.LoadString (Windows.MyInstance(), IDSTR_FILTER, filter, SIZE (filter));

     SYSTEM.FILL(SYSTEM.ADR(ofn), 0,SIZE (ofn));
     ofn.lStructSize       := SIZE(Windows.OPENFILENAME);
     ofn.hwndOwner         := hwnd;
     ofn.hInstance         := NIL;
     ofn.lpstrFilter       := SYSTEM.ADR(filter);
     ofn.lpstrCustomFilter := NIL;
     ofn.nMaxCustFilter    := 0;
     ofn.nFilterIndex      := 0;
     ofn.lpstrFile         := NIL;          (* Set in Open and Close functions *)
     ofn.nMaxFile          := Windows.MAX_PATH;
     ofn.lpstrFileTitle    := NIL;                                 (* Set in Open and Close functions         *)
     ofn.nMaxFileTitle     := Windows.MAX_FNAME + Windows.MAX_EXT;
     ofn.lpstrInitialDir   := NIL;
     ofn.lpstrTitle        := NIL;
     ofn.Flags             := SYSTEM.CAST(Windows.OFN_SET,0);      (* Set in Open and Close functions         *)
     ofn.nFileOffset       := 0;
     ofn.nFileExtension    := 0;
     ofn.lpstrDefExt       := SYSTEM.ADR(txt);
     ofn.lCustData         := 0000h;
     ofn.lpfnHook          := NIL;
     ofn.lpTemplateName    := NIL;
END Initialize;
(*++++****************************************************************)
PROCEDURE OpenDlg (hwnd            : Windows.HWND;
                   pstrFileName    : Windows.PSTR;
                   pstrTitleName   : Windows.PSTR) : Windows.BOOL;
(*********************************************************************)
BEGIN
     ofn.hwndOwner         := hwnd;
     ofn.lpstrFile         := pstrFileName;
     ofn.lpstrFileTitle    := pstrTitleName;
     ofn.Flags             := Windows.OFN_HIDEREADONLY + Windows.OFN_CREATEPROMPT;

     RETURN Windows.GetOpenFileName (ofn);
END OpenDlg;

(*++++****************************************************************)
PROCEDURE SaveDlg (hwnd         :  Windows.HWND;
                   pstrFileName :  Windows.PSTR;
                   pstrTitleName:  Windows.PSTR) : Windows.BOOL;
(*********************************************************************)
BEGIN
     ofn.hwndOwner         := hwnd;
     ofn.lpstrFile         := pstrFileName;
     ofn.lpstrFileTitle    := pstrTitleName;
     ofn.Flags             := Windows.OFN_OVERWRITEPROMPT;

     RETURN Windows.GetSaveFileName (ofn);
END SaveDlg;

(*++++****************************************************************)
PROCEDURE Length (file   :  FILE) : Windows.LONG;
(*********************************************************************)
VAR
   iFileLength  :  INTEGER;
BEGIN
     iFileLength := FIO.Size(file);
     RETURN iFileLength;
END Length;

(*++++****************************************************************)
PROCEDURE Read (hwndEdit    :  Windows.HWND;
                strFileName:  ARRAY OF CHAR) : Windows.BOOL;
(*********************************************************************)
VAR
     file       :  FILE;
     iLength,iL    :  CARDINAL;
     pstrBuffer :  Windows.PWSTR;

BEGIN
     file := FIO.Open(strFileName);
     iLength := Length (file);

     Storage.ALLOCATE(pstrBuffer,iLength+1);
     IF (pstrBuffer = NIL) THEN
          FIO.Close(file);
          RETURN FALSE;
     END;

     iL := FIO.RdBin(file,pstrBuffer^,iLength);
     IF(iL#iLength) THEN
       FIO.Close(file);
       RETURN FALSE;
     END;
     FIO.Close(file);

     Windows.SetWindowText (hwndEdit, pstrBuffer^);
     Storage.DEALLOCATE(pstrBuffer,iLength+1);

     RETURN TRUE;
END Read;

(*++++****************************************************************)
PROCEDURE Write (hwndEdit     :  Windows.HWND;
                 pstrFileName :  Windows.PSTR ) : Windows.BOOL;
(*********************************************************************)
VAR
     file         : FILE;
     iLength      : CARDINAL;
     pstrBuffer   : POINTER TO Buffer;
BEGIN
     file := FIO.Create(SYSTEM.CAST(STR,pstrFileName^));
     iLength := Windows.GetWindowTextLength (hwndEdit);

     Storage.ALLOCATE(pstrBuffer,iLength+1);
     IF (pstrBuffer = NIL) THEN
          FIO.Close(file);
          RETURN FALSE;
     END;

     Windows.GetWindowText (hwndEdit, pstrBuffer^, iLength + 1);

     FIO.WrBin(file,pstrBuffer^,iLength);

     FIO.Close(file);
     Storage.DEALLOCATE(pstrBuffer,iLength+1);

     RETURN TRUE;
END Write;
BEGIN
END PopFile.
