<* +M2EXTENSIONS *>
IMPLEMENTATION MODULE PopFont;
(*------------------------------------------
   POPFONT.C -- Popup Editor Font Functions
  ------------------------------------------*)


IMPORT Windows;


IMPORT SYSTEM;
VAR
  logfont  :  Windows.LOGFONT;
  hFont    :  Windows.HFONT;

(*++++****************************************************************)
PROCEDURE ChooseFont (hwnd : Windows.HWND) : BOOLEAN;
(*********************************************************************)
VAR
  cf   : Windows.CHOOSEFONT;
BEGIN
     cf.lStructSize      := SIZE (Windows.CHOOSEFONT);
     cf.hwndOwner        := hwnd;
     cf.hDC              := NIL;
     cf.lpLogFont        := SYSTEM.ADR(logfont);
     cf.iPointSize       := 0;
     cf.Flags            := Windows.CF_INITTOLOGFONTSTRUCT + Windows.CF_SCREENFONTS
                                                  + Windows.CF_EFFECTS;
     cf.rgbColors        := 0000h;
     cf.lCustData        := 0000h;
     cf.lpfnHook         := NIL;
     cf.lpTemplateName   := NIL;
     cf.hInstance        := NIL;
     cf.lpszStyle        := NIL;
     cf.nFontType        := 0;               (* Returned from ChooseFont  *)
     cf.nSizeMin         := 0;
     cf.nSizeMax         := 0;   

     RETURN Windows.ChooseFont (cf);
END ChooseFont;

(*++++****************************************************************)
PROCEDURE Initialize (hwndEdit : Windows.HWND);
(*++++****************************************************************)
BEGIN
     Windows.GetObject (Windows.GetStockObject (Windows.SYSTEM_FONT), SIZE (Windows.LOGFONT),
                                              logfont);
     hFont := Windows.CreateFontIndirect (logfont);
     Windows.SendMessage (hwndEdit, Windows.WM_SETFONT, SYSTEM.CAST(Windows.WPARAM, hFont), 0);
END Initialize;
(*++++****************************************************************)
PROCEDURE SetFont (hwndEdit : Windows.HWND);
(*++++****************************************************************)
VAR
     hFontNew:Windows.HFONT;
     rect    :Windows.RECT;
BEGIN
     hFontNew := Windows.CreateFontIndirect (logfont);
     Windows.SendMessage (hwndEdit, Windows.WM_SETFONT, SYSTEM.CAST(Windows.WPARAM,hFontNew), 0);
     Windows.DeleteObject (SYSTEM.CAST(Windows.HGDIOBJ,hFont));
     hFont := hFontNew;
     Windows.GetClientRect (hwndEdit, rect);
     Windows.InvalidateRect (hwndEdit, rect, TRUE);
END SetFont;

(*++++****************************************************************)
PROCEDURE Deinitialize ();
(*********************************************************************)
BEGIN
     Windows.DeleteObject (SYSTEM.CAST(Windows.HGDIOBJ,hFont));
END Deinitialize;
BEGIN
END PopFont.
