<* +M2EXTENSIONS *>
IMPLEMENTATION MODULE PopPrnt;
(*----------------------------------------------
   POPPRNT.C -- Popup Editor Printing Functions
  ----------------------------------------------*)


IMPORT Windows;


IMPORT SYSTEM;
IMPORT h2d_PopPad;

VAR
  bUserAbort :  Windows.BOOL;
  hDlgPrint  :  Windows.HWND;
VAR di  :  Windows.DOCINFO;
    pd  :  Windows.PRINTDLG;



    

    

(*++++*****************************************************************)
PROCEDURE [Windows.CALLBACK] PrintDlgProc (hDlg   : Windows.HWND;
                                     msg          : Windows.UINT;
                                     wParam       : Windows.WPARAM;
                                     lParam       : Windows.LPARAM) : Windows.BOOL;
(**********************************************************************)
BEGIN
     CASE (msg) OF
          | Windows.WM_INITDIALOG :
               Windows.EnableMenuItem (Windows.GetSystemMenu (hDlg, FALSE), Windows.SC_CLOSE,
                                                            Windows.MF_GRAYED);
               RETURN TRUE;

          | Windows.WM_COMMAND :
               bUserAbort := TRUE;
               Windows.EnableWindow (Windows.GetParent (hDlg), TRUE);
               Windows.DestroyWindow (hDlg);
               hDlgPrint := SYSTEM.CAST(Windows.HWND,0);
               RETURN TRUE;
     ELSE
       RETURN FALSE;
     END;
END PrintDlgProc;





    

    

(*++++*****************************************************************)
PROCEDURE [Windows.CALLBACK] AbortProc (hPrinterDC     : Windows.HDC;
                                           iCode       : INTEGER) : Windows.BOOL;
(**********************************************************************)
VAR
  msg   :  Windows.MSG;
BEGIN
     WHILE (bUserAbort=FALSE) AND (Windows.PeekMessage (msg, NIL, 0, 0, Windows.PM_REMOVE)=TRUE) DO
          IF (hDlgPrint=SYSTEM.CAST(Windows.HWND,0)) OR (Windows.IsDialogMessage (hDlgPrint,msg)=FALSE) THEN
               Windows.TranslateMessage (msg);
               Windows.DispatchMessage (msg);
          END;
     END;
     RETURN NOT bUserAbort;
END AbortProc;



(*++++*****************************************************************)
PROCEDURE PrintFile (hInst        : Windows.HINSTANCE;
                     hwnd         : Windows.HWND;
                     hwndEdit     : Windows.HWND;
                     szTitleName  : Windows.PSTR) : Windows.BOOL;
(**********************************************************************)
VAR
  bSuccess       : Windows.BOOL;
  pstrBuffer     : Windows.PCTSTR;
  yChar          : INTEGER;
  iCharsPerLine  : INTEGER;
  iLinesPerPage  : INTEGER;
  iTotalLines    : INTEGER;
  iTotalPages    : INTEGER;
  iPage          : INTEGER;
  iLine          : INTEGER;
  iLineNum       : INTEGER;
  tm             : Windows.TEXTMETRIC;
  iColCopy       : CARDINAL;
  iNoiColCopy    : CARDINAL;
  i              : CARDINAL;
  j              : CARDINAL;
  rc             : INTEGER;
CONST
  prDi           =  "PrintDlgBox";
BEGIN
     di :=  Windows.DOCINFO{ SIZE (Windows.DOCINFO), NIL,NIL,NIL,0};
     pd.lStructSize         := SIZE (Windows.PRINTDLG);
     pd.hwndOwner           := hwnd;
     pd.hDevMode            := NIL;
     pd.hDevNames           := NIL;
     pd.hDC                 := NIL;
     pd.Flags               := Windows.PD_ALLPAGES + Windows.PD_COLLATE + Windows.PD_RETURNDC;
     pd.nFromPage           := 1;           (* Korrektur von G. Born    *)
     pd.nToPage             := 0FFFFh;      (* Werte von 0 auf 1 bzw.   *)
     pd.nMinPage            := 1;           (* 0xFFFF gesetzt, damit    *)
     pd.nMaxPage            := 0FFFFh;      (* Sortieren funktioniert   *)
     pd.nCopies             := 1;
     pd.hInstance           := NIL;
     pd.lCustData           := 0000h;
     pd.lpfnPrintHook       := NIL;
     pd.lpfnSetupHook       := NIL;
     pd.lpPrintTemplateName := NIL;
     pd.lpSetupTemplateName := NIL;
     pd.hPrintTemplate      := NIL;
     pd.hSetupTemplate      := NIL;

     IF ( NOT Windows.PrintDlg (pd)) THEN
          RETURN TRUE;
     END;  (* *)
     iTotalLines := SYSTEM.CAST(Windows.SHORT, Windows.SendMessage (hwndEdit, Windows.EM_GETLINECOUNT, 0, 0000h));

     IF (iTotalLines = 0) THEN
          RETURN TRUE;
     END;
     Windows.GetTextMetrics (pd.hDC, tm);
     yChar := tm.tmHeight + tm.tmExternalLeading;

     iCharsPerLine := Windows.GetDeviceCaps (pd.hDC, Windows.HORZRES) / tm.tmAveCharWidth;
     iLinesPerPage := Windows.GetDeviceCaps (pd.hDC, Windows.VERTRES) / yChar;
     iTotalPages   := (iTotalLines + iLinesPerPage - 1) / iLinesPerPage;

     pstrBuffer := SYSTEM.CAST(Windows.PCTSTR,Windows.HeapAlloc (Windows.GetProcessHeap (),
                                               Windows.HEAP_NO_SERIALIZE, iCharsPerLine + 1));

     Windows.EnableWindow (hwnd, FALSE);

     bSuccess   := TRUE;
     bUserAbort := FALSE;

     hDlgPrint := Windows.CreateDialog (hInst,SYSTEM.ADR(prDi), hwnd, PrintDlgProc);
     Windows.SetDlgItemText (hDlgPrint, h2d_PopPad.IDD_FNAME, szTitleName^);

     rc := Windows.SetAbortProc (pd.hDC, SYSTEM.CAST(Windows.ABORTPROC,AbortProc));

     Windows.GetWindowText (hwnd, di.lpszDocName^, SIZE (Windows.PTSTR));

     IF (Windows.StartDoc (pd.hDC, di) > 0) THEN
          IF((SYSTEM.CAST(Windows.WORD,pd.Flags - Windows.PD_COLLATE))#0) THEN
            i := VAL(CARDINAL,pd.nCopies);
          ELSE
            i := 1;
          END;

          iColCopy := 0;
          LOOP
               iPage := 0;
               LOOP
                 IF(pd.Flags - Windows.PD_COLLATE#SYSTEM.CAST(Windows.PD_SET,0)) THEN
                   j := VAL(CARDINAL,pd.nCopies);
                 ELSE
                   j := 1;
                 END;
                    iNoiColCopy := 0;
                    LOOP
                         IF (Windows.StartPage (pd.hDC) < 0) THEN
                              bSuccess := FALSE;
                            EXIT;
                         END;

                         iLine := 0;
                         LOOP

                              iLineNum := iLinesPerPage * iPage + iLine;

                              IF (iLineNum > iTotalLines) THEN
                                 EXIT;
                              END;
                              pstrBuffer := SYSTEM.CAST(Windows.PCTSTR,SYSTEM.ADR(iCharsPerLine));

                              Windows.TextOut (pd.hDC, 0, yChar * iLine, pstrBuffer^,
                                   Windows.SendMessage (hwndEdit, Windows.EM_GETLINE,
                                   iLineNum,
                                   SYSTEM.CAST(Windows.WPARAM,pstrBuffer)));
                              INC(iLine);
                              IF(iLine>iLinesPerPage) THEN
                                EXIT;
                              END;
                         END;
                         INC(iNoiColCopy);
                         IF(iNoiColCopy>j) THEN
                           EXIT;
                         END;
                         IF (Windows.EndPage (pd.hDC) < 0) THEN
                              bSuccess := FALSE;
                              EXIT;
                         END;

                         IF (bUserAbort) THEN
                              EXIT;
                         END;
                    END;
                    IF ( NOT bSuccess OR bUserAbort) THEN
                         EXIT;
                    END;
                    INC(iPage);
                    IF(iPage>=iTotalPages) THEN
                      EXIT;
                    END;
               END;
               IF ( NOT bSuccess OR bUserAbort) THEN
                    EXIT;
               END;
               INC(iColCopy);
               IF(iColCopy>i-1) THEN
                 EXIT;
               END;
          END;
     ELSE
          bSuccess := FALSE;
     END;
     IF (bSuccess) THEN
          Windows.EndDoc (pd.hDC);
     END;
     IF ( NOT bUserAbort) THEN
          Windows.EnableWindow (hwnd, TRUE);
          Windows.DestroyWindow (hDlgPrint);
     END;

     Windows.HeapFree (Windows.GetProcessHeap (), SYSTEM.CAST(Windows.HEAP_SET,0), SYSTEM.CAST(Windows.PVOID,pstrBuffer));
     Windows.DeleteDC (pd.hDC);

     RETURN bSuccess AND NOT bUserAbort;
END PrintFile;

BEGIN
END PopPrnt.
