<* +M2EXTENSIONS *>
MODULE ClipView;
(*-----------------------------------------
   CLIPVIEW.C      --- Simple Clipboard Viewer
                   (c) Charles Petzold, 1996
   ClipView.mod    --- Translation to XDS Modula-2
                   (c) Peter Stadler,   1997
  -----------------------------------------*)


IMPORT Windows;


IMPORT SYSTEM;

CONST
  szAppName=  "ClipView";
VAR
   hwnd            :  Windows.HWND;
   msg             :  Windows.MSG;
   wc              :  Windows.WNDCLASSEX;

   hwndNextViewer  :  Windows.HWND;
   hGMem           :  Windows.HGLOBAL;
   hdc             :  Windows.HDC;
   pGMem           :  Windows.PSTR;
   ps              :  Windows.PAINTSTRUCT;
   rect            :  Windows.RECT;
   rc              :  Windows.RECT;



    

    

(*++++*****************************************************************)
PROCEDURE [Windows.CALLBACK] WndProc (hwnd        : Windows.HWND;
(**********************************************************************)
                                      iMsg        : Windows.UINT;
                                      wParam      : Windows.WPARAM;
                                      lParam      : Windows.LPARAM) : Windows.LRESULT;

BEGIN

  CASE (iMsg)  OF
          | Windows.WM_CREATE :
               hwndNextViewer := Windows.SetClipboardViewer (hwnd);
               RETURN 0;

          | Windows.WM_CHANGECBCHAIN :
               IF (SYSTEM.CAST(Windows.HWND,wParam) = hwndNextViewer) THEN
                    hwndNextViewer := SYSTEM.CAST(Windows.HWND,lParam);

               ELSIF (hwndNextViewer#NIL) THEN
                    Windows.SendMessage (hwndNextViewer, iMsg, wParam, lParam);
               END;
               RETURN 0;

          | Windows.WM_DRAWCLIPBOARD :
               IF (hwndNextViewer#NIL) THEN
                    Windows.SendMessage (hwndNextViewer, iMsg, wParam, lParam);
               END;
               Windows.InvalidateRect (hwnd, rc, TRUE);
               RETURN 0;

          | Windows.WM_PAINT :
               hdc := Windows.BeginPaint (hwnd, ps);
               Windows.GetClientRect (hwnd, rect);
               Windows.OpenClipboard (hwnd);

               hGMem := SYSTEM.CAST(Windows.HGLOBAL,Windows.GetClipboardData (Windows.CF_TEXT));

               IF (hGMem # NIL) THEN
                    pGMem := SYSTEM.CAST(Windows.PSTR,Windows.GlobalLock (hGMem));
                    Windows.DrawText (hdc, pGMem, -1, rect, Windows.DT_EXPANDTABS);
                    Windows.GlobalUnlock (hGMem);
               END;
               Windows.CloseClipboard ();
               Windows.EndPaint (hwnd, ps);
               RETURN 0;

          | Windows.WM_DESTROY :
               Windows.ChangeClipboardChain (hwnd, hwndNextViewer);
               Windows.PostQuitMessage (0);
               RETURN 0;
     ELSE
               RETURN Windows.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
END WndProc;

(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
BEGIN

  wc.cbSize        := SIZE(wc);
  wc.style         := Windows.CS_HREDRAW   + Windows.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := Windows.MyInstance();
  wc.hIcon         := NIL;
  wc.hCursor       := Windows.LoadCursor (NIL, Windows.IDC_ARROW);
  wc.hbrBackground := SYSTEM.CAST(Windows.HBRUSH, Windows.GetStockObject (Windows.WHITE_BRUSH));
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := Windows.LoadIcon (NIL,Windows.IDI_APPLICATION);
  RETURN Windows.RegisterClassEx(wc)#0;
END InitApplication;

(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := Windows.CreateWindow (
                       SYSTEM.ADR(szAppName),          (* window class name            *)
                       "Simple Clipboard Viewer (Text only): XDS Modula-2",
                                                       (* window caption               *)
                       Windows.WS_OVERLAPPEDWINDOW,    (* window style                 *)
                       Windows.CW_USEDEFAULT,          (* initial x position           *)
                       Windows.CW_USEDEFAULT,          (* initial y position           *)
                       Windows.CW_USEDEFAULT,          (* initial x size               *)
                       Windows.CW_USEDEFAULT,          (* initial y size               *)
                       NIL,                            (* parent window handle         *)
                       NIL,                            (* window menu handle           *)
                       wc.hInstance,                   (* program instance handle      *)
                       NIL);                           (* creation parameters          *)

  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  Windows.ShowWindow (hwnd, Windows.SW_SHOWDEFAULT);
  Windows.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;


BEGIN
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (Windows.GetMessage(msg,NIL,0,0)) DO
      Windows.TranslateMessage(msg);
      Windows.DispatchMessage(msg);
    END;
  END;
END ClipView.
